/*
 * Decompiled with CFR 0.152.
 */
package invaders;

import com.shavenpuppy.jglib.util.Util;
import invaders.Behaviour;
import invaders.EnemyBullet;
import invaders.EnemyBulletFeature;
import invaders.Entity;
import invaders.GameScreen;
import invaders.Gidrah;
import invaders.Invaders;
import invaders.Level;
import invaders.Parachute;
import invaders.Player;
import invaders.PowerupFeature;
import invaders.Res;
import invaders.SFX;
import invaders.Saucer;
import invaders.SelectWorldScreen;
import invaders.ShopPrices;
import invaders.ShopScreen;
import invaders.behaviours.Centipede;
import invaders.behaviours.Galaxian;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import net.puppygames.applet.Game;
import net.puppygames.applet.GameState;
import net.puppygames.applet.MiniGame;
import net.puppygames.applet.PrizeFeature;
import net.puppygames.applet.Screen;
import net.puppygames.applet.effects.LabelEffect;
import net.puppygames.steam.Steam;
import net.puppygames.steam.SteamException;
import org.lwjgl.input.Keyboard;
import org.lwjgl.util.ReadableColor;

public class InvadersGameState
extends GameState {
    private static final long serialVersionUID = 2L;
    private static final int DEFAULT_SHIELDS = 3;
    private static final int MAX_SHIELDS = 8;
    public static final int MAX_SMARTS = 3;
    private static final int MAX_MULTIPLIER = 9;
    private static final float MULTIPLIER_FACTOR = 0.5f;
    private static final int DIFFICULTY_CAP = 50;
    private static final int MAX_SMARTBOMB_PRICE = 9900;
    private static final int SAVE_DURATION = 45;
    private static final int END_OF_LEVEL_DURATION = 180;
    private static final int WAIT_FOR_BOSS_DURATION = 240;
    private static final int BOSS_DEFEATED_DURATION = 360;
    private static final int CHALLENGE_BEGIN_DURATION = 360;
    private static final int CHALLENGE_DURATION = 800;
    private static final int CHALLENGE_DURATION_PER_LEVEL = 10;
    private static final int MAX_CHALLENGE_DURATION = 1000;
    private static final int CHALLENGE_SPAWN_RATE = 70;
    private static final int MIN_CHALLENGE_SPAWN_RATE = 15;
    private static final float CHALLENGE_SPAWN_RATE_PER_LEVEL = 0.33f;
    private static final int CHALLENGE_END_DURATION = 480;
    private static final int END_OF_GAME_DURATION = 480;
    private static final int SAUCER_KILLS = 10;
    private static final int INITIAL_SAUCER_VALUE = 100;
    private static final int SAUCER_VALUE_INCREMENT = 100;
    private transient int saveTick;
    private transient boolean saving;
    private int shields = 3;
    private int gunPower = 0;
    private final int gunReloadRate = 0;
    private int extraBullets = 0;
    private int recharge = 0;
    private int smartBombs = 0;
    private int smartBombPrice = 500;
    private int addOn = 0;
    private int score = 0;
    private int money = 0;
    private int level = -1;
    private transient Level currentLevel;
    private int multiplier;
    private int totalMultiplier = (this.level + 1) * 4;
    private boolean damaged;
    private final ArrayList entities = new ArrayList();
    private int tick;
    private int totalTicks;
    private Player player;
    private int meteorTick;
    private int saucerKills = 0;
    private int saucerValue = 100;
    private int phase;
    private static final int PHASE_NORMAL = 0;
    private static final int PHASE_END_OF_LEVEL = 1;
    private static final int PHASE_CHALLENGE_BEGIN = 2;
    private static final int PHASE_CHALLENGE = 3;
    private static final int PHASE_CHALLENGE_END = 4;
    private static final int PHASE_WAIT_FOR_BOSS = 5;
    private static final int PHASE_BOSS = 6;
    private static final int PHASE_BOSS_DEFEATED = 7;
    private static final int PHASE_END_OF_GAME = 8;
    private static final String[] BOSS_MESSAGES = new String[]{"SAVE THE EARTH!", "SAVE THE MOON!", "SAVE MARS!", "DEFEAT THE GUARDIAN!", "DESTROY THE ALIEN BRAIN!"};
    private static final String[] PLANET_NAMES = new String[]{"EARTH SECURED!", "MOON SECURED!", "MARS SECURED!", "SATURN CONQUERED!", "ALIEN INVASION THWARTED!"};
    private static final String[] NEXT_PLANET = new String[]{"On To The Moon!", "On To Mars!", "Now Invade Saturn!", "To the Alien Homeworld!", "YOU ARE A HERO!"};
    private int captured;
    private int murdered;
    private int escaped;
    private int saucersShot;
    private int skillShots;
    private int smartbombsFired;

    private void maybeCheckpoint() {
        if (this.level % 20 != 19 || this.level >= 100) {
            return;
        }
        Preferences prefs = Game.getRoamingPreferences();
        boolean update = prefs.getInt("checkpoint", 0) >= this.level + 1;
        System.out.println("Checkpoint " + (this.level + 1));
        if (!update) {
            prefs.putInt("checkpoint", this.level + 1);
            System.out.println("Set best checkpoint to " + (this.level + 1));
        }
        Preferences checkPoint = prefs.node(String.valueOf(this.level + 1));
        checkPoint.putInt("checkpointMoney", this.money);
        checkPoint.putInt("checkpointScore", this.score);
        checkPoint.putInt("checkpointSmartBombs", this.smartBombs);
        checkPoint.putInt("checkpointSmartBombPrice", this.smartBombPrice);
        checkPoint.putInt("checkpointShields", this.shields);
        checkPoint.putInt("checkpointAddOn", this.addOn);
        checkPoint.putInt("checkpointGunPower", this.gunPower);
        checkPoint.putInt("checkpointExtraBullets", this.extraBullets);
        checkPoint.putInt("checkpointRecharge", this.recharge);
        checkPoint.putInt("checkpointTotalMultiplier", this.totalMultiplier);
        checkPoint.putInt("checkpointSaucerKills", this.saucerKills);
        checkPoint.putInt("checkpointSaucerValue", this.saucerValue);
        Game.flushPrefs();
        LabelEffect label = new LabelEffect(net.puppygames.applet.Res.getSmallFont(), "CHECKPOINT " + (update ? "UPDATED" : "REACHED"), ReadableColor.YELLOW, ReadableColor.RED, 30, 120);
        label.setLocation((float)(Game.getScale() / 2), (float)(Game.getScale() / 2 + 65));
        label.setVisible(true);
        label.spawn((Screen)GameScreen.getInstance());
    }

    private void loadCheckpoint(int level) {
        if (level == 0 || level % 20 != 0 || level >= 100) {
            return;
        }
        try {
            if (!Game.getRoamingPreferences().nodeExists(String.valueOf(level))) {
                System.out.println("No checkpoint data available for level " + level);
                return;
            }
        }
        catch (BackingStoreException e) {
            e.printStackTrace(System.err);
            return;
        }
        this.level = level - 1;
        Preferences checkPoint = Game.getRoamingPreferences().node(String.valueOf(level));
        this.money = checkPoint.getInt("checkpointMoney", 0);
        this.score = checkPoint.getInt("checkpointScore", 0);
        this.smartBombs = checkPoint.getInt("checkpointSmartBombs", 0);
        this.smartBombPrice = checkPoint.getInt("checkpointSmartBombPrice", 500);
        this.shields = checkPoint.getInt("checkpointShields", 0);
        this.addOn = checkPoint.getInt("checkpointAddOn", 0);
        this.gunPower = checkPoint.getInt("checkpointGunPower", 0);
        this.extraBullets = checkPoint.getInt("checkpointExtraBullets", 0);
        this.recharge = checkPoint.getInt("checkpointRecharge", 0);
        this.totalMultiplier = checkPoint.getInt("checkpointTotalMultiplier", 0);
        this.saucerKills = checkPoint.getInt("checkpointSaucerKills", 0);
        this.saucerValue = checkPoint.getInt("checkpointSaucerValue", 0);
    }

    public void nextLevel() {
        ++this.level;
        if (this.level == 5) {
            InvadersGameState.setPrizeCheckpointReached();
        }
        this.currentLevel = Level.getLevel(this.level);
        GameScreen.beginLevel();
        this.totalMultiplier += 10;
        if (!this.damaged) {
            this.incMultiplier();
        }
        this.damaged = false;
        this.entities.clear();
        this.phase = 0;
        this.tick = 0;
        this.entities.clear();
        this.meteorTick = Util.random((int)0, (int)this.currentLevel.getMeteorFrequency());
        Gidrah.getGidrahs().clear();
        Centipede.reset();
        this.player = new Player();
        this.player.spawn(GameScreen.getInstance());
        LabelEffect newLevelEffect = new LabelEffect(net.puppygames.applet.Res.getBigFont(), "Wave " + (Invaders.getGameState().getCurrentLevel().getIndex() + 1), ReadableColor.WHITE, ReadableColor.BLUE, 320, 120);
        newLevelEffect.setLocation((float)(Game.getScale() / 2), (float)Game.getScale() * 0.8f);
        newLevelEffect.setVisible(true);
        newLevelEffect.spawn((Screen)GameScreen.getInstance());
        if (this.multiplier > 1) {
            LabelEffect le = new LabelEffect(net.puppygames.applet.Res.getSmallFont(), "Times " + this.multiplier + " Multiplier Active", ReadableColor.WHITE, ReadableColor.BLUE, 320, 120);
            le.setLocation((float)(Game.getScale() / 2), (float)Game.getScale() * 0.8f - 20.0f);
            le.setVisible(true);
            le.setDelay(30);
            le.setSound(Res.getMultiplierActiveSound(this.multiplier));
            le.spawn((Screen)GameScreen.getInstance());
        }
        try {
            List gidrahs = this.currentLevel.createGidrahs();
            for (Gidrah gidrah : gidrahs) {
                gidrah.spawn(GameScreen.getInstance());
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public void damageShields() {
        --this.shields;
        this.damaged = true;
        this.resetMultiplier();
    }

    public void maxShields() {
        this.shields = 8;
    }

    public void increaseShields() {
        this.shields = Math.min(8, this.shields + 1);
    }

    public int getTotalLevels() {
        return 50;
    }

    public Level getCurrentLevel() {
        return this.currentLevel;
    }

    public int getLevel() {
        return this.level;
    }

    public int getScore() {
        return this.score;
    }

    public int getMoney() {
        return this.money;
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    public void incMultiplier() {
        this.multiplier = Math.min(9, this.multiplier + 1);
        if (this.multiplier == 9) {
            this.awardMedal("multiplier");
        }
    }

    public void resetMultiplier() {
        this.multiplier = 1;
    }

    public void addScore(int pointsDelta) {
        this.score += pointsDelta;
        if (this.score < 0) {
            this.score = 0;
        }
    }

    public void addMoney(int moneyDelta) {
        this.money += moneyDelta;
        if (this.money < 0) {
            this.money = 0;
        }
    }

    public void addEntity(Entity entity) {
        this.entities.add(entity);
    }

    public int getAddOn() {
        return this.addOn;
    }

    public int getGunReloadRate() {
        return 0;
    }

    public int getExtraBullets() {
        return this.extraBullets;
    }

    public int getGunPower() {
        return this.gunPower;
    }

    public int getShields() {
        return this.shields;
    }

    public int getShipSpeed() {
        return this.recharge;
    }

    public int getSmartBombs() {
        return this.smartBombs;
    }

    public void adjustSmartBombs(int delta) {
        this.smartBombs = Math.max(0, Math.min(3, this.smartBombs + delta));
        this.checkShip();
    }

    public void buyGunPower() {
        this.money -= ShopPrices.GUN_POWER[this.gunPower++];
        this.checkShip();
    }

    public void adjustGunPower(int amount) {
        this.gunPower += amount;
        this.checkShip();
    }

    public void buyExtraBullets() {
        this.money -= ShopPrices.EXTRA_BULLETS[this.extraBullets++];
        this.checkShip();
    }

    public void buyShields() {
        this.money -= ShopPrices.SHIELDS[this.shields++] * (1 + this.level / 100);
        this.checkShip();
    }

    public void buyAddOn() {
        this.money -= ShopPrices.ADDON[this.addOn++];
        this.checkShip();
    }

    public void buySmartBomb() {
        this.money -= this.smartBombPrice;
        this.smartBombPrice = Math.min(9900, this.smartBombPrice + 100);
        this.adjustSmartBombs(1);
    }

    public void buyRecharge() {
        this.money -= ShopPrices.RECHARGE[this.recharge++];
        this.checkShip();
    }

    private void checkShip() {
        int count = 0;
        if (ShopPrices.ADDON[this.addOn] == -1) {
            this.awardMedal("max_addons");
            ++count;
        }
        if (ShopPrices.GUN_POWER[this.gunPower] == -1) {
            this.awardMedal("max_gun_power");
            ++count;
        }
        if (ShopPrices.EXTRA_BULLETS[this.extraBullets] == -1) {
            this.awardMedal("max_bullets");
            ++count;
        }
        if (ShopPrices.RECHARGE[this.recharge] == -1) {
            this.awardMedal("max_addon_power");
            ++count;
        }
        if (count == 4) {
            this.awardMedal("ultimate_weapon");
        }
        if (ShopPrices.SHIELDS[this.shields] == -1 && this.smartBombs == 3 && count == 4) {
            this.awardMedal("ultimate_ship");
        }
    }

    public boolean canBuyGunPower() {
        return this.money >= ShopPrices.GUN_POWER[this.gunPower] && ShopPrices.GUN_POWER[this.gunPower] != -1;
    }

    public boolean canBuyExtraBullets() {
        return this.money >= ShopPrices.EXTRA_BULLETS[this.extraBullets] && ShopPrices.EXTRA_BULLETS[this.extraBullets] != -1;
    }

    public boolean canBuyShields() {
        return this.money >= ShopPrices.SHIELDS[this.shields] && ShopPrices.SHIELDS[this.shields] != -1;
    }

    public boolean canBuySmartBombs() {
        return this.money >= this.smartBombPrice && this.smartBombs < 3;
    }

    public boolean canBuyAddOns() {
        return this.money >= ShopPrices.ADDON[this.addOn] && ShopPrices.ADDON[this.addOn] != -1;
    }

    public boolean canBuyRecharge() {
        return this.addOn > 0 && this.money >= ShopPrices.RECHARGE[this.recharge] && ShopPrices.RECHARGE[this.recharge] != -1;
    }

    public void cleanup() {
    }

    public Player getPlayer() {
        return this.player;
    }

    public int getTick() {
        return this.tick;
    }

    public int getTotalTicks() {
        return this.totalTicks;
    }

    public void resetTotalTicks() {
        this.totalTicks = 0;
    }

    private void tickAllEntities() {
        int i = 0;
        while (i < this.entities.size()) {
            Entity src = (Entity)this.entities.get(i);
            if (!src.isActive()) {
                this.entities.remove(i);
                continue;
            }
            int j = i + 1;
            while (j < this.entities.size() && src.isActive()) {
                Entity dest = (Entity)this.entities.get(j);
                if (!dest.isActive()) {
                    this.entities.remove(j);
                    continue;
                }
                if (src.canCollide() && dest.canCollide() && src.isTouching(dest)) {
                    src.onCollision(dest);
                    dest.onCollision(src);
                    if (!src.isActive()) {
                        this.entities.remove(i--);
                        break;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private void tickNormal() {
        Galaxian.tickGalaxians();
        this.doSaucers();
        this.doMeteors();
        if (Gidrah.getGidrahs().size() == 0 && Parachute.getNumParachutes() == 0 && Saucer.numSaucers() == 0 && PowerupFeature.numPowerups() == 0 && this.player.isAlive()) {
            this.tick = 0;
            if (this.level % 20 == 19) {
                this.phase = 5;
                LabelEffect challengeEffect = new LabelEffect(net.puppygames.applet.Res.getBigFont(), "THE ALIEN MOTHERSHIP", ReadableColor.YELLOW, ReadableColor.RED, 60, 240);
                challengeEffect.setLocation((float)(Game.getScale() / 2), (float)(Game.getScale() / 2 + 40));
                challengeEffect.setVisible(true);
                challengeEffect.spawn((Screen)GameScreen.getInstance());
                LabelEffect challengeEffect2 = new LabelEffect(net.puppygames.applet.Res.getSmallFont(), "Fight To The Death!!!", ReadableColor.YELLOW, ReadableColor.RED, 60, 240);
                challengeEffect2.setLocation((float)(Game.getScale() / 2), (float)(Game.getScale() / 2));
                challengeEffect2.setVisible(true);
                challengeEffect2.spawn((Screen)GameScreen.getInstance());
                challengeEffect2.setDelay(120);
            } else if (this.level % 7 == 6) {
                this.phase = 2;
                LabelEffect challengeEffect = new LabelEffect(net.puppygames.applet.Res.getBigFont(), "CHALLENGE STAGE", ReadableColor.YELLOW, ReadableColor.RED, 60, 240);
                challengeEffect.setLocation((float)(Game.getScale() / 2), (float)(Game.getScale() / 2 + 40));
                challengeEffect.setVisible(true);
                challengeEffect.spawn((Screen)GameScreen.getInstance());
                LabelEffect challengeEffect2 = new LabelEffect(net.puppygames.applet.Res.getSmallFont(), "Shoot all saucers", ReadableColor.YELLOW, ReadableColor.RED, 60, 240);
                challengeEffect2.setLocation((float)(Game.getScale() / 2), (float)(Game.getScale() / 2));
                challengeEffect2.setVisible(true);
                challengeEffect2.spawn((Screen)GameScreen.getInstance());
                challengeEffect2.setDelay(120);
                LabelEffect challengeEffect3 = new LabelEffect(net.puppygames.applet.Res.getSmallFont(), "Perfection wins prizes", ReadableColor.YELLOW, ReadableColor.RED, 60, 240);
                challengeEffect3.setLocation((float)(Game.getScale() / 2), (float)(Game.getScale() / 2 - 20));
                challengeEffect3.setVisible(true);
                challengeEffect3.spawn((Screen)GameScreen.getInstance());
                challengeEffect3.setDelay(240);
            } else {
                this.phase = 1;
                LabelEffect challengeEffect = new LabelEffect(net.puppygames.applet.Res.getBigFont(), "Wave Completed", ReadableColor.WHITE, ReadableColor.BLUE, 60, 240);
                challengeEffect.setLocation((float)(Game.getScale() / 2), (float)(Game.getScale() / 2));
                challengeEffect.setVisible(true);
                challengeEffect.spawn((Screen)GameScreen.getInstance());
                SFX.waveCompleted();
            }
        }
    }

    private void tickEndOfLevel() {
        if (this.tick == 1) {
            switch (this.level) {
                case 19: {
                    this.awardMedal("earth");
                    break;
                }
                case 39: {
                    this.awardMedal("moon");
                    break;
                }
                case 59: {
                    this.awardMedal("mars");
                    break;
                }
                case 79: {
                    this.awardMedal("saturn");
                    break;
                }
                case 99: {
                    this.awardMedal("titan");
                    break;
                }
            }
        } else if (this.tick == 180) {
            if (this.player.isAlive()) {
                ShopScreen.show();
            } else {
                MiniGame.gameOver();
            }
        }
    }

    private void tickChallengeBegin() {
        if (this.tick == 360) {
            this.phase = 3;
            this.tick = 0;
            Saucer.resetChallenge();
        }
    }

    private void tickChallenge() {
        String prize;
        int bonus;
        block31: {
            block32: {
                int ratio;
                block30: {
                    if (this.tick < Math.min(1000, 800 + 10 * this.level)) {
                        if (this.tick % (int)Math.max(15.0f, 70.0f - 0.33f * (float)this.level) == 0) {
                            Saucer saucer = new Saucer();
                            saucer.setChallenge(true);
                            saucer.spawn(GameScreen.getInstance());
                        }
                        return;
                    }
                    if (Saucer.getNumberRemoved() < Saucer.getNumberSpawned()) {
                        return;
                    }
                    this.phase = 4;
                    this.tick = 0;
                    LabelEffect bonusEffect = new LabelEffect(net.puppygames.applet.Res.getBigFont(), "CHALLENGE COMPLETE", ReadableColor.YELLOW, ReadableColor.RED, 60, 240);
                    bonusEffect.setLocation((float)(Game.getScale() / 2), (float)(Game.getScale() / 2 + 40));
                    bonusEffect.setVisible(true);
                    bonusEffect.setSound(Res.getChallengeComplete());
                    bonusEffect.spawn((Screen)GameScreen.getInstance());
                    ratio = 100 * Saucer.getNumberShot() / Saucer.getNumberSpawned();
                    if (ratio == 100 && this.level >= 6 && this.level <= 97) {
                        this.awardMedal("perfect_challenge_" + (this.level + 1));
                    }
                    String message = ratio == 100 ? "PERFECT!" : "Shot " + Saucer.getNumberShot() + " / " + Saucer.getNumberSpawned() + " : " + ratio + "%";
                    LabelEffect bonusEffect2 = new LabelEffect(net.puppygames.applet.Res.getSmallFont(), message, ReadableColor.YELLOW, ReadableColor.RED, 60, 240);
                    bonusEffect2.setLocation((float)(Game.getScale() / 2), (float)(Game.getScale() / 2));
                    bonusEffect2.setVisible(true);
                    bonusEffect2.setDelay(120);
                    bonusEffect2.setSound(ratio == 100 ? Res.getChallengePerfect() : Res.getChallengeBonus1());
                    bonusEffect2.spawn((Screen)GameScreen.getInstance());
                    int rate = 50 * (1 + this.getLevel() / 7);
                    bonus = ratio * rate;
                    LabelEffect bonusEffect3 = new LabelEffect(net.puppygames.applet.Res.getSmallFont(), "Bonus " + ratio + "% x " + rate + " = " + bonus + " points", ReadableColor.YELLOW, ReadableColor.RED, 60, 240);
                    bonusEffect3.setLocation((float)(Game.getScale() / 2), (float)(Game.getScale() / 2 - 20));
                    this.addScore(bonus);
                    bonusEffect3.setVisible(true);
                    bonusEffect3.setDelay(240);
                    bonusEffect3.setSound(Res.getChallengeBonus2());
                    bonusEffect3.spawn((Screen)GameScreen.getInstance());
                    if (ratio != 100) break block30;
                    switch (Util.random((int)0, (int)4)) {
                        case 0: {
                            this.addMoney(1000);
                            prize = "$1000";
                            break block31;
                        }
                        case 1: {
                            if (this.shields >= ShopPrices.SHIELDS.length - 2) {
                                this.addMoney(1000);
                                prize = "$1000";
                            } else {
                                this.shields += 2;
                                prize = "2 Extra Shields";
                            }
                            break block31;
                        }
                        case 2: {
                            if (this.extraBullets >= ShopPrices.EXTRA_BULLETS.length - 1) {
                                this.addMoney(1000);
                                prize = "$1000";
                            } else {
                                ++this.extraBullets;
                                prize = "Weapons Boost";
                            }
                            break block31;
                        }
                        case 3: {
                            if (this.gunPower >= ShopPrices.GUN_POWER.length - 1) {
                                this.addMoney(1000);
                                prize = "$1000";
                            } else {
                                ++this.gunPower;
                                prize = "Weapons Boost";
                            }
                            break block31;
                        }
                        case 4: {
                            if (this.smartBombs == 3) {
                                this.addMoney(1000);
                                prize = "$1000";
                            } else {
                                ++this.smartBombs;
                                prize = "Extra Smartbomb";
                            }
                            break block31;
                        }
                        default: {
                            prize = "Nothing";
                            assert (false);
                            break block31;
                        }
                    }
                }
                if (ratio < 75) break block32;
                switch (Util.random((int)0, (int)2)) {
                    case 0: {
                        this.addMoney(500);
                        prize = "$500";
                        break block31;
                    }
                    case 1: {
                        if (this.shields >= ShopPrices.SHIELDS.length - 1) {
                            this.addMoney(500);
                            prize = "$500";
                        } else {
                            ++this.shields;
                            prize = "Extra Shield";
                        }
                        break block31;
                    }
                    case 2: {
                        if (this.smartBombs == 3) {
                            this.addMoney(500);
                            prize = "$500";
                        } else {
                            ++this.smartBombs;
                            prize = "Extra Smartbomb";
                        }
                        break block31;
                    }
                    default: {
                        prize = "Nothing";
                        assert (false);
                        break block31;
                    }
                }
            }
            prize = "No Prizes";
        }
        LabelEffect bonusEffect4 = new LabelEffect(net.puppygames.applet.Res.getSmallFont(), prize, ReadableColor.YELLOW, ReadableColor.RED, 60, 240);
        bonusEffect4.setLocation((float)(Game.getScale() / 2), (float)(Game.getScale() / 2 - 40));
        this.addScore(bonus);
        bonusEffect4.setVisible(true);
        bonusEffect4.setDelay(360);
        bonusEffect4.setSound(Res.getChallengeBonus2());
        bonusEffect4.spawn((Screen)GameScreen.getInstance());
    }

    private void tickChallengeEnd() {
        if (this.tick == 480) {
            ShopScreen.show();
        }
    }

    private void tickEndOfGame() {
        if (this.money >= 10) {
            this.addMoney(-10);
            this.addScore(100);
            net.puppygames.applet.effects.SFX.keyTyped();
        }
        if (this.tick == 480 && this.money < 10) {
            MiniGame.gameOver();
        }
    }

    private void tickWaitForBoss() {
        if (this.tick == 240) {
            Behaviour boss = this.currentLevel.getBoss();
            Gidrah g = new Gidrah(boss, 0);
            g.spawn(GameScreen.getInstance());
            this.phase = 6;
            this.tick = 0;
        }
    }

    private void expireDemo() {
        this.player.kill();
        LabelEffect nagEffect = new LabelEffect(net.puppygames.applet.Res.getBigFont(), "): ): DEMO EXPIRED :( :(", ReadableColor.YELLOW, ReadableColor.RED, 160, 240);
        nagEffect.setLocation((float)(Game.getScale() / 2), (float)(Game.getScale() / 2 + 32));
        nagEffect.setVisible(true);
        nagEffect.spawn((Screen)GameScreen.getInstance());
        Game.getLocalPreferences().putBoolean("showregister", true);
        this.phase = 8;
        this.tick = 0;
    }

    private void tickBoss() {
        if (!Game.isRegistered() && this.level >= 39) {
            ++this.tick;
            if (this.tick == 450) {
                this.expireDemo();
                return;
            }
        } else if (Gidrah.getGidrahs().size() == 0 && this.player.isAlive()) {
            LabelEffect challengeEffect = new LabelEffect(net.puppygames.applet.Res.getBigFont(), "WELL DONE COMMANDER!", ReadableColor.YELLOW, ReadableColor.RED, 60, 240);
            challengeEffect.setLocation((float)(Game.getScale() / 2), (float)(Game.getScale() / 2 + 40));
            challengeEffect.setVisible(true);
            challengeEffect.spawn((Screen)GameScreen.getInstance());
            LabelEffect challengeEffect2 = new LabelEffect(net.puppygames.applet.Res.getSmallFont(), PLANET_NAMES[this.level % 100 / 20], ReadableColor.YELLOW, ReadableColor.RED, 60, 240);
            challengeEffect2.setLocation((float)(Game.getScale() / 2), (float)(Game.getScale() / 2));
            challengeEffect2.setVisible(true);
            challengeEffect2.spawn((Screen)GameScreen.getInstance());
            challengeEffect2.setDelay(120);
            LabelEffect challengeEffect3 = new LabelEffect(net.puppygames.applet.Res.getSmallFont(), NEXT_PLANET[this.level % 100 / 20], ReadableColor.YELLOW, ReadableColor.RED, 60, 240);
            challengeEffect3.setLocation((float)(Game.getScale() / 2), (float)(Game.getScale() / 2 - 20));
            challengeEffect3.setVisible(true);
            challengeEffect3.spawn((Screen)GameScreen.getInstance());
            challengeEffect3.setDelay(240);
            if (this.level % 100 == 99) {
                LabelEffect challengeEffect4 = new LabelEffect(net.puppygames.applet.Res.getBigFont(), "DOUBLE POINTS!", ReadableColor.WHITE, ReadableColor.RED, 60, 240);
                challengeEffect4.setLocation((float)(Game.getScale() / 2), (float)(Game.getScale() / 2 - 45));
                challengeEffect4.setVisible(true);
                challengeEffect4.spawn((Screen)GameScreen.getInstance());
                challengeEffect4.setDelay(360);
                this.addScore(this.score);
                this.tick = -300;
            } else {
                this.tick = 0;
            }
            this.phase = 7;
            SFX.wellDoneCommander();
            this.maybeCheckpoint();
        }
    }

    private void tickBossDefeated() {
        if (this.tick == 360) {
            if (this.player.isAlive()) {
                ShopScreen.show();
            } else {
                MiniGame.gameOver();
            }
        }
    }

    void tick() {
        if (this.currentLevel == null) {
            return;
        }
        if (Keyboard.isKeyDown((int)1) && this.player.canCollide() && !this.saving) {
            this.saving = true;
            this.saveTick = 0;
            LabelEffect saveEffect = new LabelEffect(net.puppygames.applet.Res.getBigFont(), "SAVING GAME...", ReadableColor.WHITE, ReadableColor.BLUE, 22, 22);
            saveEffect.setLocation((float)(Game.getScale() / 2), (float)(Game.getScale() / 2 + 32));
            saveEffect.setVisible(true);
            saveEffect.spawn((Screen)GameScreen.getInstance());
        }
        if (this.saving && this.player.canCollide()) {
            ++this.saveTick;
            if (this.saveTick >= 45) {
                MiniGame.saveGame();
                return;
            }
        }
        ++this.tick;
        ++this.totalTicks;
        this.doPhase();
        this.tickAllEntities();
    }

    private void doPhase() {
        switch (this.phase) {
            case 0: {
                this.tickNormal();
                break;
            }
            case 1: {
                this.tickEndOfLevel();
                break;
            }
            case 2: {
                this.tickChallengeBegin();
                break;
            }
            case 3: {
                this.tickChallenge();
                break;
            }
            case 4: {
                this.tickChallengeEnd();
                break;
            }
            case 5: {
                this.tickWaitForBoss();
                break;
            }
            case 6: {
                this.tickBoss();
                break;
            }
            case 7: {
                this.tickBossDefeated();
                break;
            }
            case 8: {
                this.tickEndOfGame();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    private void doSaucers() {
        if (this.saucerKills > 10 + this.level / 3) {
            this.saucerKills = 0;
            Saucer saucer = new Saucer();
            saucer.spawn(GameScreen.getInstance());
        }
    }

    public void bumpSaucer() {
        ++this.saucerKills;
    }

    private void doMeteors() {
        if (this.currentLevel.getMeteorFrequency() > 0) {
            --this.meteorTick;
            if (this.meteorTick <= 0) {
                EnemyBulletFeature f;
                this.meteorTick = Util.random((int)0, (int)this.currentLevel.getMeteorFrequency());
                switch (Util.random((int)0, (int)2)) {
                    case 0: {
                        f = Res.getLargeMeteor();
                        break;
                    }
                    case 1: {
                        f = Res.getMediumMeteor();
                        break;
                    }
                    default: {
                        f = Res.getSmallMeteor();
                    }
                }
                EnemyBullet meteor = f.spawn(GameScreen.getInstance());
                if (meteor != null) {
                    float x = Util.random((int)0, (int)Game.getScale());
                    meteor.setLocation(x, (float)Game.getScale() + meteor.getRadius());
                    float vx = x < (float)(Game.getScale() / 2) ? 0.5f : -0.5f;
                    meteor.setVelocity(vx, (float)Util.random((int)0, (int)5) * 0.5f);
                }
            }
        }
    }

    public void init() {
        if (InvadersGameState.getMaxCheckpointWorld() > 0) {
            SelectWorldScreen.show();
        } else {
            this.init(0);
        }
    }

    public void init(int world) {
        this.loadCheckpoint(world * 20);
        GameScreen.beginGame(this);
        this.nextLevel();
        this.doInitMessages("SAVE THE HUMAN RACE!", "Hit ESC to save game and quit");
        PrizeFeature prize = MiniGame.getPrize();
        if (prize != null) {
            MiniGame.setPrize(null);
            prize.redeem();
        }
    }

    public static boolean isPrizeCheckpointReached() {
        return Game.getRoamingPreferences().getInt("prizeCheckpoint", 0) > 2;
    }

    private static void setPrizeCheckpointReached() {
        Game.getRoamingPreferences().putInt("prizeCheckpoint", Game.getRoamingPreferences().getInt("prizeCheckpoint", 0) + 1);
        Game.flushPrefs();
    }

    public static int getMaxCheckpointWorld() {
        return Game.getRoamingPreferences().getInt("checkpoint", 0) / 20;
    }

    private void doInitMessages(String big, String small) {
        LabelEffect newLevelEffect = new LabelEffect(net.puppygames.applet.Res.getBigFont(), big, ReadableColor.WHITE, ReadableColor.RED, 40, 160);
        newLevelEffect.setLocation((float)(Game.getScale() / 2), (float)(Game.getScale() / 2 + 60));
        newLevelEffect.setVisible(true);
        newLevelEffect.spawn((Screen)GameScreen.getInstance());
        LabelEffect hintEffect = new LabelEffect(net.puppygames.applet.Res.getSmallFont(), small, ReadableColor.WHITE, ReadableColor.RED, 40, 160);
        hintEffect.setDelay(30);
        hintEffect.setLocation((float)(Game.getScale() / 2), (float)(Game.getScale() / 2 + 20));
        hintEffect.setVisible(true);
        hintEffect.spawn((Screen)GameScreen.getInstance());
    }

    public void reinit() {
        GameScreen.beginGame(this);
        this.currentLevel = Level.getLevel(this.level);
        this.doInitMessages("RESUMING GAME", "Hit ESC to save game and quit");
        for (Entity entity : this.entities) {
            entity.respawn(GameScreen.getInstance());
        }
        GameScreen.beginLevel();
        if (this.player == null || !this.player.isActive()) {
            MiniGame.endGame();
        }
    }

    public ArrayList getEntities() {
        return this.entities;
    }

    public int getSaucerValue() {
        return this.saucerValue;
    }

    public void nextSaucerValue() {
        this.saucerValue += 100;
    }

    public int getTotalMultiplier() {
        return this.totalMultiplier;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(Saucer.getNumberSpawned());
        stream.writeInt(Saucer.getNumberShot());
        stream.writeInt(Saucer.getNumberRemoved());
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int saucersSpawned = stream.readInt();
        int saucersShot = stream.readInt();
        int saucersRemoved = stream.readInt();
        Saucer.reinit(saucersSpawned, saucersShot, saucersRemoved);
    }

    public int getSmartBombPrice() {
        return this.smartBombPrice;
    }

    public void awardMedal(String medal) {
        if (Game.isUsingSteam() && Steam.isCreated() && Steam.isSteamRunning()) {
            try {
                Steam.getUserStats().setAchievement(medal);
                Steam.getUserStats().storeStats();
            }
            catch (SteamException e) {
                System.err.println("Failed to set achievement " + medal + " due to " + (Object)((Object)e));
                e.printStackTrace(System.err);
            }
        }
    }

    public void onCaptured() {
        ++this.captured;
        switch (this.captured) {
            case 10: {
                this.awardMedal("captured_10");
                break;
            }
            case 25: {
                this.awardMedal("captured_25");
                break;
            }
            case 50: {
                this.awardMedal("captured_50");
                break;
            }
            case 100: {
                this.awardMedal("captured_100");
            }
        }
    }

    public void onMurdered() {
        ++this.murdered;
        switch (this.murdered) {
            case 10: {
                this.awardMedal("killed_10");
                break;
            }
            case 25: {
                this.awardMedal("killed_25");
                break;
            }
            case 50: {
                this.awardMedal("killed_50");
                break;
            }
            case 100: {
                this.awardMedal("killed_100");
            }
        }
    }

    public void onEscaped() {
        ++this.escaped;
        switch (this.escaped) {
            case 10: {
                this.awardMedal("escaped_10");
                break;
            }
            case 25: {
                this.awardMedal("escaped_25");
                break;
            }
            case 50: {
                this.awardMedal("escaped_50");
                break;
            }
            case 100: {
                this.awardMedal("escaped_100");
            }
        }
    }

    public void onSaucerShot() {
        ++this.saucersShot;
        switch (this.saucersShot) {
            case 10: {
                this.awardMedal("saucers_10");
                break;
            }
            case 25: {
                this.awardMedal("saucers_25");
                break;
            }
            case 50: {
                this.awardMedal("saucers_50");
                break;
            }
            case 100: {
                this.awardMedal("saucers_100");
            }
        }
    }

    public void onSkillShot() {
        ++this.skillShots;
        switch (this.skillShots) {
            case 10: {
                this.awardMedal("skill_10");
                break;
            }
            case 25: {
                this.awardMedal("skill_25");
                break;
            }
            case 50: {
                this.awardMedal("skill_50");
                break;
            }
            case 100: {
                this.awardMedal("skill_100");
            }
        }
    }

    public void onSmartbombFired() {
        ++this.smartbombsFired;
        if (this.smartbombsFired == 25) {
            this.awardMedal("volatile");
        }
    }
}

