/*
 * Decompiled with CFR 0.152.
 */
package invaders;

import com.shavenpuppy.jglib.sound.SoundPlayer;
import invaders.GameScreen;
import invaders.InvadersGameState;
import net.puppygames.applet.GameState;
import net.puppygames.applet.Launcher;
import net.puppygames.applet.MiniGame;
import net.puppygames.applet.Score;
import net.puppygames.applet.screens.HiscoresScreen;
import net.puppygames.applet.screens.NagScreen;
import net.puppygames.applet.screens.OptionsScreen;
import net.puppygames.applet.screens.RegisterScreen;
import net.puppygames.applet.screens.TitleScreen;
import net.puppygames.steam.NotificationPosition;
import net.puppygames.steam.Steam;
import net.puppygames.steam.SteamException;

public class Invaders
extends MiniGame {
    private static final long serialVersionUID = 1L;
    private static final boolean TESTSIGNUP = true;
    private static SoundPlayer speechPlayer;
    private static InvadersGameState gameState;

    public Invaders(String name) {
        super(name);
    }

    protected GameState createGameState() {
        return new InvadersGameState();
    }

    protected void setGameState(GameState newGameState) {
        super.setGameState(newGameState);
        gameState = (InvadersGameState)newGameState;
    }

    public static InvadersGameState getGameState() {
        return gameState;
    }

    protected void doGameOver() {
        GameScreen.gameOver();
    }

    protected void doShowOptions() {
        OptionsScreen.show();
    }

    public static int getScore() {
        return gameState.getScore();
    }

    public static void addScore(int points) {
        gameState.addScore(points);
    }

    protected void doEndGame() {
        if (MiniGame.isDemoExpired()) {
            NagScreen.show((String)"You know you want to!", (boolean)true);
        } else if (gameState.getScore() > 0) {
            Score scoreToSubmit = new Score(Invaders.getTitle(), Invaders.getInternalVersion(), Invaders.getScoreGroup(), "", Invaders.getInstallation(), gameState.getScore(), "", Invaders.isRegistered());
            HiscoresScreen.show((Score)scoreToSubmit);
        } else {
            TitleScreen.show();
        }
    }

    protected void doTick() {
    }

    protected void onExit() {
        GameScreen.onExit();
    }

    protected void doShowRegisterScreen() {
        RegisterScreen.show();
    }

    protected void doCreate() {
        super.doCreate();
        if (Invaders.isUsingSteam() && Steam.isCreated() && Steam.isSteamRunning()) {
            Steam.getUtils().setOverlayNotificationPosition(NotificationPosition.TopRight);
            try {
                Steam.getUserStats().requestCurrentStats();
            }
            catch (SteamException e) {
                System.err.println("Failed to request current user stats due to " + (Object)((Object)e));
            }
        }
    }

    public static void main(String[] args) {
        Launcher.main((String[])args);
    }
}

