/*
 * Decompiled with CFR 0.152.
 */
package invaders;

import com.shavenpuppy.jglib.resources.ResourceArray;
import com.shavenpuppy.jglib.sprites.SpriteImage;
import net.puppygames.applet.Area;

public class InstructionsScreen
extends net.puppygames.applet.screens.InstructionsScreen {
    private static final String ID_NEXT = "next";
    private static final String ID_PREV = "prev";
    private static final String ID_HINTS = "hints";
    private static final String GROUP_ALL_HINT_SPRITES = "hint-sprites";
    private static final String GROUP_HINT_SPRITES = "hint-sprites-";
    private ResourceArray hints;
    private transient int currentHint;
    private transient Area hintsArea;

    public InstructionsScreen(String name) {
        super(name);
    }

    protected void doCreateScreen() {
        this.hintsArea = this.getArea(ID_HINTS);
    }

    protected void onOpen() {
        super.onOpen();
        this.setCurrentHint(0);
    }

    private void setCurrentHint(int newCurrentHint) {
        this.currentHint = newCurrentHint;
        this.hintsArea.getSprite().setImage((SpriteImage)this.hints.getResource(newCurrentHint));
        this.setEnabled(ID_NEXT, this.currentHint < this.hints.getNumResources() - 1);
        this.setEnabled(ID_PREV, this.currentHint != 0);
        this.setGroupVisible(GROUP_ALL_HINT_SPRITES, false);
        this.setGroupVisible(GROUP_HINT_SPRITES + this.currentHint, true);
    }

    protected void onClicked(String id) {
        int newCurrentHint;
        super.onClicked(id);
        if (id.equals(ID_PREV)) {
            newCurrentHint = this.currentHint - 1;
            if (newCurrentHint < 0) {
                newCurrentHint = this.hints.getNumResources() - 1;
            }
            this.setCurrentHint(newCurrentHint);
        }
        if (id.equals(ID_NEXT)) {
            newCurrentHint = this.currentHint + 1;
            if (newCurrentHint >= this.hints.getNumResources()) {
                newCurrentHint = 0;
            }
            this.setCurrentHint(newCurrentHint);
        }
    }
}

