/*
 * Decompiled with CFR 0.152.
 */
package invaders;

import com.shavenpuppy.jglib.TextLayout;
import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.opengl.ColorUtil;
import com.shavenpuppy.jglib.opengl.GLRenderable;
import com.shavenpuppy.jglib.opengl.GLTextArea;
import com.shavenpuppy.jglib.sprites.SimpleRenderer;
import com.shavenpuppy.jglib.sprites.SpriteAllocator;
import invaders.Background;
import invaders.Entity;
import invaders.Invaders;
import invaders.InvadersGameState;
import invaders.LayersFeature;
import invaders.Player;
import invaders.Res;
import invaders.SFX;
import net.puppygames.applet.Area;
import net.puppygames.applet.Game;
import net.puppygames.applet.MiniGame;
import net.puppygames.applet.Screen;
import net.puppygames.applet.TickableObject;
import net.puppygames.applet.effects.Effect;
import net.puppygames.applet.effects.LabelEffect;
import net.puppygames.applet.widgets.PowerDisplay;
import net.puppygames.applet.widgets.PowerDisplayFeature;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;
import org.lwjgl.util.Point;
import org.lwjgl.util.ReadableColor;
import org.lwjgl.util.ReadablePoint;
import org.lwjgl.util.ReadableRectangle;
import org.lwjgl.util.Rectangle;

public class GameScreen
extends Screen {
    private static final long serialVersionUID = 1L;
    static final String GAMEOVER = "gameover";
    private static final String ROCKETRELOAD_BOUNDS = "rocketreload_bounds";
    private static final String LASERRELOAD_BOUNDS = "laserreload_bounds";
    private static final String SCORE_BOUNDS = "score_bounds";
    private static final String MULT_BOUNDS = "mult_bounds";
    private static final String MONEY_BOUNDS = "money_bounds";
    public static final float FLOOR = 10.0f;
    public static final float CEILING = 80.0f;
    private static final GLRenderable SETUP_HUD_RENDERING = new GLRenderable(){

        public void render() {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)1, (int)771);
            GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
        }
    };
    private static final GLRenderable ENABLE_TEXTURING = new GLRenderable(){

        public void render() {
            GL11.glEnable((int)3553);
        }
    };
    private static final GLRenderable DISABLE_TEXTURING = new GLRenderable(){

        public void render() {
            GL11.glDisable((int)3553);
        }
    };
    private static GameScreen instance;
    private static final Color CACHED_COLOR;
    private static final Rectangle TEMP_RECT;
    private static final Point SPRITE_OFFSET;
    private static Background background;
    private static InvadersGameState gameState;
    private Color reloadingColor;
    private Color reloadedColor;
    private PowerDisplayFeature shieldPower;
    private PowerDisplayFeature smarts;
    private PowerDisplayFeature ammoDisplay;
    private transient GLTextArea scoreLabel;
    private transient GLTextArea moneyLabel;
    private transient GLTextArea multLabel;
    private transient PowerDisplay shieldPowerInstance;
    private transient PowerDisplay smartsInstance;
    private transient Area shieldsEmpty;
    private transient Area laserReload;
    private transient Area rocketReload;
    private transient ReadableRectangle rocketReloadBounds;
    private transient ReadableRectangle laserReloadBounds;
    private transient int rocketTick;
    private transient int rocketTime;
    private transient int laserTick;
    private transient int laserTime;
    private transient TickableObject hudRenderer;

    static {
        CACHED_COLOR = new Color();
        TEMP_RECT = new Rectangle();
        SPRITE_OFFSET = new Point();
    }

    public GameScreen(String name) {
        super(name);
    }

    private static void setBackground(Background background) {
        GameScreen.background = background;
        if (background != null) {
            background.init(GameScreen.getInstance());
        }
    }

    protected void doRegister() {
        instance = this;
    }

    protected void doDeregister() {
        instance = null;
    }

    protected void doTick() {
        if (Game.isPaused()) {
            return;
        }
        MiniGame.onTicked();
        gameState.tick();
        this.shieldPowerInstance.setUsed(Invaders.getGameState().getShields());
        this.smartsInstance.setUsed(Invaders.getGameState().getSmartBombs());
        if (Invaders.getGameState().getShields() == 0 && this.shieldsEmpty != null && !this.shieldsEmpty.isVisible()) {
            this.shieldsEmpty.setVisible(true);
        } else if (this.shieldsEmpty != null && this.shieldsEmpty.isVisible() && Invaders.getGameState().getShields() > 0) {
            this.shieldsEmpty.setVisible(false);
        }
        if (Invaders.getGameState().getAddOn() >= 3 && !this.rocketReload.isVisible()) {
            this.rocketReload.setVisible(true);
        }
        if (Invaders.getGameState().getAddOn() == 4 && !this.laserReload.isVisible()) {
            this.laserReload.setVisible(true);
        }
    }

    protected void doCleanup() {
        if (background != null) {
            background.cleanup();
            background = null;
        }
        if (this.shieldPowerInstance != null) {
            this.shieldPowerInstance.cleanup();
            this.shieldPowerInstance = null;
        }
        if (this.smartsInstance != null) {
            this.smartsInstance.cleanup();
            this.smartsInstance = null;
        }
        if (this.hudRenderer != null) {
            this.hudRenderer.remove();
            this.hudRenderer = null;
        }
    }

    protected void onOpen() {
        this.shieldPowerInstance = this.shieldPower.spawn((Screen)this);
        this.shieldPowerInstance.onResized();
        this.smartsInstance = this.smarts.spawn((Screen)this);
        this.smartsInstance.onResized();
        this.rocketReload.setVisible(false);
        this.laserReload.setVisible(false);
        this.hudRenderer = new TickableObject(){

            protected void render() {
                short idx;
                int width;
                this.glRender(SETUP_HUD_RENDERING);
                if (Invaders.getGameState().getAddOn() >= 3) {
                    this.glRender(DISABLE_TEXTURING);
                    width = (int)LinearInterpolator.instance.interpolate(0.0f, (float)GameScreen.this.rocketReloadBounds.getWidth(), (float)GameScreen.this.rocketTick / (float)GameScreen.this.rocketTime);
                    if (GameScreen.this.rocketTick < GameScreen.this.rocketTime) {
                        ColorUtil.setGLColorPre((ReadableColor)GameScreen.this.reloadingColor, (SimpleRenderer)this);
                    } else {
                        ColorUtil.setGLColorPre((ReadableColor)GameScreen.this.reloadedColor, (SimpleRenderer)this);
                    }
                    idx = this.glVertex2f(GameScreen.this.rocketReloadBounds.getX(), GameScreen.this.rocketReloadBounds.getY());
                    this.glVertex2f(GameScreen.this.rocketReloadBounds.getX() + width, GameScreen.this.rocketReloadBounds.getY());
                    this.glVertex2f(GameScreen.this.rocketReloadBounds.getX() + width, GameScreen.this.rocketReloadBounds.getY() + GameScreen.this.rocketReloadBounds.getHeight());
                    this.glVertex2f(GameScreen.this.rocketReloadBounds.getX(), GameScreen.this.rocketReloadBounds.getY() + GameScreen.this.rocketReloadBounds.getHeight());
                    this.glRender(6, new short[]{(short)(idx + 0), (short)(idx + 1), (short)(idx + 2), (short)(idx + 3)});
                }
                if (Invaders.getGameState().getAddOn() == 4) {
                    this.glRender(DISABLE_TEXTURING);
                    width = GameScreen.this.laserReloadBounds.getWidth() - (int)LinearInterpolator.instance.interpolate(0.0f, (float)GameScreen.this.laserReloadBounds.getWidth(), (float)GameScreen.this.laserTick / (float)GameScreen.this.laserTime);
                    if (GameScreen.this.laserTick < GameScreen.this.laserTime) {
                        ColorUtil.setGLColorPre((ReadableColor)GameScreen.this.reloadingColor, (SimpleRenderer)this);
                    } else {
                        ColorUtil.setGLColorPre((ReadableColor)GameScreen.this.reloadedColor, (SimpleRenderer)this);
                    }
                    idx = this.glVertex2f(GameScreen.this.laserReloadBounds.getX() + width, GameScreen.this.laserReloadBounds.getY());
                    this.glVertex2f(GameScreen.this.laserReloadBounds.getX() + GameScreen.this.laserReloadBounds.getWidth(), GameScreen.this.laserReloadBounds.getY());
                    this.glVertex2f(GameScreen.this.laserReloadBounds.getX() + GameScreen.this.laserReloadBounds.getWidth(), GameScreen.this.laserReloadBounds.getY() + GameScreen.this.laserReloadBounds.getHeight());
                    this.glVertex2f(GameScreen.this.laserReloadBounds.getX() + width, GameScreen.this.laserReloadBounds.getY() + GameScreen.this.laserReloadBounds.getHeight());
                    this.glRender(6, new short[]{(short)(idx + 0), (short)(idx + 1), (short)(idx + 2), (short)(idx + 3)});
                }
                this.glRender(ENABLE_TEXTURING);
                ColorUtil.setGLColorPre((ReadableColor)ReadableColor.WHITE, (SimpleRenderer)this);
                GameScreen.this.scoreLabel.setText(String.valueOf(Invaders.getGameState().getScore()));
                GameScreen.this.moneyLabel.setText(String.valueOf(Invaders.getGameState().getMoney()));
                GameScreen.this.scoreLabel.render((SimpleRenderer)this);
                GameScreen.this.moneyLabel.render((SimpleRenderer)this);
                int mult = Invaders.getGameState().getMultiplier();
                if (mult > 1) {
                    GameScreen.this.multLabel.setText(String.valueOf(mult));
                    GameScreen.this.multLabel.render((SimpleRenderer)this);
                }
            }
        };
        this.hudRenderer.setLayer(12);
        this.hudRenderer.spawn((Screen)this);
    }

    public static int getTick() {
        return gameState.getTick();
    }

    public static int getTotalTicks() {
        int oldTotalTicks = gameState.getTotalTicks();
        gameState.resetTotalTicks();
        return oldTotalTicks;
    }

    public static void beginLevel() {
        instance.open();
        SFX.gameMusic(gameState.getLevel());
        GameScreen.setBackground(gameState.getCurrentLevel().getBackground());
    }

    public static void beginGame(InvadersGameState gameState) {
        GameScreen.gameState = gameState;
        instance.setVisible(GAMEOVER, false);
        instance.open();
    }

    public static void gameOver() {
        LabelEffect gameOverEffect = new LabelEffect(net.puppygames.applet.Res.getBigFont(), "Game Over", ReadableColor.WHITE, ReadableColor.RED, 320, 120);
        gameOverEffect.setLocation((float)(Game.getScale() / 2), (float)(Game.getScale() / 2));
        gameOverEffect.setVisible(true);
        gameOverEffect.spawn((Screen)instance);
        Game.playMusic(null, (int)180);
        instance.setVisible(GAMEOVER, true);
    }

    protected void doCreateScreen() {
        Effect.setDefaultOffset((SpriteAllocator)this, (ReadablePoint)SPRITE_OFFSET);
        this.scoreLabel = new GLTextArea();
        this.scoreLabel.setFont(Res.getMessageFont());
        this.scoreLabel.setHorizontalAlignment(TextLayout.RIGHT);
        this.moneyLabel = new GLTextArea();
        this.moneyLabel.setFont(Res.getMessageFont());
        this.moneyLabel.setHorizontalAlignment(TextLayout.RIGHT);
        this.multLabel = new GLTextArea();
        this.multLabel.setFont(net.puppygames.applet.Res.getBigFont());
        this.shieldsEmpty = this.getArea("shields_empty");
        this.rocketReload = this.getArea("rocketreload");
        this.laserReload = this.getArea("laserreload");
    }

    protected void onResized() {
        SPRITE_OFFSET.setLocation((this.getWidth() - Game.getScale()) / 2, (this.getHeight() - Game.getScale()) / 2);
        this.rocketReloadBounds = this.getArea(ROCKETRELOAD_BOUNDS).getBounds();
        this.laserReloadBounds = this.getArea(LASERRELOAD_BOUNDS).getBounds();
        this.scoreLabel.setBounds(this.getArea(SCORE_BOUNDS).getBounds());
        this.moneyLabel.setBounds(this.getArea(MONEY_BOUNDS).getBounds());
        this.multLabel.setBounds(this.getArea(MULT_BOUNDS).getBounds());
        if (this.shieldPowerInstance != null) {
            this.shieldPowerInstance.onResized();
        }
        if (this.smartsInstance != null) {
            this.smartsInstance.onResized();
        }
        if (background != null) {
            background.onResized();
        }
    }

    public static Player getPlayer() {
        return gameState.getPlayer();
    }

    public static void addEntity(Entity entity) {
        instance.addTickable(entity);
        gameState.addEntity(entity);
    }

    public static GameScreen getInstance() {
        return instance;
    }

    public static void onExit() {
        if (instance != null && instance.isOpen()) {
            MiniGame.saveGame();
        }
    }

    public static LayersFeature getSaucerAppearance() {
        return background.getSaucerAppearance();
    }

    public static void setLaserReload(int tick, int time) {
        GameScreen.instance.laserTick = tick;
        GameScreen.instance.laserTime = time;
    }

    public static void setRocketReload(int tick, int time) {
        GameScreen.instance.rocketTick = tick;
        GameScreen.instance.rocketTime = time;
    }

    public static ReadablePoint getSpriteOffset() {
        return SPRITE_OFFSET;
    }
}

