/*
 * Decompiled with CFR 0.152.
 */
package invaders;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.sprites.Command;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.XMLUtil;
import invaders.Entity;
import invaders.GameScreen;
import java.io.Serializable;
import net.puppygames.applet.Area;
import net.puppygames.applet.Screen;
import net.puppygames.applet.effects.Emitter;
import net.puppygames.applet.effects.EmitterFeature;
import org.w3c.dom.Element;

public class EmitCommand
extends Command {
    private String id;
    private float ox;
    private float oy;
    private transient EmitterFeature idFeature;

    public void load(Element element, Resource.Loader loader) throws Exception {
        this.id = XMLUtil.getString((Element)element, (String)"id");
        this.ox = XMLUtil.getFloat((Element)element, (String)"ox");
        this.oy = XMLUtil.getFloat((Element)element, (String)"oy");
    }

    protected void doCreate() {
        this.idFeature = (EmitterFeature)Resources.get((String)this.id);
    }

    public void archive() {
        this.id = null;
    }

    public boolean execute(Sprite target) {
        int currentSequence = target.getSequence();
        target.setSequence(currentSequence + 1);
        Sprite sprite = target;
        Serializable owner = sprite.getOwner();
        if (owner instanceof Entity) {
            Entity entity = (Entity)owner;
            float xx = entity.getX() + this.ox * FPMath.floatValue((int)sprite.getXScale());
            float yy = entity.getY() + this.oy * FPMath.floatValue((int)sprite.getYScale());
            Emitter e = this.idFeature.spawn((Screen)GameScreen.getInstance());
            e.setLocation(xx, yy);
        } else if (owner instanceof Area) {
            Area area = (Area)owner;
            float xx = (float)area.getBounds().getX() + this.ox;
            float yy = (float)area.getBounds().getY() + this.oy;
            Emitter e = this.idFeature.spawn(area.getScreen());
            e.setLocation(xx, yy);
        } else {
            System.err.println(owner + " is not an area or an entity!");
            return true;
        }
        return true;
    }
}

