/*
 * Decompiled with CFR 0.152.
 */
package xap.modes.standard;

import java.sql.ResultSet;
import java.sql.SQLException;
import net.puppygames.gamecommerce.shared.HexEncoder;
import net.puppygames.gamecommerce.shared.RegistrationDetails;
import xap.Score;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardScore
implements Score,
Comparable<StandardScore> {
    private static final long serialVersionUID = 4L;
    public static final int EASY = 0;
    public static final int NORMAL = 1;
    public static final int HARDCORE = 2;
    public static final int ADVANCED = 3;
    private int mode;
    private int score;
    private int level;
    private int time;
    private int lives;
    private int shields;
    private int smarts;
    private int shots;
    private int hits;
    private int rescues;
    private int style;
    private int murders;
    private int fluffies;
    private int bungles;
    private String name;
    private transient boolean invalid;
    private RegistrationDetails registrationDetails;

    public StandardScore() {
    }

    public StandardScore(RegistrationDetails regCode, int mode) {
        this.registrationDetails = regCode;
        this.mode = mode;
    }

    public String toString() {
        return "Score[" + this.name + ", " + this.score + "]";
    }

    public void insertInto(StandardScoreDatabase db, String host) throws SQLException {
        if (this.registrationDetails == null) {
            return;
        }
        db.insertStandardScore(HexEncoder.encode(this.registrationDetails.getRegCode()), this.name, this.score, this.level, this.time, this.lives, this.shields, this.smarts, this.shots, this.hits, this.rescues, this.style, this.murders, this.fluffies, this.bungles, this.mode, host);
    }

    public boolean checkExists(StandardScoreDatabase db) throws SQLException {
        if (this.registrationDetails == null) {
            return true;
        }
        return db.checkStandardScoreExists(HexEncoder.encode(this.registrationDetails.getRegCode()), this.name, this.score, this.level, this.time, this.lives, this.shields, this.smarts, this.shots, this.hits, this.rescues, this.style, this.murders, this.fluffies, this.bungles, this.mode);
    }

    public void selectFrom(ResultSet rs) throws SQLException {
        this.name = rs.getString("name");
        this.score = rs.getInt("score");
        this.level = rs.getInt("level");
        this.time = rs.getInt("time");
        this.lives = rs.getInt("lives");
        this.shields = rs.getInt("shields");
        this.smarts = rs.getInt("smarts");
        this.shots = rs.getInt("shots");
        this.hits = rs.getInt("hits");
        this.rescues = rs.getInt("rescue");
        this.style = rs.getInt("style");
        this.murders = rs.getInt("murders");
        this.fluffies = rs.getInt("fluffies");
        this.bungles = rs.getInt("bungles");
        this.mode = rs.getInt("mode");
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void setRegistrationDetails(RegistrationDetails registrationDetails) {
        this.registrationDetails = registrationDetails;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.bungles;
        result = 31 * result + this.fluffies;
        result = 31 * result + this.hits;
        result = 31 * result + this.level;
        result = 31 * result + this.lives;
        result = 31 * result + this.mode;
        result = 31 * result + this.murders;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.registrationDetails == null ? 0 : this.registrationDetails.hashCode());
        result = 31 * result + this.rescues;
        result = 31 * result + this.score;
        result = 31 * result + this.shields;
        result = 31 * result + this.shots;
        result = 31 * result + this.smarts;
        result = 31 * result + this.style;
        result = 31 * result + this.time;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StandardScore other = (StandardScore)obj;
        if (this.bungles != other.bungles) {
            return false;
        }
        if (this.fluffies != other.fluffies) {
            return false;
        }
        if (this.hits != other.hits) {
            return false;
        }
        if (this.level != other.level) {
            return false;
        }
        if (this.lives != other.lives) {
            return false;
        }
        if (this.mode != other.mode) {
            return false;
        }
        if (this.murders != other.murders) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.registrationDetails == null ? other.registrationDetails != null : !this.registrationDetails.equals(other.registrationDetails)) {
            return false;
        }
        if (this.rescues != other.rescues) {
            return false;
        }
        if (this.score != other.score) {
            return false;
        }
        if (this.shields != other.shields) {
            return false;
        }
        if (this.shots != other.shots) {
            return false;
        }
        if (this.smarts != other.smarts) {
            return false;
        }
        if (this.style != other.style) {
            return false;
        }
        return this.time == other.time;
    }

    @Override
    public int compareTo(StandardScore s) {
        if (s == null) {
            return 0;
        }
        if (s.score > this.score) {
            return -1;
        }
        if (s.score == this.score) {
            return 0;
        }
        return 1;
    }

    public void incHits() {
        ++this.hits;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public void incShots() {
        ++this.shots;
    }

    @Override
    public void incLives() {
        ++this.lives;
    }

    public void incRescues() {
        ++this.rescues;
    }

    public void incStyle() {
        ++this.style;
    }

    public void incMurders() {
        ++this.murders;
    }

    public void incFluffies() {
        ++this.fluffies;
    }

    public void incBungles() {
        ++this.bungles;
    }

    public void addScore(int points) {
        this.score += points;
    }

    @Override
    public void incShields(int n) {
        this.shields += 1 + n;
    }

    @Override
    public void incSmarts() {
        ++this.smarts;
    }

    @Override
    public void incTime(int n) {
        this.time += 3 - n;
    }

    public int getHits() {
        return this.hits;
    }

    public int getLevel() {
        return this.level;
    }

    public int getLives() {
        return this.lives;
    }

    public String getName() {
        return this.name;
    }

    public RegistrationDetails getRegistrationDetails() {
        return this.registrationDetails;
    }

    public int getScore() {
        return this.score;
    }

    public int getShields() {
        return this.shields;
    }

    public int getShots() {
        return this.shots;
    }

    public int getSmarts() {
        return this.smarts;
    }

    public int getTime() {
        return this.time;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public int getMode() {
        return this.mode;
    }

    public int getBungles() {
        return this.bungles;
    }

    public int getFluffies() {
        return this.fluffies;
    }

    public int getMurders() {
        return this.murders;
    }

    public int getRescues() {
        return this.rescues;
    }

    public int getStyle() {
        return this.style;
    }

    public void invalidate() {
        this.invalid = true;
    }

    public boolean isValid() {
        return !this.invalid;
    }

    public static interface StandardScoreDatabase {
        public void insertStandardScore(String var1, String var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15, int var16, String var17) throws SQLException;

        public boolean checkStandardScoreExists(String var1, String var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15, int var16) throws SQLException;
    }
}

