/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet;

import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Score
implements Serializable,
Comparable<Score> {
    private static final long serialVersionUID = 3L;
    public static final int MAX_LENGTH = 24;
    private int rank;
    private final int points;
    private String name;
    private String group;
    private final long installation;
    private String medals;
    private String game;
    private boolean registered;
    private String version;

    public Score(String game, String version, String group, String name, long installation, int points, String medals, boolean registered) {
        this.game = game;
        this.version = version;
        this.group = "".equals(group) ? null : group;
        this.installation = installation;
        this.points = points;
        if (name != null) {
            this.setName(name);
        }
        if (medals == null) {
            medals = "";
        }
        this.medals = medals;
        this.registered = registered;
    }

    public void setName(String name) {
        this.name = name.length() > 24 ? name.substring(0, 24) : name;
    }

    public String getName() {
        return this.name;
    }

    public int getPoints() {
        return this.points;
    }

    @Override
    public int compareTo(Score obj) {
        if (obj == null) {
            return -1;
        }
        Score score = obj;
        if (score.points < this.points) {
            return -1;
        }
        if (score.points == this.points) {
            return 0;
        }
        return 1;
    }

    public boolean like(Score s) {
        return s.game.equals(this.game) && s.installation == this.installation && s.name.equals(this.name) && (s.group == null && this.group == null || s.group != null && s.group.equals(this.group));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Score [");
        if (this.name != null) {
            builder.append("name=");
            builder.append(this.name);
            builder.append(", ");
        }
        builder.append("points=");
        builder.append(this.points);
        builder.append(", installation=");
        builder.append(this.installation);
        builder.append(", ");
        if (this.game != null) {
            builder.append("game=");
            builder.append(this.game);
            builder.append(", ");
        }
        if (this.version != null) {
            builder.append("version=");
            builder.append(this.version);
            builder.append(", ");
        }
        builder.append("rank=");
        builder.append(this.rank);
        builder.append(", ");
        if (this.group != null) {
            builder.append("group=");
            builder.append(this.group);
            builder.append(", ");
        }
        if (this.medals != null) {
            builder.append("medals=");
            builder.append(this.medals);
            builder.append(", ");
        }
        builder.append("registered=");
        builder.append(this.registered);
        builder.append("]");
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Score)) {
            return false;
        }
        Score s = (Score)obj;
        return s.game.equals(this.game) && s.installation == this.installation && s.medals.equals(this.medals) && s.name.equals(this.name) && (s.group == null && this.group == null || s.group != null && s.group.equals(this.group)) && s.points == this.points;
    }

    public int hashCode() {
        return this.game.hashCode() ^ this.version.hashCode() ^ this.points ^ (int)this.installation ^ this.name.hashCode() ^ this.medals.hashCode() ^ (this.group == null ? 0 : this.group.hashCode());
    }

    public long getInstallation() {
        return this.installation;
    }

    public String getMedals() {
        return this.medals;
    }

    public String getGame() {
        return this.game;
    }

    public int getRank() {
        return this.rank;
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public String getVersion() {
        return this.version == null ? "None" : this.version;
    }
}

