/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet.widgets;

import com.shavenpuppy.jglib.opengl.ColorUtil;
import com.shavenpuppy.jglib.opengl.GLFont;
import com.shavenpuppy.jglib.opengl.GLRenderable;
import com.shavenpuppy.jglib.opengl.GLString;
import com.shavenpuppy.jglib.sprites.SimpleRenderer;
import net.puppygames.applet.Game;
import org.lwjgl.Sys;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.ReadableColor;
import org.lwjgl.util.Rectangle;

public class TextField {
    private boolean editing;
    private String oldText;
    private boolean allowUppercase;
    private boolean allCaps;
    private int cursorPos = 0;
    private int flashTick = 0;
    private boolean cursorVisible;
    private GLString display;
    private final StringBuilder buffer;
    private int width;

    public TextField(int maxLength, int width) {
        this.display = new GLString(maxLength);
        this.buffer = new StringBuilder(maxLength);
        this.width = width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setEditing(boolean editing) {
        this.editing = editing;
        if (editing) {
            this.oldText = this.display.getText();
        }
    }

    public void undo() {
        if (this.editing) {
            this.setText(this.oldText);
        }
    }

    public void cancel() {
        this.undo();
        this.setEditing(false);
        this.onCancelled();
    }

    protected void onCancelled() {
    }

    public void tick() {
        if (this.editing) {
            this.flashCursor();
            this.processKeyboard();
        }
    }

    private void flashCursor() {
        ++this.flashTick;
        if (this.flashTick > 6) {
            this.flashTick = 0;
            this.cursorVisible = !this.cursorVisible;
        }
    }

    private void processKeyboard() {
        int oldCursorPos = this.cursorPos;
        block10: while (Keyboard.next()) {
            if (!Keyboard.getEventKeyState()) continue;
            int key = Keyboard.getEventKey();
            switch (key) {
                case 207: 
                case 208: {
                    this.cursorPos = this.display.length();
                    break;
                }
                case 199: 
                case 200: {
                    this.cursorPos = 0;
                    break;
                }
                case 203: {
                    if (Keyboard.isKeyDown((int)42)) {
                        this.cursorPos = 0;
                        break;
                    }
                    if (this.cursorPos <= 0) continue block10;
                    --this.cursorPos;
                    break;
                }
                case 205: {
                    if (Keyboard.isKeyDown((int)42)) {
                        this.cursorPos = this.display.length();
                        break;
                    }
                    if (this.cursorPos >= this.display.length()) continue block10;
                    ++this.cursorPos;
                    break;
                }
                case 211: {
                    if (Keyboard.isKeyDown((int)42)) {
                        this.buffer.setLength(0);
                        this.cursorPos = 0;
                        this.display.setText("");
                    } else if (this.cursorPos < this.display.length()) {
                        this.buffer.deleteCharAt(this.cursorPos);
                        this.display.setText(this.buffer.toString());
                    }
                    this.onEdited();
                    break;
                }
                case 14: {
                    if (Keyboard.isKeyDown((int)42)) {
                        this.buffer.setLength(0);
                        this.cursorPos = 0;
                        this.display.setText("");
                    } else if (this.cursorPos > 0) {
                        this.buffer.deleteCharAt(--this.cursorPos);
                        this.display.setText(this.buffer.toString());
                    }
                    this.onEdited();
                    break;
                }
                case 15: 
                case 28: {
                    this.changeFocus();
                    return;
                }
                case 1: {
                    this.cancel();
                    return;
                }
                default: {
                    char c = Keyboard.getEventCharacter();
                    if (c == '\u0016' || key == 210 && Keyboard.isKeyDown((int)42)) {
                        String paste = Sys.getClipboard();
                        if (paste == null) continue block10;
                        int i = 0;
                        while (i < paste.length()) {
                            c = Character.toLowerCase(paste.charAt(i));
                            if (!this.addChar(c)) continue block10;
                            ++i;
                        }
                        continue block10;
                    }
                    if (c == '\u001a' && Keyboard.isKeyDown((int)29)) {
                        this.undo();
                        break;
                    }
                    if (c < ' ' || c >= '\u007f') continue block10;
                    this.addChar(c);
                }
            }
        }
        if (oldCursorPos != this.cursorPos) {
            this.cursorVisible = true;
            this.flashTick = 0;
        }
    }

    private boolean addChar(char c) {
        if (!this.allowUppercase) {
            c = Character.toLowerCase(c);
        }
        if (this.allCaps) {
            c = Character.toUpperCase(c);
        }
        if (this.buffer.length() < this.buffer.capacity() && this.acceptChar(c)) {
            this.buffer.insert(this.cursorPos++, c);
            this.display.setText(this.buffer.toString());
            this.onEdited();
            return true;
        }
        return false;
    }

    public boolean acceptChar(char c) {
        return true;
    }

    public final void changeFocus() {
        this.editing = false;
        this.cursorVisible = false;
        this.flashTick = 0;
        this.onChangeFocus();
    }

    protected void onChangeFocus() {
    }

    protected void onEdited() {
    }

    public boolean isEditing() {
        return this.editing;
    }

    public String getText() {
        return this.display.getText();
    }

    public int length() {
        return this.display.length();
    }

    public void setFont(GLFont font) {
        this.display.setFont(font);
    }

    public void setText(String s) {
        this.display.setText(s);
        this.buffer.delete(0, this.buffer.length());
        this.buffer.append(s);
        this.cursorPos = s.length();
    }

    public void setLocation(int xp, int yp) {
        this.display.setLocation(xp, yp);
    }

    private int getCursorXPos() {
        if (!this.editing) {
            return 0;
        }
        Rectangle tempBounds = this.display.getGlyphBounds(this.cursorPos - 1, null);
        return tempBounds.getX() + tempBounds.getWidth();
    }

    public void render(SimpleRenderer renderer) {
        final int cursorX = this.getCursorXPos();
        renderer.glRender(new GLRenderable(){

            public void render() {
                GL11.glEnable((int)3089);
            }
        });
        if (cursorX - this.display.getX() > this.width && this.editing) {
            renderer.glRender(new GLRenderable(){

                public void render() {
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)(TextField.this.width - cursorX + TextField.this.display.getX()), (float)0.0f, (float)0.0f);
                }
            });
        }
        float wRatio = (float)Game.getViewPort().getWidth() / (float)Game.getWidth();
        float hRatio = (float)Game.getViewPort().getHeight() / (float)Game.getHeight();
        final int sx = (int)((float)this.display.getX() * wRatio) + Game.getViewPort().getX();
        final int sw = (int)((float)this.width * wRatio);
        int cy = this.display.getY() - this.display.getFont().getDescent();
        final int sy = (int)((float)cy * hRatio) + Game.getViewPort().getY();
        final int sh = (int)((float)this.display.getFont().getHeight() * hRatio);
        renderer.glRender(new GLRenderable(){

            public void render() {
                GL11.glScissor((int)sx, (int)sy, (int)sw, (int)sh);
            }
        });
        this.display.render(renderer);
        renderer.glRender(new GLRenderable(){

            public void render() {
                GL11.glDisable((int)3089);
            }
        });
        if (this.cursorVisible && this.editing) {
            renderer.glRender(new GLRenderable(){

                public void render() {
                    GL11.glDisable((int)3553);
                }
            });
            if (this.display.isColoured()) {
                ColorUtil.setGLColorPre((ReadableColor)this.display.getBottomColour(), (int)this.display.getAlpha(), (SimpleRenderer)renderer);
            }
            short idx = renderer.glVertex2f((float)cursorX, (float)cy);
            renderer.glVertex2f((float)(cursorX + 4), (float)cy);
            if (this.display.isColoured()) {
                ColorUtil.setGLColorPre((ReadableColor)this.display.getTopColour(), (int)this.display.getAlpha(), (SimpleRenderer)renderer);
            }
            renderer.glVertex2f((float)(cursorX + 4), (float)(cy + this.display.getFont().getHeight()));
            renderer.glVertex2f((float)cursorX, (float)(cy + this.display.getFont().getHeight()));
            renderer.glRender(6, new short[]{(short)(idx + 0), (short)(idx + 1), (short)(idx + 2), (short)(idx + 3)});
            renderer.glRender(new GLRenderable(){

                public void render() {
                    GL11.glEnable((int)3553);
                }
            });
        }
        if (cursorX - this.display.getX() > this.width && this.editing) {
            renderer.glRender(new GLRenderable(){

                public void render() {
                    GL11.glPopMatrix();
                }
            });
        }
    }

    public void setAllowUppercase(boolean allowUppercase) {
        this.allowUppercase = allowUppercase;
    }

    public void setAllCaps(boolean allCaps) {
        this.allCaps = allCaps;
    }

    public void setAlpha(int alpha) {
        this.display.setAlpha(alpha);
    }

    public void setBottomColour(ReadableColor c) {
        this.display.setBottomColour(c);
    }

    public void setColour(ReadableColor c) {
        this.display.setColour(c);
    }

    public void setTopColour(ReadableColor c) {
        this.display.setTopColour(c);
    }
}

