/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet.widgets;

import com.shavenpuppy.jglib.opengl.ColorUtil;
import com.shavenpuppy.jglib.sprites.SimpleRenderable;
import com.shavenpuppy.jglib.sprites.SimpleRenderer;
import org.lwjgl.util.ReadableColor;

public class Ring
implements SimpleRenderable {
    private static final int DEFAULT_STEPS = 128;
    private ReadableColor color = ReadableColor.WHITE;
    private float thickness = 1.0f;
    private int steps;
    private float dash = 1.0f;
    private float radius;
    private float x;
    private float y;
    private int alpha = 255;
    private short[] indices;

    public Ring() {
        this.setSteps(128);
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public float getRadius() {
        return this.radius;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setLocation(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void setSteps(int steps) {
        if (this.steps != steps) {
            this.steps = steps;
            this.indices = null;
            this.indices = new short[steps * 2 + 2];
        }
    }

    public void setThickness(float thickness) {
        this.thickness = thickness;
    }

    public void setColor(ReadableColor color) {
        this.color = color;
    }

    public int getSteps() {
        return this.steps;
    }

    public ReadableColor getColor() {
        return this.color;
    }

    public float getThickness() {
        return this.thickness;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public void setDash(float dash) {
        this.dash = dash;
    }

    public float getDash() {
        return this.dash;
    }

    public void render(SimpleRenderer renderer) {
        if (this.radius <= 0.0f || this.alpha <= 0) {
            return;
        }
        short idx = renderer.getVertexOffset();
        ColorUtil.setGLColorPre((ReadableColor)this.color, (int)this.alpha, (SimpleRenderer)renderer);
        int count = 0;
        int i = 0;
        while (i <= this.steps) {
            double angle = (double)i * Math.PI * 2.0 / (double)this.steps;
            float tx = (float)((double)i * Math.PI * 2.0 * (double)this.radius / (double)((float)this.steps * this.dash));
            renderer.glTexCoord2f(tx, 0.0f);
            renderer.glVertex2f(this.x + (float)Math.cos(angle) * this.radius, this.y + (float)Math.sin(angle) * this.radius);
            renderer.glTexCoord2f(tx, 1.0f);
            renderer.glVertex2f(this.x + (float)Math.cos(angle) * (this.radius - this.thickness), this.y + (float)Math.sin(angle) * (this.radius - this.thickness));
            this.indices[count] = (short)(idx + count);
            this.indices[count + 1] = (short)(idx + count + 1);
            count += 2;
            ++i;
        }
        renderer.glRender(5, this.indices);
    }
}

