/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet.widgets;

import com.shavenpuppy.jglib.sprites.SimpleRenderable;
import com.shavenpuppy.jglib.sprites.SimpleRenderer;
import java.util.HashMap;
import java.util.Map;
import net.puppygames.applet.Factory;
import net.puppygames.applet.Pool;
import net.puppygames.applet.SimplePool;

public class RenderedCircle
implements SimpleRenderable {
    private static final float DEFAULT_SEGMENTS_PER_RADIUS = 0.25f;
    private static final int MIN_SEGMENTS = 8;
    private static final int MAX_SEGMENTS = 256;
    private static Map<Integer, Pool<short[]>> INDEX_POOL = new HashMap<Integer, Pool<short[]>>();
    private float segmentsPerRadius = 0.25f;
    private float x;
    private float y;
    private float radius;
    private float thickness = 1.0f;

    public RenderedCircle() {
    }

    public RenderedCircle(float x, float y, float radius, float thickness) {
        this.x = x;
        this.y = y;
        this.radius = radius;
        this.thickness = thickness;
    }

    public void setSegmentsPerRadius(float segmentsPerRadius) {
        this.segmentsPerRadius = segmentsPerRadius;
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public void setThickness(float thickness) {
        this.thickness = thickness;
    }

    public void setLocation(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void render(SimpleRenderer renderer) {
        if (this.radius <= 0.0f || this.thickness <= 0.0f) {
            return;
        }
        int segments = (int)Math.max(8.0f, Math.max(256.0f, this.radius * this.segmentsPerRadius));
        short[] indices = RenderedCircle.obtainIndices(segments * 2 + 2);
        short offset = renderer.getVertexOffset();
        int index = 0;
        int i = 0;
        while (i <= segments) {
            double angle = (double)i * Math.PI * 2.0 / (double)segments;
            renderer.glTexCoord2f(0.0f, 0.0f);
            renderer.glVertex2f(this.x + (float)Math.cos(angle) * this.radius, this.y + (float)Math.sin(angle) * this.radius);
            renderer.glTexCoord2f(1.0f, 0.0f);
            renderer.glVertex2f(this.x + (float)Math.cos(angle) * (this.radius - this.thickness), this.y + (float)Math.sin(angle) * (this.radius - this.thickness));
            indices[index++] = (short)(offset + index);
            ++i;
        }
        indices[index++] = offset;
        indices[index++] = (short)(offset + 1);
        renderer.glRender(5, indices);
        RenderedCircle.releaseIndices(indices);
    }

    private static short[] obtainIndices(final int size) {
        Integer s = new Integer(size);
        Pool<short[]> pooled = INDEX_POOL.get(s);
        if (pooled == null) {
            pooled = new SimplePool<short[]>(new Factory<short[]>(){

                @Override
                public short[] createNew() {
                    return new short[size];
                }
            }, 1);
            INDEX_POOL.put(s, pooled);
        }
        return pooled.obtain();
    }

    private static void releaseIndices(short[] indices) {
        Integer s = new Integer(indices.length);
        Pool<short[]> pooled = INDEX_POOL.get(s);
        pooled.release(indices);
    }
}

