/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet.widgets;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.resources.Feature;
import com.shavenpuppy.jglib.sprites.Appearance;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.sprites.SpriteAllocator;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.XMLUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.puppygames.applet.Anchor;
import net.puppygames.applet.Game;
import net.puppygames.applet.Screen;
import net.puppygames.applet.widgets.PowerDisplay;
import org.lwjgl.util.Point;
import org.lwjgl.util.ReadablePoint;
import org.lwjgl.util.ReadableRectangle;
import org.lwjgl.util.Rectangle;
import org.w3c.dom.Element;

public class PowerDisplayFeature
extends Feature {
    private static final long serialVersionUID = 1L;
    private Rectangle bounds = new Rectangle(0, 0, 0, 0);
    private int gap;
    private Point location = new Point(0, 0);
    private int layer;
    private List<BarFeature> bars;
    private int dx;
    private int dy;
    private float scale = 1.0f;
    private ArrayList<Anchor> anchors;

    public PowerDisplayFeature(String name) {
        super(name);
        this.setAutoCreated();
    }

    public PowerDisplayFeature() {
        this.setAutoCreated();
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        List barElements = XMLUtil.getChildren((Element)element, (String)"bar");
        this.bars = new ArrayList<BarFeature>(barElements.size());
        for (Element barElement : barElements) {
            BarFeature bf = new BarFeature();
            bf.load(barElement, loader);
            this.bars.add(bf);
        }
        List anchorElements = XMLUtil.getChildren((Element)element, (String)"anchor");
        if (anchorElements.size() > 0) {
            this.anchors = new ArrayList(anchorElements.size());
            for (Element anchorChild : anchorElements) {
                Anchor anchor = (Anchor)loader.load(anchorChild);
                this.anchors.add(anchor);
            }
        }
    }

    protected void doCreate() {
        super.doCreate();
        for (BarFeature bar : this.bars) {
            bar.create();
        }
    }

    protected void doDestroy() {
        super.doDestroy();
        for (BarFeature bar : this.bars) {
            bar.destroy();
        }
    }

    public PowerDisplay spawn(final Screen screen) {
        PowerDisplay ret = new PowerDisplay(){
            Rectangle instance_bounds;
            BarFeature.BarInstance[] bar;
            float x;
            float y;
            int used;
            boolean visible;
            {
                this.instance_bounds = new Rectangle((ReadableRectangle)PowerDisplayFeature.this.bounds);
                this.used = -1;
                this.visible = true;
            }

            public PowerDisplayFeature getFeature() {
                return PowerDisplayFeature.this;
            }

            public boolean isVisible() {
                return this.visible;
            }

            public void setVisible(boolean visible) {
                if (this.visible == visible) {
                    return;
                }
                this.visible = visible;
                this.doSetUsed();
            }

            public void setUsed(int used) {
                if (this.used == used) {
                    return;
                }
                this.used = used;
                this.doSetUsed();
            }

            private void doSetUsed() {
                int i = 0;
                while (i < Math.min(this.bar.length, this.used)) {
                    this.bar[i].setUsed(true);
                    ++i;
                }
                i = Math.max(0, this.used);
                while (i < this.bar.length) {
                    this.bar[i].setUsed(false);
                    ++i;
                }
            }

            public ReadableRectangle getBounds() {
                return new Rectangle((int)this.x, (int)this.y, 0, 0);
            }

            public void setBounds(int x, int y, int w, int h) {
                this.setLocation(x, y);
            }

            public void setLocation(float x, float y) {
                this.x = x;
                this.y = y;
                this.instance_bounds.setLocation((int)x, (int)y);
                int i = 0;
                while (i < this.bar.length) {
                    this.bar[i].setLocation(x, y);
                    if (PowerDisplayFeature.this.gap == 0) {
                        x += (float)PowerDisplayFeature.this.dx;
                        y += (float)PowerDisplayFeature.this.dy;
                    } else {
                        x += (float)PowerDisplayFeature.this.gap;
                    }
                    ++i;
                }
            }

            public ReadablePoint getBarLocation(int idx) {
                if (idx >= this.bar.length || idx < 1) {
                    return null;
                }
                return new Point((int)this.bar[idx - 1].sprite.getX(), (int)this.bar[idx - 1].sprite.getY());
            }

            public void setAlpha(int alpha) {
                int i = 0;
                while (i < this.bar.length) {
                    this.bar[i].sprite.setAlpha(alpha);
                    ++i;
                }
            }

            public Sprite getSprite(int idx) {
                return this.bar[idx].sprite;
            }

            public int getBarAt(int xx, int yy) {
                if (!this.instance_bounds.contains(xx, yy)) {
                    return -1;
                }
                return this.getMax() * (xx - this.instance_bounds.getX()) / this.instance_bounds.getWidth();
            }

            public void init(SpriteAllocator screen2) {
                this.bar = new BarFeature.BarInstance[PowerDisplayFeature.this.bars.size()];
                int i = 0;
                while (i < this.bar.length) {
                    this.bar[i] = ((BarFeature)((Object)PowerDisplayFeature.this.bars.get(i))).init(this, screen2);
                    ++i;
                }
            }

            public void cleanup() {
                if (this.bar == null) {
                    return;
                }
                int i = 0;
                while (i < this.bar.length) {
                    this.bar[i].cleanup();
                    ++i;
                }
                this.bar = null;
            }

            public int getUsed() {
                return this.used;
            }

            public int getMax() {
                return PowerDisplayFeature.this.bars.size();
            }

            public void onResized() {
                if (PowerDisplayFeature.this.anchors != null) {
                    for (Anchor anchor : PowerDisplayFeature.this.anchors) {
                        anchor.apply(this);
                    }
                } else if (PowerDisplayFeature.this.location != null) {
                    boolean centreY;
                    boolean centreX = screen.isCentred() || screen.isCentredX();
                    boolean bl = centreY = screen.isCentred() || screen.isCentredY();
                    if (centreX || centreY) {
                        int newX = centreX ? (Game.getWidth() - Game.getScale()) / 2 + PowerDisplayFeature.this.location.getX() : PowerDisplayFeature.this.location.getX();
                        int newY = centreY ? (Game.getHeight() - Game.getScale()) / 2 + PowerDisplayFeature.this.location.getY() : PowerDisplayFeature.this.location.getY();
                        this.setLocation(newX, newY);
                    }
                }
            }
        };
        ret.init(screen);
        ret.setLocation(this.location.getX(), this.location.getY());
        ret.setUsed(0);
        return ret;
    }

    public int getTotalBars() {
        return this.bars.size();
    }

    private static class BarFeature
    extends Feature {
        private static final long serialVersionUID = 1L;
        private String on;
        private String off;
        private transient Appearance onResource;
        private transient Appearance offResource;
        private Screen screen;

        private BarFeature() {
            this.setAutoCreated();
            this.setSubResource(true);
        }

        BarInstance init(PowerDisplay display, SpriteAllocator screen) {
            BarInstance ret = new BarInstance();
            ret.init(display, screen);
            return ret;
        }

        private class BarInstance {
            Sprite sprite;
            PowerDisplay display;

            private BarInstance() {
            }

            void init(PowerDisplay display, SpriteAllocator screen) {
                this.display = display;
                this.sprite = screen.allocateSprite((Serializable)((Object)BarFeature.this));
                if (this.sprite == null) {
                    throw new RuntimeException("Not enough sprites to create power display");
                }
                this.sprite.setLayer(display.getFeature().layer);
                if (BarFeature.this.offResource == null) {
                    this.sprite.setAppearance(BarFeature.this.onResource);
                    this.sprite.setVisible(false);
                }
                if (display.getFeature().scale != 1.0f) {
                    this.sprite.setScale(FPMath.fpValue((float)display.getFeature().scale));
                }
            }

            void cleanup() {
                if (this.sprite != null) {
                    this.sprite.deallocate();
                    this.sprite = null;
                }
            }

            void setUsed(boolean used) {
                if (used) {
                    this.sprite.setAppearance(BarFeature.this.onResource);
                    this.sprite.setVisible(this.display.isVisible());
                } else if (BarFeature.this.offResource == null) {
                    this.sprite.setVisible(false);
                } else {
                    this.sprite.setAppearance(BarFeature.this.offResource);
                    this.sprite.setVisible(this.display.isVisible());
                }
            }

            void setLocation(float x, float y) {
                this.sprite.setLocation(x, y);
            }
        }
    }
}

