/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet.widgets;

import com.shavenpuppy.jglib.sprites.SimpleRenderable;
import com.shavenpuppy.jglib.sprites.SimpleRenderer;
import java.io.Serializable;
import org.lwjgl.util.ReadableColor;

public class Beam
implements SimpleRenderable,
Serializable {
    private static final long serialVersionUID = 1L;
    private float x0;
    private float y0;
    private float x1;
    private float y1;
    private float width;
    private ReadableColor startColor;
    private ReadableColor endColor;

    public void setLocation(float x0, float y0, float x1, float y1) {
        this.x0 = x0;
        this.y0 = y0;
        this.x1 = x1;
        this.y1 = y1;
    }

    public void setStartColor(ReadableColor startColor) {
        this.startColor = startColor;
    }

    public void setEndColor(ReadableColor endColor) {
        this.endColor = endColor;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public float getWidth() {
        return this.width;
    }

    public float getX0() {
        return this.x0;
    }

    public float getX1() {
        return this.x1;
    }

    public float getY0() {
        return this.y0;
    }

    public float getY1() {
        return this.y1;
    }

    public void render(SimpleRenderer renderer) {
        if (this.width <= 0.0f) {
            return;
        }
        renderer.glTexCoord2f(0.0f, 0.0f);
        if (this.startColor != null) {
            renderer.glColor(this.startColor);
        }
        double angle = Math.atan2(this.y1 - this.y0, this.x1 - this.x0);
        short idx = renderer.glVertex2f(this.x0 + (float)Math.cos(angle + 2.356194490192345) * this.width * 0.5f, this.y0 + (float)Math.sin(angle + 2.356194490192345) * this.width * 0.5f);
        renderer.glTexCoord2f(0.0f, 1.0f);
        renderer.glVertex2f(this.x0 + (float)Math.cos(angle + 3.9269908169872414) * this.width * 0.5f, this.y0 + (float)Math.sin(angle + 3.9269908169872414) * this.width * 0.5f);
        renderer.glTexCoord2f(1.0f, 1.0f);
        if (this.endColor != null) {
            renderer.glColor(this.endColor);
        }
        renderer.glVertex2f(this.x1 + (float)Math.cos(angle + 5.497787143782138) * this.width * 0.5f, this.y1 + (float)Math.sin(angle + 5.497787143782138) * this.width * 0.5f);
        renderer.glTexCoord2f(1.0f, 0.0f);
        renderer.glVertex2f(this.x1 + (float)Math.cos(angle + 0.7853981633974483) * this.width * 0.5f, this.y1 + (float)Math.sin(angle + 0.7853981633974483) * this.width * 0.5f);
        renderer.glRender(6, new short[]{(short)(idx + 0), (short)(idx + 1), (short)(idx + 2), (short)(idx + 3)});
    }
}

