/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet.widgets;

import com.shavenpuppy.jglib.sprites.SimpleRenderer;
import net.puppygames.applet.Game;
import net.puppygames.applet.effects.Effect;
import net.puppygames.applet.widgets.AsynchronousOperation;
import net.puppygames.applet.widgets.MessageBox;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.util.ReadableDimension;

public class AsynchronousPanel
extends Effect {
    private final AsynchronousOperation op;
    private Thread worker;
    private MessageBox errorMessageBox;
    private MessageBox messageBox;
    private boolean finished;
    private ReadableDimension size;
    private boolean modal;
    private boolean wasEnabled;

    public AsynchronousPanel(ReadableDimension size, boolean modal, final AsynchronousOperation op) {
        this.size = size;
        this.op = op;
        this.worker = new Thread("Aynchronous Operation " + op){
            {
                super($anonymous0);
                this.setPriority(4);
            }

            public void run() {
                try {
                    try {
                        op.run();
                    }
                    catch (Exception e) {
                        AsynchronousPanel.this.onException(e);
                        AsynchronousPanel.this.finished = true;
                    }
                }
                finally {
                    AsynchronousPanel.this.finished = true;
                }
            }
        };
        this.messageBox = new MessageBox();
        this.messageBox.setSize(size.getWidth(), size.getHeight());
        this.messageBox.setMessage(op.getMessage());
        this.messageBox.setTitle(op.getTitle());
        this.modal = modal;
    }

    protected void doSpawnEffect() {
        if (this.modal) {
            this.wasEnabled = this.getScreen().isEnabled();
            this.getScreen().setEnabled(false);
        }
        this.worker.start();
    }

    protected void render() {
        this.messageBox.render((SimpleRenderer)this);
    }

    protected void doTick() {
        if (this.getScreen().isClosed() || this.getScreen().isClosing()) {
            this.op.cancel();
            this.remove();
        }
    }

    public synchronized boolean isEffectActive() {
        return !this.finished;
    }

    protected synchronized void doRemove() {
        this.finished = true;
        if (this.errorMessageBox != null) {
            new Effect(){
                boolean done;

                protected void render() {
                    AsynchronousPanel.this.errorMessageBox.render((SimpleRenderer)this);
                }

                protected void doTick() {
                    if (Mouse.isCreated() && Mouse.isButtonDown((int)0)) {
                        this.remove();
                    }
                    if (Keyboard.isCreated() && Keyboard.getNumKeyboardEvents() > 0) {
                        this.remove();
                    }
                }

                protected void doRemove() {
                    this.done = true;
                    this.getScreen().setEnabled(AsynchronousPanel.this.wasEnabled);
                }

                public boolean isEffectActive() {
                    return !this.done;
                }
            }.spawn(this.getScreen());
        } else {
            this.getScreen().setEnabled(this.wasEnabled);
        }
        this.op.onCompleted();
    }

    private synchronized void onException(Exception e) {
        this.errorMessageBox = new MessageBox();
        this.errorMessageBox.setTitle(Game.getMessage("lwjglapplets.async.title"));
        this.errorMessageBox.setMessage(this.op.getErrorMessage());
        this.errorMessageBox.setSize(this.size.getWidth(), this.size.getHeight());
        e.printStackTrace(System.err);
    }
}

