/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet.screens;

import com.shavenpuppy.jglib.opengl.GLFont;
import com.shavenpuppy.jglib.resources.MappedColor;
import com.shavenpuppy.jglib.sprites.SimpleRenderer;
import com.shavenpuppy.jglib.util.CheckOnline;
import java.rmi.Naming;
import net.puppygames.applet.Area;
import net.puppygames.applet.Game;
import net.puppygames.applet.MiniGame;
import net.puppygames.applet.Res;
import net.puppygames.applet.Screen;
import net.puppygames.applet.TickableObject;
import net.puppygames.applet.effects.SFX;
import net.puppygames.applet.screens.DialogScreen;
import net.puppygames.applet.screens.NagScreen;
import net.puppygames.applet.screens.TitleScreen;
import net.puppygames.applet.widgets.TextField;
import net.puppygames.gamecommerce.shared.ConfigurationDetails;
import net.puppygames.gamecommerce.shared.RegisterException;
import net.puppygames.gamecommerce.shared.RegistrationDetails;
import net.puppygames.gamecommerce.shared.RegistrationServerRemote;
import net.puppygames.gamecommerce.shared.ValidateUtil;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.ReadableColor;
import org.lwjgl.util.Rectangle;

public class RegisterScreen
extends Screen {
    private static final long serialVersionUID = 1L;
    private static RegisterScreen instance;
    private static final Object CANCEL_LOCK;
    private static final String EMAIL = "email";
    private static final String REGISTER = "register";
    private static final String LATER = "later";
    private static final String ORDER = "order";
    private MappedColor topColor;
    private MappedColor bottomColor;
    private MappedColor color;
    private Rectangle emailInsets;
    private String font;
    private String product;
    private String displayProduct;
    private transient TextField emailField;
    private transient boolean valid;
    private transient GLFont fontResource;
    private transient DialogScreen waitDialog;
    private transient Thread registerThread;
    private transient boolean cancelRegistration;
    private transient Runnable thingToDo;
    private transient boolean waitForMouse;
    private transient TickableObject emailObject;

    static {
        CANCEL_LOCK = new Object();
    }

    public RegisterScreen(String name) {
        super(name);
    }

    public void setWaitForMouse(boolean waitForMouse) {
        this.waitForMouse = waitForMouse;
    }

    protected void doCreateScreen() {
        this.emailField = new TextField(64, this.getArea(EMAIL).getBounds().getWidth()){

            public boolean acceptChar(char c) {
                return Character.isLetterOrDigit(c) || c >= ' ' && c <= '\u007f';
            }

            protected void onChangeFocus() {
                SFX.textEntered();
                RegisterScreen.this.requestFocus(RegisterScreen.this.getArea(RegisterScreen.REGISTER));
            }

            protected void onEdited() {
                SFX.keyTyped();
                RegisterScreen.this.checkValid();
            }
        };
        this.emailField.setFont(this.fontResource);
        if (this.color != null) {
            this.emailField.setColour((ReadableColor)this.color);
        }
        if (this.topColor != null) {
            this.emailField.setTopColour((ReadableColor)this.topColor);
        }
        if (this.bottomColor != null) {
            this.emailField.setBottomColour((ReadableColor)this.bottomColor);
        }
    }

    protected void onResized() {
        Area emailArea = this.getArea(EMAIL);
        this.emailField.setLocation(emailArea.getBounds().getX() + this.emailInsets.getX(), emailArea.getBounds().getY() + this.emailInsets.getY());
        this.emailField.setWidth(emailArea.getBounds().getWidth() - this.emailInsets.getWidth());
    }

    protected void doRegister() {
        if (this.product == null) {
            assert (instance == null);
            instance = this;
        }
    }

    protected void doDeregister() {
        if (this.product == null) {
            assert (instance != null);
            instance = null;
        }
    }

    public static void show() {
        if (!instance.isCreated()) {
            try {
                instance.create();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        instance.open();
    }

    protected void onOpen() {
        Game.setPauseEnabled(false);
        MiniGame.buy(false);
        this.emailField.setEditing(true);
        this.waitForMouse = true;
        this.checkValid();
        this.emailObject = new TickableObject(){

            protected void render() {
                RegisterScreen.this.emailField.render((SimpleRenderer)this);
            }
        };
        this.emailObject.setLayer(100);
        this.emailObject.spawn(this);
        if (Game.isRegistered()) {
            this.emailField.setText(Game.getRegistrationDetails().getEmail());
        }
        if (this.product == null) {
            this.product = Game.getTitle();
        }
        if (this.displayProduct == null) {
            this.displayProduct = Game.getDisplayTitle();
        }
    }

    protected void onClose() {
        Game.setPauseEnabled(true);
        if (this.emailObject != null) {
            this.emailObject.remove();
            this.emailObject = null;
        }
    }

    protected void onClicked(String id) {
        if (this.waitForMouse) {
            return;
        }
        if (id.equals(EMAIL)) {
            this.emailField.setEditing(true);
        } else if (id.equals(REGISTER)) {
            this.registration();
        } else if (id.equals(LATER)) {
            NagScreen.show("You know you want to!", false);
        } else if (id.equals(ORDER)) {
            MiniGame.buy(true);
        }
    }

    private void registration() {
        if (!this.checkValid()) {
            return;
        }
        if (!CheckOnline.isOnline()) {
            String failure = Game.getMessage("lwjglapplets.registerscreen.notconnected");
            failure = failure.replace("[title]", this.displayProduct);
            this.setThingToDo(this.registrationFailed(failure, true));
        } else {
            this.waitDialog = Res.getCancelDialog();
            String msg = Game.getMessage("lwjglapplets.registerscreen.registering_message");
            msg = msg.replace("[title]", this.product);
            this.waitDialog.doModal(Game.getMessage("lwjglapplets.registerscreen.registering"), msg, new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    int option = RegisterScreen.this.waitDialog.getOption();
                    if (option != -1) {
                        RegisterScreen.this.waitForMouse = true;
                        Object object = CANCEL_LOCK;
                        synchronized (object) {
                            RegisterScreen.this.cancelRegistration = true;
                            if (RegisterScreen.this.registerThread != null) {
                                RegisterScreen.this.registerThread.interrupt();
                            }
                        }
                    }
                    RegisterScreen.this.waitDialog = null;
                }
            });
            this.registerThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Unable to fully structure code
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    try {
                        server = (RegistrationServerRemote)Naming.lookup("//puppygames.net/registration");
                        ** GOTO lbl35
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                        var3_4 = RegisterScreen.access$4();
                        synchronized (var3_4) {
                            if (!RegisterScreen.access$9(RegisterScreen.this)) {
                                Game.onRegistrationDisaster();
                                msg = Game.getMessage("lwjglapplets.registerscreen.problem_connecting");
                                msg = msg.replace("[email]", Game.getSupportEmail());
                                RegisterScreen.access$10(RegisterScreen.this, RegisterScreen.this.registrationFailed(msg, false));
                            }
                            RegisterScreen.access$5(RegisterScreen.this, false);
                        }
                        var7_9 = RegisterScreen.access$4();
                        synchronized (var7_9) {
                            RegisterScreen.access$8(RegisterScreen.this, null);
                            return;
                        }
                    }
                    {
                        catch (Throwable var6_15) {
                            var7_12 = RegisterScreen.access$4();
                            synchronized (var7_12) {
                                RegisterScreen.access$8(RegisterScreen.this, null);
                                throw var6_15;
                            }
lbl35:
                            // 2 sources

                            regDetails = server.register(RegisterScreen.access$1(RegisterScreen.this).getText(), RegisterScreen.access$11(RegisterScreen.this), Game.getVersion(), Game.getInstallation(), System.getProperty("os.name"), (ConfigurationDetails)Game.getConfiguration());
                            Game.onRegistrationRecovery();
                            RegisterScreen.access$10(RegisterScreen.this, RegisterScreen.this.registrationSuccess(regDetails));
                        }
                        catch (RegisterException e) {
                            Game.onRegistrationRecovery();
                            RegisterScreen.access$10(RegisterScreen.this, RegisterScreen.this.registrationFailed(e.getMessage(), true));
                            var7_10 = RegisterScreen.access$4();
                            synchronized (var7_10) {
                                RegisterScreen.access$8(RegisterScreen.this, null);
                                return;
                            }
                        }
                        catch (Throwable e) {}
                        {
                            e.printStackTrace(System.err);
                            var4_8 = RegisterScreen.access$4();
                            synchronized (var4_8) {
                                if (!RegisterScreen.access$9(RegisterScreen.this)) {
                                    Game.onRegistrationDisaster();
                                    msg = Game.getMessage("lwjglapplets.registerscreen.problem_registering");
                                    msg = msg.replace("[email]", Game.getSupportEmail());
                                    RegisterScreen.access$10(RegisterScreen.this, RegisterScreen.this.registrationFailed(msg, true));
                                    RegisterScreen.access$5(RegisterScreen.this, false);
                                }
                            }
                        }
                        var7_11 = RegisterScreen.access$4();
                        synchronized (var7_11) {
                            RegisterScreen.access$8(RegisterScreen.this, null);
                            return;
                        }
                    }
                    var7_13 = RegisterScreen.access$4();
                    synchronized (var7_13) {
                        RegisterScreen.access$8(RegisterScreen.this, null);
                        return;
                    }
                }
            };
            this.registerThread.start();
        }
    }

    protected Runnable registrationFailed(final String message, final boolean fatal) {
        return new Runnable(){

            public void run() {
                if (RegisterScreen.this.waitDialog != null && RegisterScreen.this.waitDialog.isOpen()) {
                    RegisterScreen.this.waitDialog.close();
                    RegisterScreen.this.waitDialog = null;
                }
                Res.getInfoDialog().doModal(Game.getMessage("lwjglapplets.registerscreen.failed"), message, new Runnable(){

                    public void run() {
                        Res.getInfoDialog().getOption();
                        if (fatal) {
                            TitleScreen.show();
                        }
                        RegisterScreen.this.waitForMouse = true;
                    }
                });
                MiniGame.buy(false);
            }
        };
    }

    protected final void maybeClearWaitDialog() {
        if (this.waitDialog != null && this.waitDialog.isOpen()) {
            this.waitDialog.close();
            this.waitDialog = null;
        }
    }

    protected Runnable registrationSuccess(final RegistrationDetails regDetails) {
        return new Runnable(){

            public void run() {
                MiniGame.clearBuy();
                Game.onRemoteCallSuccess();
                TitleScreen.instantiate();
                Game.setRegistrationDetails(regDetails);
                RegisterScreen.this.maybeClearWaitDialog();
                String msg = Game.getMessage("lwjglapplets.registerscreen.success_message");
                msg = msg.replace("[title]", RegisterScreen.this.displayProduct);
                Res.getInfoDialog().doModal(Game.getMessage("lwjglapplets.registerscreen.success"), msg, new Runnable(){

                    public void run() {
                        Res.getInfoDialog().getOption();
                        TitleScreen.show();
                    }
                });
            }
        };
    }

    private synchronized void setThingToDo(Runnable thingToDo) {
        this.thingToDo = thingToDo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doTick() {
        if (!this.isBlocked()) {
            if (!Mouse.isButtonDown((int)0)) {
                this.waitForMouse = false;
            }
            this.emailField.tick();
            boolean wasEnabled = this.getArea(REGISTER).isEnabled();
            if (wasEnabled != this.valid) {
                this.setEnabled(REGISTER, this.valid);
            }
        }
        RegisterScreen registerScreen = this;
        synchronized (registerScreen) {
            if (this.thingToDo != null) {
                this.thingToDo.run();
                this.thingToDo = null;
            }
        }
    }

    private boolean checkValid() {
        this.valid = ValidateUtil.isEmail((String)this.emailField.getText());
        return this.valid;
    }

    protected void preRender() {
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
    }

    static /* synthetic */ void access$8(RegisterScreen registerScreen, Thread thread) {
        registerScreen.registerThread = thread;
    }

    static /* synthetic */ boolean access$9(RegisterScreen registerScreen) {
        return registerScreen.cancelRegistration;
    }

    static /* synthetic */ void access$10(RegisterScreen registerScreen, Runnable runnable) {
        registerScreen.setThingToDo(runnable);
    }

    static /* synthetic */ String access$11(RegisterScreen registerScreen) {
        return registerScreen.product;
    }
}

