/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet.effects;

import com.shavenpuppy.jglib.interpolators.ColorInterpolator;
import com.shavenpuppy.jglib.interpolators.Interpolator;
import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.opengl.GLRenderable;
import com.shavenpuppy.jglib.resources.ColorSequenceWrapper;
import net.puppygames.applet.Screen;
import net.puppygames.applet.effects.Effect;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;
import org.lwjgl.util.ReadableColor;

public class StrobeEffect
extends Effect {
    private static StrobeEffect instance;
    private static final short[] INDICES;
    private final Color cachedColor = new Color();
    private ReadableColor color;
    private ReadableColor finalColor;
    private ColorSequenceWrapper sequence;
    private int duration;
    private int tick;

    static {
        short[] sArray = new short[4];
        sArray[1] = 1;
        sArray[2] = 2;
        sArray[3] = 3;
        INDICES = sArray;
    }

    private StrobeEffect() {
        if (instance != null) {
            instance.remove();
            instance = this;
        }
    }

    public StrobeEffect(ReadableColor color, int duration) {
        this();
        this.color = color;
        this.finalColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), 0);
        this.duration = duration;
    }

    public StrobeEffect(ColorSequenceWrapper sequence) {
        this();
        this.sequence = sequence;
    }

    public boolean isEffectActive() {
        if (this.sequence != null) {
            return !this.sequence.isFinished(this.tick);
        }
        return this.tick < this.duration;
    }

    protected void doTick() {
        ++this.tick;
        if (this.sequence == null) {
            ColorInterpolator.interpolate((ReadableColor)this.color, (ReadableColor)this.finalColor, (float)((float)this.tick / (float)this.duration), (Interpolator)LinearInterpolator.instance, (Color)this.cachedColor);
        } else {
            this.sequence.getColor(this.tick, this.cachedColor);
        }
    }

    protected void render() {
        if (!this.isStarted()) {
            return;
        }
        if ((this.tick & 4) == 0) {
            this.glRender(new GLRenderable(){

                public void render() {
                    GL11.glEnable((int)3042);
                    GL11.glDisable((int)3553);
                    GL11.glBlendFunc((int)1, (int)1);
                }
            });
            Screen s = this.getScreen();
            float preMultAlpha = (float)this.cachedColor.getAlpha() / 255.0f;
            this.glColor4ub((byte)((float)this.cachedColor.getRed() * preMultAlpha), (byte)((float)this.cachedColor.getGreenByte() * preMultAlpha), (byte)((float)this.cachedColor.getBlueByte() * preMultAlpha), this.cachedColor.getAlphaByte());
            this.glVertex2f(0.0f, 0.0f);
            this.glVertex2f(s.getWidth(), 0.0f);
            this.glVertex2f(s.getWidth(), s.getHeight());
            this.glVertex2f(0.0f, s.getHeight());
            this.glRender(6, INDICES);
        }
    }

    public int getDefaultLayer() {
        return Integer.MAX_VALUE;
    }

    protected void doRemove() {
        instance = null;
    }

    public boolean isBackgroundEffect() {
        return true;
    }
}

