/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet.effects;

import com.shavenpuppy.jglib.interpolators.ColorInterpolator;
import com.shavenpuppy.jglib.interpolators.Interpolator;
import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import net.puppygames.applet.effects.Effect;
import org.lwjgl.util.Color;
import org.lwjgl.util.ReadableColor;

public abstract class SimpleBaseEffect
extends Effect {
    private final Color cachedColor = new Color();
    private int duration;
    private int fadeDuration;
    private int tick;
    private int fadeTick;
    private float hue;
    private boolean coloured;
    private float x;
    private float y;
    private int width;
    private int height;
    private float vx;
    private float vy;
    private float ax;
    private float ay;
    private boolean finished;
    private ReadableColor startColor;
    private ReadableColor endColor;
    private int alpha = 255;

    public SimpleBaseEffect(ReadableColor startColor, ReadableColor endColor, int duration, int fadeDuration) {
        this.startColor = startColor;
        this.endColor = endColor;
        this.duration = duration;
        this.fadeDuration = fadeDuration;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public Color getCachedColor() {
        return this.cachedColor;
    }

    public final float getX() {
        return this.x;
    }

    public final float getY() {
        return this.y;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    protected final void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public final boolean isEffectActive() {
        return !this.isStarted() || !this.finished || this.fadeTick <= this.fadeDuration;
    }

    public final void setColoured(boolean coloured) {
        this.coloured = coloured;
    }

    public final boolean isColoured() {
        return this.coloured;
    }

    protected final void doTick() {
        this.setLocation(this.x + this.vx, this.y + this.vy);
        this.vx += this.ax;
        this.vy += this.ay;
        this.doSimpleTick();
        if (this.isFinished()) {
            ++this.fadeTick;
            float ratio = (float)this.fadeTick / (float)this.fadeDuration;
            this.cachedColor.set(this.endColor.getRed(), this.endColor.getGreen(), this.endColor.getBlue(), (int)((float)this.endColor.getAlpha() * (1.0f - ratio)));
        } else {
            ++this.tick;
            if (this.tick >= this.duration && this.duration != 0) {
                this.finished = true;
            } else if (this.coloured) {
                this.hue += 0.01f;
            }
            if (this.duration != 0) {
                float ratio = (float)this.tick / (float)this.duration;
                ColorInterpolator.interpolate((ReadableColor)this.startColor, (ReadableColor)this.endColor, (float)ratio, (Interpolator)LinearInterpolator.instance, (Color)this.cachedColor);
            } else {
                this.cachedColor.setColor(this.startColor);
            }
        }
        this.cachedColor.setAlpha(this.cachedColor.getAlpha() * this.alpha / 255);
    }

    protected void doSimpleTick() {
    }

    public final void finish() {
        this.finished = true;
    }

    public boolean isFinished() {
        return this.finished || !this.isActive();
    }

    public void setLocation(float x, float y) {
        this.x = x;
        this.y = y;
        this.doSetLocation();
    }

    protected void doSetLocation() {
    }

    public void setVelocity(float vx, float vy) {
        this.vx = vx;
        this.vy = vy;
    }

    public void setAcceleration(float ax, float ay) {
        this.ax = ax;
        this.ay = ay;
    }

    protected int getFadeTick() {
        return this.fadeTick;
    }

    protected int getFadeDuration() {
        return this.fadeDuration;
    }
}

