/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet.effects;

import com.shavenpuppy.jglib.TextLayout;
import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.opengl.ColorUtil;
import com.shavenpuppy.jglib.opengl.GLRenderable;
import com.shavenpuppy.jglib.opengl.GLTextArea;
import com.shavenpuppy.jglib.resources.Background;
import com.shavenpuppy.jglib.sprites.SimpleRenderer;
import net.puppygames.applet.Game;
import net.puppygames.applet.Res;
import net.puppygames.applet.effects.Effect;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;
import org.lwjgl.util.ReadableColor;
import org.lwjgl.util.ReadableRectangle;
import org.lwjgl.util.Rectangle;

public class ProgressEffect
extends Effect {
    private static final int MAX = 30;
    private final GLTextArea textArea = new GLTextArea();
    private int width;
    private int height;
    private int progress;
    private int direction;
    private Background.Instance background;
    private ReadableColor border;
    private ReadableColor bar;
    private Color fadeBar;
    private boolean finished;

    public ProgressEffect(String message, ReadableColor border, ReadableColor bar) {
        this.textArea.setFont(Res.getSmallFont());
        this.textArea.setVerticalAlignment(GLTextArea.BOTTOM);
        this.textArea.setHorizontalAlignment(TextLayout.CENTERED);
        this.textArea.setWidth((int)((float)Game.getWidth() * 0.66f));
        this.background = Res.getProgressBackground().spawn();
        this.setMessage(message);
        this.background.setColor(border);
        this.border = border;
        this.bar = bar;
        this.fadeBar = new Color(bar);
        this.fadeBar.setAlpha(0);
    }

    protected void render() {
        final int x = this.textArea.getX();
        final int y = this.textArea.getY();
        this.glRender(new GLRenderable(){

            public void render() {
                GL11.glDisable((int)3553);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)1, (int)771);
                GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
                GL11.glEnable((int)3553);
                GL11.glPushMatrix();
                GL11.glTranslatef((float)x, (float)(y - 12), (float)0.0f);
            }
        });
        this.background.render((SimpleRenderer)this);
        this.glRender(new GLRenderable(){

            public void render() {
                GL11.glPopMatrix();
            }
        });
        ColorUtil.setGLColorPre((ReadableColor)ReadableColor.WHITE, (SimpleRenderer)this);
        this.textArea.render((SimpleRenderer)this);
        int xpos = (int)LinearInterpolator.instance.interpolate((float)(x + 8), (float)(Game.getWidth() - x - 8), (float)this.progress / 30.0f);
        int len = (Game.getWidth() - 2 * x) / 30;
        this.glRender(new GLRenderable(){

            public void render() {
                GL11.glDisable((int)3553);
            }
        });
        ColorUtil.setGLColorPre((ReadableColor)(this.direction == 1 ? this.fadeBar : this.bar), (SimpleRenderer)this);
        short idx = this.glVertex2f(xpos, y - 4);
        ColorUtil.setGLColorPre((ReadableColor)(this.direction == 1 ? this.bar : this.fadeBar), (SimpleRenderer)this);
        this.glVertex2f(xpos + len, y - 4);
        this.glVertex2f(xpos + len, y);
        ColorUtil.setGLColorPre((ReadableColor)(this.direction == 1 ? this.fadeBar : this.bar), (SimpleRenderer)this);
        this.glVertex2f(xpos, y);
        this.glRender(6, new short[]{(short)(idx + 0), (short)(idx + 1), (short)(idx + 2), (short)(idx + 3)});
    }

    protected void doTick() {
        this.progress += this.direction;
        if (this.progress == 0) {
            this.direction = 1;
        } else if (this.progress == 29) {
            this.direction = -1;
        }
    }

    public boolean isEffectActive() {
        return !this.finished;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    public void setMessage(String message) {
        this.textArea.setText(message);
        this.width = this.textArea.getWidth();
        this.height = this.textArea.getTextHeight() + 16;
        int x = (Game.getWidth() - this.width) / 2;
        int y = (Game.getHeight() - this.height) / 2;
        this.textArea.setLocation(x, y);
        this.background.setBounds((ReadableRectangle)new Rectangle(0, 0, this.width, this.height));
    }

    public void setBorder(Color border) {
        this.border = border;
    }
}

