/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet.effects;

import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.resources.Attenuator;
import com.shavenpuppy.jglib.sound.SoundEffect;
import com.shavenpuppy.jglib.sprites.SpriteAllocator;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.WeakHashMap;
import net.puppygames.applet.Game;
import net.puppygames.applet.TickableObject;
import org.lwjgl.util.ReadablePoint;

public abstract class Effect
extends TickableObject {
    private static final WeakHashMap<SpriteAllocator, ReadablePoint> DEFAULT_OFFSETS = new WeakHashMap();
    private static final WeakHashMap<SpriteAllocator, Attenuator> DEFAULT_ATTENUATORS = new WeakHashMap();
    private static final int DEFAULT_LAYER = 100;
    private int delay = 1;
    private boolean paused;
    private ALBuffer sound;
    private ReadablePoint offset;
    private Attenuator attenuator;
    private transient SoundEffect soundEffect;

    public static void setDefaultOffset(SpriteAllocator screen, ReadablePoint defaultOffset) {
        DEFAULT_OFFSETS.put(screen, defaultOffset);
    }

    public static void setDefaultAttenuator(SpriteAllocator screen, Attenuator defaultAttenuator) {
        DEFAULT_ATTENUATORS.put(screen, defaultAttenuator);
    }

    public Effect() {
        this.setLayer(this.getDefaultLayer());
    }

    public void setOffset(ReadablePoint offset) {
        this.offset = offset;
    }

    public ReadablePoint getOffset() {
        return this.offset;
    }

    public void setAttenuator(Attenuator attenuator) {
        this.attenuator = attenuator;
    }

    public Attenuator getAttenuator() {
        return this.attenuator;
    }

    public boolean isStarted() {
        return this.delay == 0;
    }

    public final void setPaused(boolean paused) {
        if (this.paused != paused) {
            this.paused = paused;
            this.onPausedChanged();
        }
    }

    protected void onPausedChanged() {
    }

    public final boolean isPaused() {
        return this.paused;
    }

    public void start() {
        this.delay = 0;
        if (this.sound != null) {
            this.playSound(this.sound);
        }
        this.init();
    }

    protected void playSound(ALBuffer sound) {
        this.soundEffect = Game.allocateSound(sound, 1.0f, 1.0f, this);
    }

    protected final void doSpawn() {
        if (!this.isBackgroundEffect()) {
            if (this.offset == null) {
                this.setOffset(DEFAULT_OFFSETS.get((Object)this.getScreen()));
            }
            if (this.attenuator == null) {
                this.setAttenuator(DEFAULT_ATTENUATORS.get((Object)this.getScreen()));
            }
        }
        this.doSpawnEffect();
    }

    protected void doSpawnEffect() {
    }

    public final void setDelay(int delay) {
        this.delay = Math.max(1, delay + 1);
    }

    public final void tick() {
        if (this.paused) {
            return;
        }
        if (this.delay > 0) {
            --this.delay;
            if (this.delay == 0) {
                this.start();
            }
        }
        if (this.delay == 0) {
            this.doTick();
        }
        if (!this.isEffectActive()) {
            this.remove();
        }
    }

    public void update() {
        if (this.delay == 0) {
            this.doUpdate();
            if (this.soundEffect != null && this.attenuator != null) {
                this.updateSound(this.sound.getGain(), this.soundEffect);
            }
        }
    }

    protected void updateSound(float gain, SoundEffect effect) {
    }

    protected void doUpdate() {
    }

    public final void setSound(ALBuffer sound) {
        this.sound = sound;
    }

    public final ALBuffer getSound() {
        return this.sound;
    }

    protected void init() {
    }

    protected abstract void doTick();

    public void finish() {
        this.remove();
    }

    public boolean isFinished() {
        return !this.isActive();
    }

    public boolean isEffectActive() {
        return this.isActive();
    }

    public boolean isBackgroundEffect() {
        return false;
    }

    public int getDefaultLayer() {
        return 100;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new NotSerializableException(this + " is not serializable");
    }

    private void readObject(ObjectInputStream in) throws IOException {
        throw new NotSerializableException(this + " is not serializable");
    }
}

