/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet;

import com.shavenpuppy.jglib.sprites.GeometryStyle;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.sprites.Style;
import java.io.Serializable;
import net.puppygames.applet.Screen;
import net.puppygames.applet.Tickable;

public abstract class TickableObject
extends GeometryStyle
implements Tickable {
    private boolean done;
    private boolean visible = true;
    private int layer;
    private Sprite sprite;
    private Screen screen;

    public TickableObject() {
    }

    public TickableObject(int maxVertices) {
    }

    public final boolean isActive() {
        return !this.done;
    }

    public final void remove() {
        if (!this.done) {
            this.done = true;
            if (this.sprite != null) {
                this.sprite.deallocate();
                this.sprite = null;
            }
            this.doRemove();
            this.screen = null;
        }
    }

    protected void doRemove() {
    }

    public final void spawn(Screen screen) {
        assert (!this.done);
        this.screen = screen;
        screen.addTickable(this);
        this.sprite = screen.allocateSprite((Serializable)((Object)this));
        this.sprite.setStyle((Style)this);
        this.sprite.setLayer(this.layer);
        this.sprite.setVisible(this.visible);
        this.doSpawn();
    }

    protected void doSpawn() {
    }

    public final Screen getScreen() {
        return this.screen;
    }

    public final void setLayer(int layer) {
        this.layer = layer;
        if (this.sprite != null) {
            this.sprite.setLayer(layer);
        }
    }

    public final int getLayer() {
        return this.layer;
    }

    public void tick() {
    }

    public void update() {
    }

    public final void setVisible(boolean visible) {
        this.visible = visible;
        if (this.sprite != null) {
            this.sprite.setVisible(visible);
        }
        this.onSetVisible();
    }

    protected void onSetVisible() {
    }

    public final boolean isVisible() {
        return this.visible;
    }
}

