/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet;

import com.shavenpuppy.jglib.IResource;
import com.shavenpuppy.jglib.Image;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.jpeg.JPEGDecoder;
import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.openal.ALStream;
import com.shavenpuppy.jglib.resources.ClassLoaderResource;
import com.shavenpuppy.jglib.resources.Data;
import com.shavenpuppy.jglib.resources.DynamicResource;
import com.shavenpuppy.jglib.resources.Feature;
import com.shavenpuppy.jglib.resources.ResourceConverter;
import com.shavenpuppy.jglib.resources.ResourceLoadedListener;
import com.shavenpuppy.jglib.resources.StringArray;
import com.shavenpuppy.jglib.resources.TextResource;
import com.shavenpuppy.jglib.resources.TextWrapper;
import com.shavenpuppy.jglib.sound.SoundEffect;
import com.shavenpuppy.jglib.sound.SoundPlayer;
import com.shavenpuppy.jglib.sprites.SoundCommand;
import com.shavenpuppy.jglib.util.CheckOnline;
import com.shavenpuppy.jglib.util.Util;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.rmi.Naming;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import net.puppygames.applet.Binding;
import net.puppygames.applet.Configuration;
import net.puppygames.applet.GameInputStream;
import net.puppygames.applet.GameOutputStream;
import net.puppygames.applet.InputDeviceType;
import net.puppygames.applet.MouseEvent;
import net.puppygames.applet.PlayerSlot;
import net.puppygames.applet.Res;
import net.puppygames.applet.RoamingFile;
import net.puppygames.applet.Screen;
import net.puppygames.applet.Splash;
import net.puppygames.applet.Support;
import net.puppygames.applet.effects.SFX;
import net.puppygames.applet.screens.BindingsScreen;
import net.puppygames.applet.screens.TitleScreen;
import net.puppygames.gamecommerce.shared.GameInfo;
import net.puppygames.gamecommerce.shared.GameInfoServerRemote;
import net.puppygames.gamecommerce.shared.RegistrationDetails;
import net.puppygames.steam.Steam;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Sys;
import org.lwjgl.input.Controllers;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Rectangle;
import org.lwjgl.util.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Game
extends Feature {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_GAME_RESOURCE_NAME = "game.puppygames";
    private static final String DEFAULT_ROAMING_PREFS_FILENAME = "prefs.xml";
    public static final boolean DEBUG = false;
    private static final boolean REGISTERED = false;
    private static final boolean FORCEUSELOG = false;
    private static final boolean TESTREGISTER = false;
    private static final boolean[] KEYDOWN = new boolean[256];
    private static final boolean[] KEYWASDOWN = new boolean[256];
    private static final List<MouseEvent> MOUSEEVENTS = new ArrayList<MouseEvent>();
    protected static final String RESTORE_FILE = "restore.dat";
    private static boolean alwaysRun;
    private static boolean pauseEnabled;
    private static boolean sfxEnabled;
    private static boolean musicEnabled;
    private static boolean paused;
    private static boolean finished;
    private static boolean initialised;
    private static Properties properties;
    private static RegistrationDetails registrationDetails;
    private static boolean registered;
    protected static long installation;
    private static Preferences GLOBALPREFS;
    private static Preferences LOCALPREFS;
    private static Preferences ROAMINGPREFS;
    protected static Configuration configuration;
    private static Game game;
    private static GameInfo gameInfo;
    private static SoundPlayer soundPlayer;
    private static List<SoundPlayer> soundPlayers;
    private static SoundEffect music;
    private static String roamingDirPrefix;
    private static String localDirPrefix;
    private static String GAMEINFO_FILE;
    private static int musicVolume;
    private static int sfxVolume;
    private static Rectangle viewPort;
    private static String title;
    private static String version;
    private static String internalVersion;
    private static int appID;
    private static PlayerSlot playerSlot;
    private static int viewportXoffset;
    private static int viewportYoffset;
    private static int viewportWidth;
    private static int viewportHeight;
    private static boolean forceSleep;
    private static boolean modded;
    private static String modName;
    private static boolean mouseVisible;
    private static final int[] FPS;
    private static int fps;
    private static int currentFPS;
    private String displayTitle;
    private int width;
    private int height;
    private int frameRate;
    private int messageSequence;
    @Data
    private String supportEmail = "support@puppygames.net";
    @Data
    private String supportURL = "www.puppygames.net/support/support.php";
    @Data
    private String contactURL = "www.puppygames.net/contact.php";
    @Data
    private String website = "www.puppygames.net";
    @Data
    private String download = "www.puppygames.net";
    @Data
    private String buyURL = "";
    @Data
    private String moreGamesURL = "www.puppygames.net";
    @Data
    private String splash = "splash.screen";
    @Data
    private String icon;
    private int defaultFullscreen = 0;
    private boolean dontCheckMessages;
    private boolean useSlotManagement;
    private int soundVoices = 32;
    private int scale;
    private boolean dontScale;
    private boolean preregistered;
    @Data
    private String preregisteredTo;
    @Data
    private String preregisteredUntil;
    @Data
    private String preregisteredLocale;
    @Data
    private String preregisteredLanguage;
    @Data
    private String language = "en";
    private String defaultInputMode = InputDeviceType.DESKTOP.name();
    private transient int panic;
    private transient boolean wasGrabbed;
    private transient int logicalWidth;
    private transient int logicalHeight;
    private transient boolean catchUp;
    private transient float masterGain;
    private transient float targetMasterGain;
    private transient InputDeviceType inputMode;
    private static PrefsSaverThread prefsSaver;

    static {
        pauseEnabled = true;
        sfxEnabled = true;
        musicEnabled = true;
        mouseVisible = true;
        FPS = new int[60];
        fps = 0;
        currentFPS = 60;
        Image.setDecompressor((Image.JPEGDecompressor)new Image.JPEGDecompressor(){

            public void decompress(ByteBuffer src, ByteBuffer dest) throws Exception {
                byte[] data = new byte[src.capacity()];
                src.get(data);
                ByteArrayInputStream bais = new ByteArrayInputStream(data);
                Image img = JPEGDecoder.loadFromByteStream((InputStream)bais);
                dest.put(img.getData());
                img.dispose();
                dest.flip();
            }
        });
    }

    public Game(String name) {
        super(name);
    }

    public static void setPauseEnabled(boolean pauseEnabled) {
        Game.pauseEnabled = pauseEnabled;
        if (paused && !pauseEnabled) {
            paused = false;
        }
    }

    public static Game getGame() {
        return game;
    }

    public static int getWidth() {
        return Game.game.logicalWidth;
    }

    public static void setSize(int width, int height) {
        int oldWidth = Game.game.width;
        int oldHeight = Game.game.height;
        Game.game.width = width;
        Game.game.height = height;
        try {
            Game.setFullscreen(false);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            Game.game.width = oldWidth;
            Game.game.height = oldHeight;
        }
    }

    public static int getHeight() {
        return Game.game.logicalHeight;
    }

    public static int getFrameRate() {
        return Game.game.frameRate;
    }

    public static String getTitle() {
        return title;
    }

    public static String getDisplayTitle() {
        return Game.game.displayTitle;
    }

    public static String getVersion() {
        return version;
    }

    public static String getInternalVersion() {
        return internalVersion;
    }

    public static String getWebsite() {
        return Game.game.website;
    }

    public static String getMoreGamesURL() {
        return Game.game.moreGamesURL;
    }

    public static String getDownload() {
        return Game.game.download;
    }

    public static String getSupportURL() {
        return Game.game.supportURL;
    }

    public static String getSupportEmail() {
        return Game.game.supportEmail;
    }

    public static String getContactURL() {
        return Game.game.contactURL;
    }

    public static String getBuyURL() {
        return Game.game.buyURL;
    }

    public static Configuration getConfiguration() {
        return configuration;
    }

    public static GameInfo getGameInfo() {
        return gameInfo;
    }

    public static long getInstallation() {
        return installation;
    }

    public static Preferences getGlobalPreferences() {
        return GLOBALPREFS;
    }

    public static Preferences getLocalPreferences() {
        return LOCALPREFS;
    }

    public static Preferences getRoamingPreferences() {
        return ROAMINGPREFS;
    }

    public static RegistrationDetails getRegistrationDetails() {
        return registrationDetails;
    }

    public static boolean isFinished() {
        return finished;
    }

    public static boolean isPaused() {
        return paused;
    }

    public static boolean isRegistered() {
        return registered || Game.game.preregistered;
    }

    private static PrintStream redirectOutput(final PrintStream output, String fileName) throws FileNotFoundException {
        if (fileName == null || fileName.equals("")) {
            return output;
        }
        boolean append = true;
        File outFile = new File(String.valueOf(localDirPrefix) + File.separator + fileName);
        if (outFile.exists() && outFile.length() > 65535L) {
            outFile.renameTo(new File(String.valueOf(localDirPrefix) + File.separator + fileName + ".old"));
            append = false;
        }
        final FileOutputStream fos = new FileOutputStream(outFile, append);
        OutputStream os = new OutputStream(){
            boolean wroteDate;

            public void write(int b) throws IOException {
                if (!this.wroteDate) {
                    this.wroteDate = true;
                    this.write(new Date().toString());
                    this.write("\t");
                }
                output.write(b);
                fos.write(b);
                if (b == 10) {
                    this.flush();
                    output.flush();
                    this.wroteDate = false;
                }
            }

            private void write(String s) throws IOException {
                int len = s.length();
                int i = 0;
                while (i < len) {
                    this.write(s.charAt(i));
                    ++i;
                }
            }
        };
        return new PrintStream(os);
    }

    private static void badDrivers() {
        String message = ((TextWrapper)Resources.get((String)"lwjglapplets.game.baddrivers")).getText().replace("[title]", Game.getDisplayTitle());
        Game.alert(message);
        Support.doSupport("opengl");
        Game.exit();
    }

    public static void init(Properties properties, InputStream resourcesStream) throws Exception {
        PlayerSlot slot;
        String slotName;
        block59: {
            ByteArrayOutputStream baos;
            boolean backupDone;
            boolean zapPrefs;
            block57: {
                String gameResource;
                if (initialised) {
                    return;
                }
                initialised = true;
                finished = false;
                Thread timerHack = new Thread(){
                    {
                        this.setDaemon(true);
                        this.start();
                    }

                    public void run() {
                        while (true) {
                            try {
                                while (true) {
                                    Thread.sleep(Integer.MAX_VALUE);
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                continue;
                            }
                            break;
                        }
                    }
                };
                Game.properties = properties;
                Resources.load((InputStream)resourcesStream);
                title = ((TextResource)Resources.get((String)"title")).getText().trim();
                version = ((TextResource)Resources.get((String)"version")).getText().trim();
                TextResource iv = (TextResource)Resources.peek((String)"internalVersion");
                internalVersion = iv != null ? iv.getText().trim() : version;
                TextResource steamID = (TextResource)Resources.peek((String)"steam_app_id");
                appID = steamID != null ? Integer.parseInt(steamID.getText().trim()) : 0;
                try {
                    gameResource = System.getProperty("net.puppygames.applet.Game.gameResource", properties.getProperty("gameresource", DEFAULT_GAME_RESOURCE_NAME));
                }
                catch (SecurityException e) {
                    e.printStackTrace(System.err);
                    gameResource = DEFAULT_GAME_RESOURCE_NAME;
                }
                System.out.println("Game resource: " + gameResource);
                game = (Game)Resources.peek((String)gameResource);
                if (Game.game.displayTitle == null) {
                    Game.game.displayTitle = title;
                }
                System.out.println(new Date() + " Game: " + title + " " + version + " [" + internalVersion + "]");
                if (Game.isUsingSteam()) {
                    try {
                        Game.initSteam();
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                        String message = ((TextWrapper)Resources.get((String)"lwjglapplets.game.steamerror")).getText().replace("[title]", Game.getTitle());
                        Game.alert(message);
                        Game.exit();
                    }
                }
                Game.initFiles();
                try {
                    System.setOut(Game.redirectOutput(System.out, properties.getProperty("out", "out.log")));
                    System.setErr(Game.redirectOutput(System.err, properties.getProperty("err", "err.log")));
                }
                catch (FileNotFoundException e) {
                    // empty catch block
                }
                GLOBALPREFS = Preferences.userNodeForPackage(Game.class);
                installation = GLOBALPREFS.getLong("installation", 0L);
                if (installation == 0L) {
                    installation = (long)(Math.random() * 9.223372036854776E18);
                    GLOBALPREFS.putLong("installation", installation);
                }
                System.out.println("Serial " + installation);
                LOCALPREFS = Preferences.userNodeForPackage(Game.class).node(String.valueOf(title) + " Local");
                ROAMINGPREFS = Preferences.userNodeForPackage(Game.class).node(title);
                GameInputStream gis = null;
                RoamingFile prefsFile = new RoamingFile(Game.getRoamingPrefsFileName());
                zapPrefs = false;
                backupDone = false;
                baos = new ByteArrayOutputStream(0x100000);
                if (prefsFile.exists()) {
                    Game.writePrefs(baos);
                    backupDone = true;
                    try {
                        try {
                            gis = new GameInputStream(Game.getRoamingPrefsFileName());
                            Preferences.importPreferences(gis);
                        }
                        catch (Exception e) {
                            e.printStackTrace(System.err);
                            zapPrefs = true;
                            if (gis != null) {
                                try {
                                    gis.close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block57;
                        }
                    }
                    catch (Throwable throwable) {
                        if (gis != null) {
                            try {
                                gis.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    if (gis != null) {
                        try {
                            gis.close();
                        }
                        catch (IOException iOException) {}
                    }
                } else {
                    System.out.println("Preferences file " + Game.getRoamingPrefsFileName() + " does not exist.");
                    zapPrefs = true;
                }
            }
            if (zapPrefs) {
                try {
                    ROAMINGPREFS.removeNode();
                    ROAMINGPREFS.flush();
                    ROAMINGPREFS = null;
                    ROAMINGPREFS = Preferences.userNodeForPackage(Game.class).node(title);
                    if (backupDone) {
                        Preferences.importPreferences(new ByteArrayInputStream(baos.toByteArray()));
                    }
                    Game.doFlushPrefs();
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
            prefsSaver = new PrefsSaverThread();
            prefsSaver.start();
            byte[] cfg = LOCALPREFS.getByteArray("configuration", null);
            if (cfg == null) {
                Game.createConfiguration();
            } else {
                ByteArrayInputStream bais = new ByteArrayInputStream(cfg);
                ObjectInputStream ois = new ObjectInputStream(bais);
                try {
                    try {
                        configuration = (Configuration)ois.readObject();
                    }
                    catch (Exception e) {
                        Game.createConfiguration();
                        ois.close();
                        break block59;
                    }
                }
                catch (Throwable throwable) {
                    ois.close();
                    throw throwable;
                }
                ois.close();
            }
        }
        Game.checkRegistration();
        boolean wasBadExit = LOCALPREFS.getBoolean("badexit", false);
        gameInfo = new GameInfo(Game.getTitle(), Game.getVersion(), Game.getInstallation(), wasBadExit, Display.getAdapter(), Display.getVersion(), configuration.encode());
        System.out.println("Starting " + Game.getTitle() + " " + Game.getVersion() + " (language: " + Game.game.language + ")");
        if (wasBadExit) {
            String shutdownMessage = "".equals(Game.getSupportEmail()) ? ((TextWrapper)Resources.get((String)"lwjglapplets.game.badexit.url.message")).getText().replace("[url]", Game.getSupportURL()) : ((TextWrapper)Resources.get((String)"lwjglapplets.game.badexit.email.message")).getText().replace("[email]", Game.getSupportEmail());
            shutdownMessage = shutdownMessage.replace("[title]", Game.getTitle());
            Game.alert(shutdownMessage);
            Support.doSupport("crash");
        }
        LOCALPREFS.putBoolean("badexit", true);
        Game.flushPrefs();
        Game.loadDLC();
        Game.loadMods();
        DynamicResource.createAll();
        Game.initSound();
        try {
            Controllers.create();
        }
        catch (Exception shutdownMessage) {
            // empty catch block
        }
        try {
            Game.initDisplay();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            gameInfo.setException((Throwable)e);
            Game.badDrivers();
        }
        try {
            String glvendor = GL11.glGetString((int)7936);
            String glrenderer = GL11.glGetString((int)7937);
            String glversion = GL11.glGetString((int)7938);
            String gldriver = null;
            int i = glversion.indexOf(32);
            if (i != -1) {
                gldriver = glversion.substring(i + 1);
                glversion = glversion.substring(0, i);
            }
            gameInfo.update(glvendor, glrenderer, glversion, gldriver, registrationDetails);
            System.out.println("GL Vendor " + glvendor + ", GL Renderer " + glrenderer + ", GL Version " + glversion + ", " + (gldriver != null ? "GL Driver " + gldriver : ""));
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            Game.badDrivers();
            return;
        }
        Splash splashInstance = (Splash)Resources.peek((String)Game.game.splash);
        if (splashInstance != null) {
            try {
                splashInstance.create();
                Resources.setCreatingCallback((Resources.CreatingCallback)splashInstance);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                splashInstance = null;
                Game.badDrivers();
                return;
            }
        }
        SFX.createSFX();
        try {
            Res.createResources();
            Feature.autoCreate();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            gameInfo.setException((Throwable)e);
            Game.badDrivers();
            return;
        }
        Resources.setRunMode((boolean)true);
        forceSleep = properties.getProperty("sleep", Runtime.getRuntime().availableProcessors() > 1 ? "false" : "true").equalsIgnoreCase("true");
        game.create();
        Game.initInput();
        Game.loadBindings();
        if (splashInstance != null) {
            Resources.setCreatingCallback(null);
            splashInstance.destroy();
            splashInstance = null;
        }
        Game.initVsync();
        if (Game.isSlotManaged() && (slotName = ROAMINGPREFS.get("slot_" + Game.getInternalVersion(), null)) != null && (slot = new PlayerSlot(slotName)).exists()) {
            Game.setPlayerSlot(slot);
        }
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glFrustum((double)((double)(-Game.getWidth()) / 64.0), (double)((double)Game.getWidth() / 64.0), (double)((double)(-Game.getHeight()) / 64.0), (double)((double)Game.getHeight() / 64.0), (double)8.0, (double)65536.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        game.onInit();
        if (!Game.isRegistered()) {
            Game.unregisteredStartup();
        } else if (Game.game.preregistered) {
            Game.preRegisteredStartup();
        } else {
            Game.registeredStartup();
        }
        resourcesStream.close();
        resourcesStream = null;
        try {
            game.run();
        }
        catch (Throwable t) {
            System.err.println("Set exception to " + t + " : " + t.getMessage() + " Stack trace follows:");
            t.printStackTrace(System.err);
            gameInfo.setException(t);
        }
        Game.exit();
    }

    protected void onInit() {
    }

    private static void preRegisteredStartup() {
        game.onPreRegisteredStartup();
    }

    protected void onPreRegisteredStartup() {
    }

    private static void unregisteredStartup() {
        game.onUnregisteredStartup();
    }

    protected void onUnregisteredStartup() {
    }

    private static void registeredStartup() {
        game.onRegisteredStartup();
    }

    protected void onRegisteredStartup() {
    }

    private static String getRoamingSettingsDir() {
        if (Game.isUsingSteamCloud()) {
            return "";
        }
        return Game.getLocalSettingsDir();
    }

    private static String getLocalSettingsDir() {
        return properties.getProperty("home", System.getProperty("os.name").startsWith("Mac OS") ? String.valueOf(System.getProperty("user.home", "")) + "/Library/Application Support" : System.getProperty("user.home", ""));
    }

    public static String getRoamingDirectoryPrefix() {
        return roamingDirPrefix;
    }

    public static String getLocalDirPrefix() {
        return localDirPrefix;
    }

    public static String getPlayerDirectoryPrefix() {
        File f;
        String ret = String.valueOf(Game.getRoamingDirectoryPrefix()) + "slots_" + Game.getInternalVersion() + File.separator + playerSlot.getName();
        if (!Game.isUsingSteamCloud() && !(f = new File(ret)).exists()) {
            f.mkdirs();
        }
        return String.valueOf(ret) + File.separator;
    }

    public static String getSlotDirectoryPrefix() {
        String ret = String.valueOf(Game.getRoamingDirectoryPrefix()) + "slots_" + Game.getInternalVersion();
        File f = new File(ret);
        if (!f.exists()) {
            f.mkdirs();
        }
        return String.valueOf(ret) + File.separator;
    }

    private static void initFiles() {
        boolean localDirPrefixExists;
        boolean remoteDirPrefixExists;
        String remoteSettingsDirName = String.valueOf(Game.getRoamingSettingsDir()) + File.separator + "." + Game.getTitle().replace(' ', '_').toLowerCase() + '_' + Game.getInternalVersion();
        System.out.println("Roaming settings dir name=" + remoteSettingsDirName);
        if (!Game.isUsingSteamCloud()) {
            File settingsDir = new File(remoteSettingsDirName);
            if (!settingsDir.exists()) {
                System.out.println("Creating roaming settings dir: " + remoteSettingsDirName);
                settingsDir.mkdirs();
                remoteDirPrefixExists = settingsDir.exists();
            } else {
                remoteDirPrefixExists = true;
            }
        } else {
            remoteDirPrefixExists = true;
        }
        String localSettingsDirName = String.valueOf(Game.getLocalSettingsDir()) + File.separator + "." + Game.getTitle().replace(' ', '_').toLowerCase() + '_' + Game.getInternalVersion();
        System.out.println("Local settings dir name=" + localSettingsDirName);
        if (!Game.isUsingSteamCloud()) {
            File localSettingsDir = new File(localSettingsDirName);
            if (!localSettingsDir.exists()) {
                System.out.println("Creating local settings dir: " + localSettingsDirName);
                localSettingsDir.mkdirs();
                localDirPrefixExists = localSettingsDir.exists();
            } else {
                localDirPrefixExists = true;
            }
        } else {
            localDirPrefixExists = true;
        }
        localDirPrefix = localDirPrefixExists ? String.valueOf(localSettingsDirName) + File.separator : String.valueOf(Game.getRoamingSettingsDir()) + File.separator;
        roamingDirPrefix = remoteDirPrefixExists ? String.valueOf(remoteSettingsDirName) + File.separator : String.valueOf(Game.getRoamingSettingsDir()) + File.separator;
        System.out.println("Local dir prefix=" + localDirPrefix);
        System.out.println("Roaming dir prefix=" + roamingDirPrefix);
        GAMEINFO_FILE = String.valueOf(localDirPrefix) + "log.dat";
    }

    private static void writeLog() {
        block71: {
            List<Object> logList;
            File log;
            block70: {
                if (gameInfo == null) {
                    System.out.println("No game info log");
                }
                if (GAMEINFO_FILE == null) {
                    System.out.println("Couldn't write log - no filename");
                    return;
                }
                log = new File(String.valueOf(Game.getLocalSettingsDir()) + File.separator + GAMEINFO_FILE);
                logList = null;
                if (log.exists()) {
                    ObjectInputStream ois = null;
                    BufferedInputStream bis = null;
                    FileInputStream fis = null;
                    try {
                        try {
                            fis = new FileInputStream(log);
                            bis = new BufferedInputStream(fis);
                            ois = new ObjectInputStream(bis);
                            logList = (List)ois.readObject();
                        }
                        catch (Exception e) {
                            e.printStackTrace(System.err);
                            logList = new ArrayList(1);
                            if (ois != null) {
                                try {
                                    ois.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (bis != null) {
                                try {
                                    bis.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (fis != null) {
                                try {
                                    fis.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            ois = null;
                            bis = null;
                            fis = null;
                            break block70;
                        }
                    }
                    catch (Throwable throwable) {
                        if (ois != null) {
                            try {
                                ois.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (bis != null) {
                            try {
                                bis.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        ois = null;
                        bis = null;
                        fis = null;
                        throw throwable;
                    }
                    if (ois != null) {
                        try {
                            ois.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (bis != null) {
                        try {
                            bis.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ois = null;
                    bis = null;
                    fis = null;
                } else {
                    if (Game.isRegistered() && !Support.isSupportQueued()) {
                        return;
                    }
                    logList = new ArrayList<GameInfo>(1);
                }
            }
            if (gameInfo != null) {
                game.updateLog();
                logList.add(gameInfo);
            }
            boolean isOnline = Game.isRemoteCallAllowed();
            boolean submitted = false;
            if (CheckOnline.isOnline() && (isOnline || Support.isSupportQueued() || gameInfo.isCrashRecovery() || gameInfo.getException() != null)) {
                try {
                    GameInfoServerRemote server = (GameInfoServerRemote)Naming.lookup("//puppygames.net/puppygames_gameinfo_server");
                    server.submit(logList);
                    Game.onRemoteCallSuccess();
                    submitted = true;
                    log.delete();
                }
                catch (Throwable e) {
                    System.err.println(" Failed to write log: " + e);
                    e.printStackTrace(System.err);
                }
            }
            if (!submitted) {
                FileOutputStream fos = null;
                FilterOutputStream bos = null;
                ObjectOutputStream oos = null;
                try {
                    try {
                        fos = new FileOutputStream(log);
                        bos = new BufferedOutputStream(fos);
                        oos = new ObjectOutputStream(bos);
                        oos.writeObject(logList);
                        oos.flush();
                        ((BufferedOutputStream)bos).flush();
                        fos.flush();
                    }
                    catch (IOException iOException) {
                        if (oos != null) {
                            try {
                                oos.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (bos != null) {
                            try {
                                bos.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (fos == null) break block71;
                        try {
                            fos.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                finally {
                    if (oos != null) {
                        try {
                            oos.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (bos != null) {
                        try {
                            bos.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
    }

    protected void updateLog() {
    }

    public static void requestExit() {
        game.doRequestExit();
    }

    protected void doRequestExit() {
        Game.exit();
    }

    public static void exit() {
        if (!initialised) {
            return;
        }
        if (game != null) {
            game.onExit();
        }
        initialised = false;
        finished = true;
        if (soundPlayer != null && soundPlayer.isCreated()) {
            soundPlayer.destroy();
        }
        if (game != null) {
            game.cleanup();
        }
        Game.writeLog();
        if (LOCALPREFS != null) {
            LOCALPREFS.putBoolean("badexit", false);
        }
        if (prefsSaver != null) {
            prefsSaver.finish();
            prefsSaver = null;
        }
        Steam.destroy();
        AL.destroy();
        Display.destroy();
        System.exit(0);
    }

    protected void onExit() {
    }

    public static SoundEffect allocateSound(ALBuffer buffer) {
        return Game.allocateSound(buffer, 1.0f, 1.0f);
    }

    public static SoundEffect allocateSound(ALBuffer buffer, float gain, float pitch) {
        return Game.allocateSound(buffer, gain, pitch, Game.class);
    }

    public static SoundEffect allocateSound(ALBuffer buffer, float gain, float pitch, Object owner) {
        if (!AL.isCreated() || !Game.isSFXEnabled() || buffer == null || buffer.getWave() == null || soundPlayer == null) {
            return null;
        }
        SoundEffect effect = soundPlayer.allocate(buffer, (int)((float)buffer.getPriority() * gain), owner);
        if (effect != null && effect.getBuffer() != null) {
            effect.setAttenuated(false, owner);
            effect.setGain(effect.getBuffer().getGain() * (float)sfxVolume * gain / 100.0f, owner);
            effect.setPitch(effect.getBuffer().getPitch() * pitch, owner);
            if (buffer.getWave().getType() == 1) {
                effect.setPosition(0.0f, 0.0f, 0.0f, owner);
            }
        }
        return effect;
    }

    public static SoundEffect allocateSound(ALStream buffer) {
        if (!AL.isCreated() || !Game.isSFXEnabled() || buffer == null || soundPlayer == null) {
            return null;
        }
        SoundEffect effect = soundPlayer.allocate(buffer, Game.class);
        if (effect != null) {
            effect.setAttenuated(false, Game.class);
            effect.setGain(effect.getStream().getSourceStream().getGain() * (float)sfxVolume / 100.0f, Game.class);
            if (effect.getStream().getType() == 1) {
                effect.setPosition(0.0f, 0.0f, 0.0f, Game.class);
            }
        }
        return effect;
    }

    public static boolean isSFXEnabled() {
        return sfxEnabled;
    }

    public static boolean isMusicEnabled() {
        return musicEnabled;
    }

    public static void playMusic(ALStream buf, int fade, float gain) {
        boolean xfade;
        if (music == null && buf == null || music != null && (music.getStream() == null || buf == music.getStream().getSourceStream())) {
            if (music != null && music.getStream() != null) {
                music.setFade(fade + 1, gain * music.getStream().getSourceStream().getGain() * (float)musicVolume / 100.0f, false, Game.class);
            }
            return;
        }
        boolean bl = xfade = music != null;
        if (xfade) {
            music.setFade(fade + 1, 0.0f, true, Game.class);
        }
        if ((music = buf == null || !Game.isMusicEnabled() ? null : Game.allocateSound(buf)) != null) {
            if (xfade) {
                music.setGain(0.0f, Game.class);
                music.setFade(fade + 1, buf == null ? 0.0f : gain * buf.getGain() * (float)musicVolume / 100.0f, false, Game.class);
            } else {
                music.setGain(buf == null ? 0.0f : gain * buf.getGain() * (float)musicVolume / 100.0f, Game.class);
            }
        }
    }

    public static void playMusic(ALStream buf, int fade) {
        Game.playMusic(buf, fade, 1.0f);
    }

    public static void playMusic(ALBuffer buf, int fade, float gain) {
        boolean xfade;
        if (music == null && buf == null || music != null && buf == music.getBuffer()) {
            return;
        }
        boolean bl = xfade = music != null;
        if (xfade) {
            music.setFade(fade, 0.0f, true, Game.class);
        }
        if ((music = buf == null || !Game.isMusicEnabled() ? null : Game.allocateSound(buf)) != null) {
            if (xfade) {
                music.setGain(0.0f, Game.class);
                music.setFade(fade, buf == null ? 0.0f : gain * buf.getGain() * (float)musicVolume / 100.0f, false, Game.class);
            } else {
                music.setGain(buf == null ? 0.0f : gain * buf.getGain() * (float)musicVolume / 100.0f, Game.class);
            }
        }
    }

    public static void playMusic(ALBuffer buf, int fade) {
        Game.playMusic(buf, fade, 1.0f);
    }

    public static SoundEffect getMusic() {
        return music;
    }

    private static void initSound() {
        block2: {
            try {
                System.out.println("Initing sound");
                AL.create();
                soundPlayer = new SoundPlayer(Game.game.soundVoices);
                soundPlayer.create();
                SoundCommand.setDefaultSoundPlayer((SoundPlayer)soundPlayer);
                musicVolume = LOCALPREFS.getInt("musicvolume", 70);
                sfxVolume = LOCALPREFS.getInt("sfxvolume", 70);
                music = null;
            }
            catch (Exception e) {
                sfxEnabled = false;
                musicEnabled = false;
                e.printStackTrace();
                String message = ((TextWrapper)Resources.get((String)"lwjglapplets.game.badsound")).getText().replace("[title]", Game.getDisplayTitle());
                message = message.replace("[email]", Game.getSupportEmail());
                Game.alert(message);
                Support.doSupport("openal");
                if (!AL.isCreated()) break block2;
                AL.destroy();
            }
        }
    }

    private static ByteBuffer imageToBuffer(BufferedImage src, int size) {
        ComponentColorModel ccm = new ComponentColorModel(ColorSpace.getInstance(1004), true, false, 3, 0);
        ByteBuffer ret = BufferUtils.createByteBuffer((int)(size * size * 4));
        BufferedImage scaledImage = new BufferedImage(ccm, ((ColorModel)ccm).createCompatibleWritableRaster(size, size), false, null);
        Graphics2D g2d = (Graphics2D)scaledImage.getGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2d.drawImage(src, 0, 0, size, size, null);
        g2d.dispose();
        byte[] data = (byte[])scaledImage.getData().getDataElements(0, 0, size, size, new byte[size * size * 4]);
        ret.put(data);
        ret.rewind();
        return ret;
    }

    private static void createDisplay() throws LWJGLException {
        Game.setWindowSizeFromPreferences();
        Display.setResizable((boolean)true);
        try {
            BufferedImage iconImage = ImageIO.read(Thread.currentThread().getContextClassLoader().getResource(Game.game.icon));
            ByteBuffer[] imageBuffer = null;
            switch (LWJGLUtil.getPlatform()) {
                case 3: {
                    imageBuffer = new ByteBuffer[]{Game.imageToBuffer(iconImage, iconImage.getWidth()), Game.imageToBuffer(iconImage, 16), Game.imageToBuffer(iconImage, 32)};
                    break;
                }
                case 2: {
                    imageBuffer = new ByteBuffer[]{Game.imageToBuffer(iconImage, 128)};
                    break;
                }
                case 1: {
                    imageBuffer = new ByteBuffer[]{Game.imageToBuffer(iconImage, 32)};
                }
            }
            if (imageBuffer != null) {
                Display.setIcon((ByteBuffer[])imageBuffer);
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
        Display.setTitle((String)Game.getDisplayTitle());
        Display.create();
    }

    private static void setWindowSizeFromPreferences() throws LWJGLException {
        int desktopWidth = Display.getDesktopDisplayMode().getWidth();
        int desktopHeight = Display.getDesktopDisplayMode().getHeight();
        int width = Math.max(Game.game.scale, Math.min(desktopWidth, Game.getLocalPreferences().getInt("window.width", desktopWidth * 4 / 5)));
        int height = Math.max(Game.game.scale, Math.min(desktopHeight, Game.getLocalPreferences().getInt("window.height", desktopHeight * 4 / 5)));
        Game.game.width = width;
        Game.game.height = height;
        Display.setDisplayMode((DisplayMode)new DisplayMode(width, height));
    }

    private static void initDisplay() throws Exception {
        viewportXoffset = properties.containsKey("vx") ? Integer.parseInt(properties.getProperty("vx", "0")) : 0;
        viewportYoffset = properties.containsKey("vy") ? Integer.parseInt(properties.getProperty("vy", "0")) : 0;
        viewportWidth = properties.containsKey("vw") ? Integer.parseInt(properties.getProperty("vw", "0")) : Display.getDesktopDisplayMode().getWidth();
        viewportHeight = properties.containsKey("vh") ? Integer.parseInt(properties.getProperty("vh", "0")) : Display.getDesktopDisplayMode().getHeight();
        if ("!".equals(LOCALPREFS.get("fullscreen2", "!"))) {
            LOCALPREFS.putInt("fullscreen2", Game.game.defaultFullscreen);
        }
        Game.createDisplay();
        if (Boolean.getBoolean("net.puppygames.applet.Game.windowed")) {
            Game.setFullscreen(false);
        } else {
            int fs = LOCALPREFS.getInt("fullscreen2", 0);
            switch (fs) {
                case 0: {
                    Game.setFullscreen(configuration.isFullscreen());
                    break;
                }
                case 1: {
                    Game.setFullscreen(false);
                    break;
                }
                case 2: {
                    Game.setFullscreen(true);
                }
            }
        }
    }

    public static void setFullscreen(boolean fullscreen) throws Exception {
        try {
            try {
                if (Mouse.isCreated()) {
                    Mouse.destroy();
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            try {
                if (Keyboard.isCreated()) {
                    Keyboard.destroy();
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            if (fullscreen) {
                Display.setDisplayModeAndFullscreen((DisplayMode)Display.getDesktopDisplayMode());
            } else {
                Display.setFullscreen((boolean)false);
                Game.setWindowSizeFromPreferences();
            }
            Game.game.width = Display.getWidth();
            Game.game.height = Display.getHeight();
            if (Display.isCreated()) {
                Display.update();
            }
            Game.initVsync();
            if (!Display.isCreated()) {
                Display.create();
            }
            try {
                Mouse.create();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            try {
                Keyboard.create();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            viewPort = new Rectangle(0, 0, Display.getWidth(), Display.getHeight());
            Game.resetViewport();
            GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glClear((int)16384);
            Display.update();
            Display.setResizable((boolean)false);
            if (!fullscreen) {
                Display.setResizable((boolean)true);
            }
            Game.doResize();
            LOCALPREFS.putInt("fullscreen2", fullscreen ? 2 : 1);
            try {
                LOCALPREFS.sync();
            }
            catch (BackingStoreException e) {}
        }
        catch (Exception e) {
            System.err.println("Failed to set fullscreen=" + fullscreen + " due to " + e);
            throw e;
        }
    }

    private static void initVsync() {
        int freq = Display.getDisplayMode().getFrequency();
        if (freq != Game.getFrameRate()) {
            Display.setVSyncEnabled((boolean)false);
        } else {
            Display.setVSyncEnabled((boolean)true);
        }
    }

    private static void doResize() {
        if (!Game.game.dontScale) {
            if (Game.game.width < Game.game.height) {
                double ratio = (double)Game.game.width / (double)Game.game.scale;
                Game.game.logicalWidth = Game.game.scale;
                Game.game.logicalHeight = (int)((double)Game.game.height / ratio);
            } else {
                double ratio = (double)Game.game.height / (double)Game.game.scale;
                Game.game.logicalHeight = Game.game.scale;
                Game.game.logicalWidth = (int)((double)Game.game.width / ratio);
            }
        } else {
            Game.game.logicalWidth = Game.game.width;
            Game.game.logicalHeight = Game.game.height;
        }
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glFrustum((double)((double)(-Game.game.logicalWidth) / 64.0), (double)((double)Game.game.logicalWidth / 64.0), (double)((double)(-Game.game.logicalHeight) / 64.0), (double)((double)Game.game.logicalHeight / 64.0), (double)8.0, (double)65536.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        viewPort = Display.isFullscreen() ? new Rectangle(viewportXoffset, viewportYoffset, viewportWidth, viewportHeight) : new Rectangle(0, 0, Display.getWidth(), Display.getHeight());
        Game.resetViewport();
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        Screen.onGameResized();
    }

    public static void resetViewport() {
        GL11.glViewport((int)viewPort.getX(), (int)viewPort.getY(), (int)viewPort.getWidth(), (int)viewPort.getHeight());
    }

    protected void cleanup() {
    }

    private static long generatePregregistrationKey() {
        return Game.getInstallation() ^ (long)System.getProperty("user.country").hashCode() ^ (long)System.getProperty("user.language").hashCode() << 16 ^ (long)System.getProperty("user.home").hashCode() << 32;
    }

    private static void checkRegistration() {
        if (Game.game.preregistered) {
            return;
        }
        if (Game.game.preregisteredUntil != null) {
            if (LOCALPREFS.getLong("preregistered-installation", 0L) == Game.generatePregregistrationKey()) {
                boolean ok = true;
                if (Game.game.preregisteredLocale != null) {
                    String country = Locale.getDefault().getCountry();
                    System.out.println("Country check: " + country + " vs " + Game.game.preregisteredLocale);
                    if (!Game.game.preregisteredLocale.equals(country)) {
                        ok = false;
                    }
                }
                if (Game.game.preregisteredLanguage != null) {
                    String language = Locale.getDefault().getLanguage();
                    System.out.println("Language check: " + language + " vs " + Game.game.preregisteredLanguage);
                    if (!Game.game.preregisteredLanguage.equals(language)) {
                        ok = false;
                    }
                }
                if (ok) {
                    registered = true;
                    return;
                }
            } else {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    Date until = df.parse(Game.game.preregisteredUntil);
                    if (new Date().before(until)) {
                        String language;
                        String country;
                        boolean ok = true;
                        if (Game.game.preregisteredLocale != null && !Game.game.preregisteredLocale.equals(country = Locale.getDefault().getCountry())) {
                            ok = false;
                        }
                        if (Game.game.preregisteredLanguage != null && !Game.game.preregisteredLanguage.equals(language = Locale.getDefault().getLanguage())) {
                            ok = false;
                        }
                        if (ok) {
                            LOCALPREFS.putLong("preregistered-installation", Game.generatePregregistrationKey());
                            registered = true;
                            Game.flushPrefs();
                            return;
                        }
                    }
                }
                catch (ParseException e) {
                    e.printStackTrace(System.err);
                }
            }
        }
        try {
            RegistrationDetails checkedDetails = RegistrationDetails.checkRegistration((String)Game.getTitle());
            Game.setRegistrationDetails(checkedDetails);
        }
        catch (Exception e) {
            Game.setRegistrationDetails(null);
        }
    }

    public static void setRegistrationDetails(RegistrationDetails registrationDetails) {
        if (Game.registrationDetails == registrationDetails) {
            return;
        }
        Game.registrationDetails = registrationDetails;
        if (registrationDetails != null) {
            registered = true;
            System.out.println("Game is registered: " + registrationDetails);
            registrationDetails.toPreferences();
        } else {
            System.out.println("Game is unregistered.");
            registered = false;
            RegistrationDetails.clearRegistration((String)Game.getTitle());
        }
    }

    private static void createConfiguration() throws Exception {
        configuration = new Configuration();
        if (Resources.exists((String)"configurations")) {
            StringArray configurations = (StringArray)Resources.peek((String)"configurations");
            String config = configurations.getString(Util.random((int)0, (int)(configurations.getNumStrings() - 1)));
            configuration.decode(config);
        } else {
            configuration.init();
        }
        Game.writeConfiguration();
    }

    private static void writeConfiguration() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(configuration);
        oos.flush();
        byte[] cfg = baos.toByteArray();
        LOCALPREFS.putByteArray("configuration", cfg);
        oos.close();
    }

    public static void setConfiguration(Configuration newConfiguration) throws Exception {
        configuration = newConfiguration;
        Game.writeConfiguration();
    }

    private void run() {
        int ticksToDo = 1;
        long then = Sys.getTime() & Long.MAX_VALUE;
        long framesTicked = 0L;
        long timerResolution = Sys.getTimerResolution();
        while (!finished) {
            if (!(Display.isFullscreen() || Display.getWidth() == Game.game.width && Display.getHeight() == Game.game.height)) {
                Game.game.width = Display.getWidth();
                Game.game.height = Display.getHeight();
                Game.doResize();
                Game.getLocalPreferences().putInt("window.width", Game.game.width);
                Game.getLocalPreferences().putInt("window.height", Game.game.height);
                Game.flushPrefs();
            }
            if (Display.isCloseRequested()) {
                finished = true;
                break;
            }
            if (Display.isDirty() || Display.isActive() || alwaysRun) {
                long now = Sys.getTime() & Long.MAX_VALUE;
                long currentTimerResolution = Sys.getTimerResolution();
                if (currentTimerResolution != timerResolution) {
                    timerResolution = currentTimerResolution;
                    then = now;
                }
                if (now > then) {
                    long ticksElapsed = now - then;
                    double shouldHaveTickedThisMany = (double)((long)Game.getFrameRate() * ticksElapsed) / (double)timerResolution;
                    ticksToDo = (int)Math.max(0.0, shouldHaveTickedThisMany - (double)framesTicked);
                    if (ticksToDo > 20) {
                        ticksToDo = 1;
                        then = now;
                        framesTicked = 0L;
                    }
                } else if (now < then) {
                    ticksToDo = 0;
                    then = now;
                    framesTicked = 0L;
                } else {
                    ticksToDo = 0;
                }
                if (ticksToDo > 0) {
                    int i = 0;
                    while (i < ticksToDo) {
                        if (i > 0) {
                            Display.processMessages();
                            this.catchUp = true;
                        } else {
                            this.catchUp = false;
                        }
                        long tickThen = Sys.getTime() & Long.MAX_VALUE;
                        this.tick();
                        long tickNow = Sys.getTime() & Long.MAX_VALUE;
                        long tickElapsed = tickNow - tickThen;
                        if (tickElapsed < 0L || (double)tickElapsed > (double)timerResolution / (double)Game.getFrameRate()) {
                            ticksToDo = 0;
                            then = tickThen;
                            framesTicked = 1L;
                            this.catchUp = false;
                        }
                        Thread.yield();
                        ++i;
                    }
                    if (ticksToDo > 0) {
                        if (++fps == FPS.length) {
                            fps = 0;
                        }
                        Game.FPS[Game.fps] = Game.getFrameRate() / ticksToDo;
                        int totalF = 0;
                        int i2 = 0;
                        while (i2 < FPS.length) {
                            totalF += FPS[i2];
                            ++i2;
                        }
                        currentFPS = totalF / FPS.length;
                        framesTicked += (long)ticksToDo;
                    }
                    this.render();
                    if (Game.isUsingSteam()) {
                        Steam.tick();
                    }
                    Display.update();
                }
                if (forceSleep) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    Thread.yield();
                }
                if (Game.isPaused()) {
                    this.targetMasterGain = 0.0f;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    this.targetMasterGain = 1.0f;
                }
            } else {
                this.targetMasterGain = 0.0f;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (Display.isVisible() || Display.isDirty()) {
                    this.render();
                }
                Display.update();
                if (Mouse.isGrabbed()) {
                    Mouse.setGrabbed((boolean)false);
                }
            }
            this.masterGain = Math.abs(this.targetMasterGain - this.masterGain) < 0.1f ? this.targetMasterGain : (this.targetMasterGain > this.masterGain ? (this.masterGain += 0.1f) : (this.masterGain -= 0.1f));
            if (!Game.isSFXEnabled()) continue;
            AL10.alListenerf((int)4106, (float)this.masterGain);
        }
    }

    public static boolean isCatchUp() {
        return Game.game.catchUp;
    }

    public static List<MouseEvent> getMouseEvents() {
        return MOUSEEVENTS;
    }

    private void tick() {
        Binding.poll();
        MOUSEEVENTS.clear();
        while (Mouse.next()) {
            MouseEvent event = new MouseEvent();
            event.fromMouse();
            MOUSEEVENTS.add(event);
        }
        int i = 0;
        while (i < 256) {
            if (Keyboard.isKeyDown((int)i)) {
                Game.KEYDOWN[i] = !KEYWASDOWN[i];
                Game.KEYWASDOWN[i] = true;
            } else {
                Game.KEYWASDOWN[i] = false;
                Game.KEYDOWN[i] = false;
            }
            ++i;
        }
        if (Keyboard.isKeyDown((int)1)) {
            ++this.panic;
            if (this.panic == 60) {
                Game.exit();
            }
        } else {
            this.panic = 0;
        }
        if (Game.wasKeyPressed(25) && pauseEnabled) {
            Game.setPaused(!paused);
        }
        if (!paused) {
            Timer.tick();
            this.doTick();
            Screen.tickAllScreens();
            if (AL.isCreated()) {
                int n = soundPlayers.size();
                int i2 = 0;
                while (i2 < n) {
                    SoundPlayer sp = soundPlayers.get(i2);
                    sp.play();
                    ++i2;
                }
            }
        }
    }

    public static void setPaused(boolean newPaused) {
        paused = newPaused;
        if (game != null) {
            if (paused) {
                Game.game.wasGrabbed = Mouse.isGrabbed();
                Display.setTitle((String)(String.valueOf(Game.getDisplayTitle()) + " [PAUSED]"));
                game.onPaused();
            } else {
                Display.setTitle((String)Game.getDisplayTitle());
                game.onResumed();
            }
        }
    }

    protected abstract void doTick();

    protected void onPaused() {
    }

    protected void onResumed() {
    }

    private void render() {
        Screen.updateAllScreens();
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glClear((int)16384);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)((double)(-this.logicalWidth) / 2.0)), (float)((float)((double)(-this.logicalHeight) / 2.0)), (float)-256.0f);
        this.preRender();
        Screen.renderAllScreens();
        this.postRender();
        GL11.glPopMatrix();
    }

    protected void preRender() {
    }

    protected void postRender() {
    }

    public static boolean wasKeyPressed(int key) {
        boolean ret = KEYDOWN[key];
        Game.KEYDOWN[key] = false;
        return ret;
    }

    public static void onRemoteCallSuccess() {
        LOCALPREFS.putBoolean("online", true);
        try {
            LOCALPREFS.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public static boolean isRemoteCallAllowed() {
        return LOCALPREFS.getBoolean("online", false);
    }

    public static void setMusicVolume(float vol) {
        musicVolume = (int)Math.max(0.0f, Math.min(100.0f, vol * 100.0f));
        if (music != null) {
            if (music.getStream() != null) {
                if (music.getStream().getSourceStream() != null) {
                    music.setGain(music.getStream().getSourceStream().getGain() * vol, Game.class);
                }
            } else if (music.getBuffer() != null) {
                music.setGain(music.getBuffer().getGain() * vol, Game.class);
            }
        }
        LOCALPREFS.putInt("musicvolume", musicVolume);
        try {
            LOCALPREFS.sync();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public static void setSFXVolume(float vol) {
        sfxVolume = (int)Math.max(0.0f, Math.min(100.0f, vol * 100.0f));
        LOCALPREFS.putInt("sfxvolume", sfxVolume);
        try {
            LOCALPREFS.sync();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public static float getMusicVolume() {
        return (float)musicVolume / 100.0f;
    }

    public static float getSFXVolume() {
        return (float)sfxVolume / 100.0f;
    }

    public static Rectangle getViewPort() {
        return viewPort;
    }

    public static void initInput() {
        try {
            Game.game.inputMode = InputDeviceType.valueOf(LOCALPREFS.get("inputmode", InputDeviceType.DESKTOP.name()));
        }
        catch (Exception e) {
            Game.game.inputMode = InputDeviceType.valueOf(Game.game.defaultInputMode);
        }
    }

    public static InputDeviceType getInputMode() {
        return Game.game.inputMode;
    }

    public static void loadBindings() {
        try {
            byte[] b = ROAMINGPREFS.getByteArray("bindings", null);
            if (b == null) {
                Binding.resetToDefaults();
            } else {
                Binding.load(new ByteArrayInputStream(b));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void saveBindings() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            Binding.save(baos);
            ROAMINGPREFS.putByteArray("bindings", baos.toByteArray());
            Game.flushPrefs();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void redefineKeys() {
        game.doRedefineKeys();
    }

    private static void doFlushPrefs() {
        try {
            GameOutputStream gos = new GameOutputStream(Game.getRoamingPrefsFileName());
            Game.writePrefs(gos);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writePrefs(OutputStream os) {
        if (GLOBALPREFS != null) {
            Preferences preferences = GLOBALPREFS;
            synchronized (preferences) {
                block21: {
                    try {
                        GLOBALPREFS.sync();
                        LOCALPREFS.sync();
                        ROAMINGPREFS.sync();
                        if (playerSlot != null) {
                            playerSlot.getPreferences().sync();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                    }
                    try {
                        try {
                            ROAMINGPREFS.exportSubtree(os);
                            os.flush();
                        }
                        catch (Exception e) {
                            e.printStackTrace(System.err);
                            if (os != null) {
                                try {
                                    os.close();
                                }
                                catch (IOException e2) {
                                    e2.printStackTrace(System.err);
                                }
                            }
                            break block21;
                        }
                    }
                    catch (Throwable throwable) {
                        if (os != null) {
                            try {
                                os.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace(System.err);
                            }
                        }
                        throw throwable;
                    }
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace(System.err);
                        }
                    }
                }
            }
        }
    }

    public static String getRoamingPrefsFileName() {
        return game.doGetRoamingPrefsFileName();
    }

    protected String doGetRoamingPrefsFileName() {
        return String.valueOf(Game.getRoamingDirectoryPrefix()) + DEFAULT_ROAMING_PREFS_FILENAME;
    }

    protected void doRedefineKeys() {
        BindingsScreen.show();
    }

    public int getMessageSequence() {
        return this.messageSequence;
    }

    public static void alert(String message) {
        Sys.alert((String)Game.getDisplayTitle(), (String)message);
    }

    public static void setAlwaysRun(boolean alwaysRun) {
        Game.alwaysRun = alwaysRun;
    }

    public static boolean getDontCheckMessages() {
        return Game.game.dontCheckMessages;
    }

    public static boolean isSlotManaged() {
        return Game.game.useSlotManagement;
    }

    public static PlayerSlot getPlayerSlot() {
        return playerSlot;
    }

    public static void setPlayerSlot(PlayerSlot newSlot) {
        if (newSlot == null) {
            throw new IllegalArgumentException("newSlot may not be null");
        }
        playerSlot = newSlot;
        ROAMINGPREFS.put("slot_" + Game.getInternalVersion(), newSlot.getName());
        try {
            ROAMINGPREFS.sync();
        }
        catch (BackingStoreException e) {
            e.printStackTrace(System.err);
        }
        TitleScreen.updateSlotDetails();
        game.onSetPlayerSlot();
    }

    protected void onSetPlayerSlot() {
    }

    protected void doCreate() {
        super.doCreate();
        soundPlayers = Resources.list(SoundPlayer.class);
        if (soundPlayer != null) {
            soundPlayers.add(soundPlayer);
        }
    }

    public static int getMouseX() {
        return game.doGetMouseX();
    }

    public static int getMouseY() {
        return game.doGetMouseY();
    }

    protected int doGetMouseX() {
        return Mouse.getX();
    }

    protected int doGetMouseY() {
        return Mouse.getY();
    }

    public static float logicalXtoPhysicalX(float logicalX) {
        return logicalX * (float)viewPort.getWidth() / (float)Game.getWidth() + (float)viewPort.getX();
    }

    public static float logicalYtoPhysicalY(float logicalY) {
        return logicalY * (float)viewPort.getHeight() / (float)Game.getHeight() + (float)viewPort.getY();
    }

    public static float physicalXtoLogicalX(float physicalX) {
        return (float)Game.getWidth() * (physicalX - (float)viewPort.getX()) / (float)viewPort.getWidth();
    }

    public static float physicalYtoLogicalY(float physicalY) {
        return (float)Game.getHeight() * (physicalY - (float)viewPort.getY()) / (float)viewPort.getHeight();
    }

    public static int getScale() {
        return Game.game.scale;
    }

    public static void onRegistrationDisaster() {
        if (LOCALPREFS.getBoolean("puppygames_exists", false)) {
            return;
        }
        registered = true;
    }

    public static void onRegistrationRecovery() {
        registered = false;
        LOCALPREFS.putBoolean("puppygames_exists", true);
        try {
            LOCALPREFS.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public static void flushPrefs() {
        if (prefsSaver != null) {
            prefsSaver.save();
        } else {
            Game.doFlushPrefs();
        }
    }

    public static boolean isModded() {
        return modded;
    }

    public static String getModName() {
        return modName;
    }

    private static final void loadMods() {
        modName = "";
        String modPath = properties.getProperty("mods", "");
        if (modPath.equals("")) {
            return;
        }
        StringTokenizer st = new StringTokenizer(modPath, File.pathSeparator, false);
        while (st.hasMoreTokens()) {
            String jarPath = st.nextToken().trim();
            if (jarPath.equals("")) continue;
            Game.loadMod(jarPath, false);
        }
    }

    private static final void loadDLC() {
        File dlcDir = new File("dlc");
        if (!dlcDir.exists()) {
            return;
        }
        File[] dlc = dlcDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        if (dlc == null) {
            return;
        }
        File[] fileArray = dlc;
        int n = dlc.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            try {
                String jarPath = file.getCanonicalPath();
                Game.loadMod(jarPath, true);
            }
            catch (IOException e) {
                System.err.println("failed to load DLC from jar " + file.getPath());
                e.printStackTrace(System.err);
            }
            ++n2;
        }
    }

    private static final void loadMod(String jarPath, boolean dlc) {
        File file = new File(jarPath);
        if (!file.exists()) {
            System.err.println(String.valueOf(dlc ? "DLC" : "Mod") + " at " + jarPath + " does not exist.");
            return;
        }
        try {
            String n;
            URL url;
            System.out.println("Loading " + (dlc ? "DLC" : "mod") + " at " + jarPath);
            URLClassLoader cl = new URLClassLoader(new URL[]{file.toURI().toURL()});
            ClassLoaderResource clr = new ClassLoaderResource("mod.loader");
            clr.setClassLoader((ClassLoader)cl);
            Resources.put((IResource)clr);
            if (cl.findResource("resources.dat") == null) {
                url = cl.getResource("resources.xml");
                ResourceConverter rc = new ResourceConverter(new ResourceLoadedListener(){

                    public void resourceLoaded(IResource loadedResource) {
                        System.out.println("  Loaded " + loadedResource);
                    }
                }, (ClassLoader)cl);
                rc.setOverwrite(true);
                rc.include(url.openStream());
            } else {
                url = cl.getResource("resources.dat");
                Resources.load((InputStream)url.openStream());
            }
            if (!dlc) {
                modded = true;
                if (modName.length() > 0) {
                    modName = String.valueOf(modName) + ",";
                }
                if (Resources.exists((String)"modName")) {
                    n = ((TextResource)Resources.get((String)"modName")).getText().trim();
                    if (n.equals("")) {
                        n = "unknown_mod";
                    }
                } else {
                    n = "unknown_mod";
                }
                modName = String.valueOf(modName) + n;
                System.out.println("Successfully loaded mod " + n + " from " + jarPath);
            } else {
                n = ((TextResource)Resources.get((String)"modName")).getText().trim();
                System.out.println("Successfully loaded DLC " + n + " from " + jarPath);
            }
        }
        catch (Exception e) {
            System.err.println("Failed to load " + (dlc ? "DLC" : "mod") + " at " + jarPath);
            e.printStackTrace(System.err);
        }
    }

    public static String getLanguage() {
        return Game.game.language;
    }

    public static String getMessage(String key) {
        return ((TextWrapper)Resources.get((String)key)).getText();
    }

    public static boolean isUsingSteam() {
        return appID != 0;
    }

    public static boolean isUsingSteamCloud() {
        return Game.isUsingSteam() && Steam.isCreated() && Steam.isSteamRunning() && Steam.getRemoteStorage().isCloudEnabledForAccount() && Steam.getRemoteStorage().isCloudEnabledForApp();
    }

    public static int getSteamAppID() {
        return appID;
    }

    private static void initSteam() {
        Steam.init((int)appID);
    }

    public static int getFPS() {
        return currentFPS;
    }

    public static class PrefsSaverThread
    extends Thread {
        boolean threadFinished;
        boolean triggered;

        public PrefsSaverThread() {
            super("Prefs Saver Thread");
            this.setPriority(4);
        }

        public synchronized void save() {
            this.triggered = true;
            this.notifyAll();
        }

        synchronized void finish() {
            this.threadFinished = true;
            this.save();
            try {
                this.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace(System.err);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.threadFinished) {
                PrefsSaverThread prefsSaverThread = this;
                synchronized (prefsSaverThread) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                    while (this.triggered) {
                        this.triggered = false;
                        try {
                            this.wait(200L);
                            if (this.triggered) continue;
                            Game.doFlushPrefs();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }
}

