/*
 * Decompiled with CFR 0.152.
 */
package invaders.powerups;

import com.shavenpuppy.jglib.util.Util;
import invaders.GameScreen;
import invaders.Invaders;
import invaders.Player;
import invaders.Powerup;
import invaders.PowerupFeature;
import net.puppygames.applet.Res;
import net.puppygames.applet.Screen;
import net.puppygames.applet.effects.LabelEffect;
import org.lwjgl.util.ReadableColor;

public class ScorePowerupFeature
extends PowerupFeature {
    private static final long serialVersionUID = 1L;
    private static PowerupFeature instance;

    public ScorePowerupFeature(String name) {
        super(name);
    }

    protected Powerup createInstance() {
        return new ScorePowerup(this);
    }

    protected void doRegister() {
        super.doRegister();
        instance = this;
    }

    protected void doDeregister() {
        super.doDeregister();
        instance = null;
    }

    public static PowerupFeature getInstance() {
        return instance;
    }

    private class ScorePowerup
    extends PowerupFeature.PowerupInstance {
        private static final long serialVersionUID = 1L;

        protected ScorePowerup(PowerupFeature feature) {
            super(feature);
        }

        public void onCollisionWithPlayer(Player player) {
            int award;
            switch (Util.random((int)0, (int)4)) {
                case 0: {
                    award = 100;
                    break;
                }
                case 1: {
                    award = 250;
                    break;
                }
                case 2: {
                    award = 500;
                    break;
                }
                case 3: {
                    award = 1000;
                    break;
                }
                case 4: {
                    award = 2500;
                    break;
                }
                default: {
                    award = 0;
                }
            }
            Invaders.getGameState().addScore((award *= Invaders.getGameState().getLevel() / 20 + 1) * Invaders.getGameState().getMultiplier());
            String awardMessage = Invaders.getGameState().getMultiplier() > 1 ? String.valueOf(String.valueOf(award)) + "x" + Invaders.getGameState().getMultiplier() : String.valueOf(award);
            LabelEffect effect = new LabelEffect(Res.getBigFont(), awardMessage, ReadableColor.WHITE, ReadableColor.RED, 90, 30);
            effect.spawn((Screen)GameScreen.getInstance());
            effect.setLocation((float)((int)this.getX()), (float)((int)this.getY()));
            this.pop();
        }
    }
}

