/*
 * Decompiled with CFR 0.152.
 */
package invaders.powerups;

import com.shavenpuppy.jglib.util.Util;
import invaders.GameScreen;
import invaders.Invaders;
import invaders.Player;
import invaders.Powerup;
import invaders.PowerupFeature;
import net.puppygames.applet.Res;
import net.puppygames.applet.Screen;
import net.puppygames.applet.effects.LabelEffect;
import org.lwjgl.util.ReadableColor;

public class MoneyPowerupFeature
extends PowerupFeature {
    private static final long serialVersionUID = 1L;
    private static PowerupFeature instance;

    public MoneyPowerupFeature(String name) {
        super(name);
    }

    protected Powerup createInstance() {
        return new MoneyPowerup(this);
    }

    protected void doRegister() {
        super.doRegister();
        instance = this;
    }

    protected void doDeregister() {
        super.doDeregister();
        instance = null;
    }

    public static PowerupFeature getInstance() {
        return instance;
    }

    private class MoneyPowerup
    extends PowerupFeature.PowerupInstance {
        private static final long serialVersionUID = 1L;

        protected MoneyPowerup(PowerupFeature feature) {
            super(feature);
        }

        public void onCollisionWithPlayer(Player player) {
            int award;
            switch (Util.random((int)0, (int)9)) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    award = 100;
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    award = 250;
                    break;
                }
                case 8: 
                case 9: {
                    award = 500;
                    break;
                }
                default: {
                    award = 0;
                }
            }
            Invaders.getGameState().addMoney(award *= Invaders.getGameState().getLevel() / 20 + 1);
            LabelEffect effect = new LabelEffect(Res.getBigFont(), "$" + String.valueOf(award), ReadableColor.WHITE, ReadableColor.YELLOW, 90, 30);
            effect.spawn((Screen)GameScreen.getInstance());
            effect.setLocation((float)((int)this.getX()), (float)((int)this.getY()));
            this.pop();
        }
    }
}

