/*
 * Decompiled with CFR 0.152.
 */
package invaders.behaviours;

import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import invaders.Behaviour;
import invaders.Gidrah;
import invaders.SFX;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class SquareRotating
extends Behaviour {
    private static final long serialVersionUID = 1L;
    private float rotation;
    private float distance;

    public SquareRotating(String name) {
        super(name);
    }

    protected Behaviour.Instance createInstance(Gidrah gidrah) {
        return new RotatingInstance(gidrah);
    }

    public void deathNoise() {
        SFX.enemyDeathRotating();
    }

    private static class RotatingInstance
    extends Behaviour.Instance {
        private static final long serialVersionUID = 1L;
        float initialX;
        float initialY;
        boolean free;
        private transient SquareRotating behaviour;

        public RotatingInstance(Gidrah gidrah) {
            super(gidrah);
            this.behaviour = (SquareRotating)gidrah.getBehaviour();
            this.initialX = this.getMaster().getX();
            this.initialY = this.getMaster().getY();
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
            this.behaviour = (SquareRotating)this.gidrah.getBehaviour();
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.defaultWriteObject();
        }

        public float getVX() {
            return 0.0f;
        }

        protected void doTick() {
            float oy;
            float ox;
            double angle;
            if (this.getMaster().isActive()) {
                this.initialX = this.getMaster().getX();
                this.initialY = this.getMaster().getY();
            }
            if ((angle = this.getAngle() + (double)this.behaviour.rotation) >= 360.0) {
                angle -= 360.0;
            } else if (angle < 0.0) {
                angle += 360.0;
            }
            this.setAngle(angle);
            int squareAngle = ((int)angle + 405) % 360;
            int squareSide = squareAngle / 90;
            int squarePos = squareAngle % 90;
            float ratio = (float)squarePos / 90.0f;
            switch (squareSide) {
                case 0: {
                    ox = this.behaviour.distance;
                    oy = LinearInterpolator.instance.interpolate(-this.behaviour.distance, this.behaviour.distance, ratio);
                    break;
                }
                case 1: {
                    ox = LinearInterpolator.instance.interpolate(this.behaviour.distance, -this.behaviour.distance, ratio);
                    oy = this.behaviour.distance;
                    break;
                }
                case 2: {
                    ox = -this.behaviour.distance;
                    oy = LinearInterpolator.instance.interpolate(this.behaviour.distance, -this.behaviour.distance, ratio);
                    break;
                }
                case 3: {
                    ox = LinearInterpolator.instance.interpolate(-this.behaviour.distance, this.behaviour.distance, ratio);
                    oy = -this.behaviour.distance;
                    break;
                }
                default: {
                    assert (false);
                    return;
                }
            }
            this.gidrah.setLocation(this.initialX + ox, this.initialY + oy);
        }
    }
}

