/*
 * Decompiled with CFR 0.152.
 */
package invaders.addons;

import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.util.Util;
import invaders.Entity;
import invaders.GameScreen;
import invaders.Invaders;
import invaders.Laser;
import java.util.LinkedList;
import net.puppygames.applet.Game;
import net.puppygames.applet.effects.Effect;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;

public class LaserEffect
extends Effect
implements Laser {
    private float offsetX;
    private float offsetY;
    private float x;
    private float y;
    private float tx;
    private float ty;
    private float width;
    private Color color;
    private int duration;
    private int tick;
    private boolean dangerous;

    public LaserEffect(float width, Color color, int duration, float offsetX, float offsetY) {
        this.width = width;
        this.color = color;
        this.duration = duration;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    public void setLocation(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void setTarget(float tx, float ty) {
        this.tx = tx;
        this.ty = ty;
    }

    protected void doTick() {
        ++this.tick;
        this.dangerous = Util.random((int)0, (int)3) != 0;
        float x = GameScreen.getPlayer().getX() + this.offsetX;
        this.setLocation(x, GameScreen.getPlayer().getY() + this.offsetY);
        if (this.dangerous) {
            LinkedList entities = new LinkedList(Invaders.getGameState().getEntities());
            Entity lowest = null;
            for (Entity entity : entities) {
                if (!entity.canCollide() || !entity.canCollideWithLaser() || !(x >= entity.getX() - entity.getRadius()) || !(x <= entity.getX() + entity.getRadius()) || lowest != null && !(entity.getY() - entity.getRadius() < lowest.getY() - lowest.getRadius())) continue;
                lowest = entity;
            }
            if (lowest != null) {
                this.setTarget(x, lowest.getY());
                lowest.onCollisionWithLaser(this);
            } else {
                this.setTarget(x, GameScreen.getPlayer().getY() + this.offsetY + (float)Game.getHeight());
            }
        }
    }

    protected void doRender() {
        if (!this.dangerous) {
            return;
        }
        float ratio = LinearInterpolator.instance.interpolate(1.0f, 0.0f, (float)this.tick / (float)this.duration);
        GL11.glColor4ub((byte)this.color.getRedByte(), (byte)this.color.getGreenByte(), (byte)this.color.getBlueByte(), (byte)((byte)((float)this.color.getAlpha() * ratio)));
        GL11.glLineWidth((float)this.width);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glBegin((int)1);
        GL11.glVertex2f((float)this.x, (float)this.y);
        GL11.glVertex2f((float)this.tx, (float)this.ty);
        GL11.glEnd();
        GL11.glLineWidth((float)1.0f);
    }

    public boolean isActive() {
        return this.tick < this.duration;
    }

    public boolean isDangerous() {
        return this.dangerous;
    }
}

