/*
 * Decompiled with CFR 0.152.
 */
package invaders;

import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.resources.Feature;
import com.shavenpuppy.jglib.sprites.AnimatedAppearance;
import com.shavenpuppy.jglib.sprites.AnimatedAppearanceResource;
import com.shavenpuppy.jglib.util.Util;
import invaders.Entity;
import invaders.GameScreen;
import invaders.Powerup;
import invaders.SFX;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import net.puppygames.applet.Screen;
import net.puppygames.applet.effects.Emitter;
import net.puppygames.applet.effects.EmitterFeature;

public abstract class PowerupFeature
extends Feature {
    private static final List POWERUPS = new ArrayList();
    private static final float FALL_SPEED = 2.0f;
    private static final int WAIT_DURATION = 60;
    private static int numPowerups;
    private String appearance;
    private String collectEmitter;
    private transient AnimatedAppearanceResource appearanceResource;
    private transient EmitterFeature collectEmitterFeature;

    public PowerupFeature(String name) {
        super(name);
        this.setAutoCreated();
    }

    protected void doRegister() {
        POWERUPS.add(this);
    }

    protected void doDeregister() {
        POWERUPS.remove((Object)this);
    }

    public static Powerup createRandom(Screen screen) {
        PowerupFeature pf = (PowerupFeature)((Object)POWERUPS.get(Util.random((int)0, (int)(POWERUPS.size() - 1))));
        Powerup ret = pf.createInstance();
        ret.spawn(screen);
        return ret;
    }

    protected abstract Powerup createInstance();

    public static int numPowerups() {
        return numPowerups;
    }

    protected static abstract class PowerupInstance
    extends Powerup {
        private static final long serialVersionUID = 1L;
        protected PowerupFeature feature;
        private boolean onFloor;
        private int tick;

        protected PowerupInstance(PowerupFeature feature) {
            this.feature = feature;
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.defaultWriteObject();
            stream.writeUTF(this.feature.getName());
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
            try {
                this.feature = (PowerupFeature)Resources.get((String)stream.readUTF());
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }

        protected final void doSpawn() {
            this.setAppearance((AnimatedAppearance)this.feature.appearanceResource);
            numPowerups = numPowerups + 1;
        }

        protected void doRespawn() {
            numPowerups = numPowerups + 1;
        }

        protected final void doRemove() {
            numPowerups = numPowerups - 1;
        }

        public final void onCollision(Entity entity) {
            entity.onCollisionWithPowerup(this);
        }

        protected final void pop() {
            SFX.collectPowerup();
            if (this.feature.collectEmitterFeature != null) {
                Emitter e = this.feature.collectEmitterFeature.spawn((Screen)GameScreen.getInstance());
                e.setLocation(this.getX(), this.getY());
            }
            this.remove();
        }

        protected final void doTick() {
            if (this.onFloor) {
                ++this.tick;
                if (this.tick > 60) {
                    this.pop();
                }
                return;
            }
            this.setLocation(this.getX(), this.getY() - 2.0f);
            if (this.getY() <= 19.0f) {
                this.onFloor = true;
            }
        }

        public boolean canCollide() {
            return true;
        }

        public boolean canCollideWithLaser() {
            return false;
        }

        public float getRadius() {
            return 8.0f;
        }
    }
}

