/*
 * Decompiled with CFR 0.152.
 */
package invaders;

import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.resources.Feature;
import com.shavenpuppy.jglib.sprites.AnimatedAppearance;
import com.shavenpuppy.jglib.sprites.AnimatedAppearanceResource;
import com.shavenpuppy.jglib.sprites.Sprite;
import invaders.Bullet;
import invaders.EnemyBullet;
import invaders.Entity;
import invaders.ExplosionEffect;
import invaders.ExplosionEffectFeature;
import invaders.GameScreen;
import invaders.Invaders;
import invaders.Laser;
import invaders.Player;
import invaders.Res;
import invaders.SFX;
import invaders.Smartbomb;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import net.puppygames.applet.Game;
import net.puppygames.applet.Screen;
import net.puppygames.applet.effects.Emitter;
import net.puppygames.applet.effects.EmitterFeature;

public class EnemyBulletFeature
extends Feature {
    private static final long serialVersionUID = 1L;
    private static final int PHASE_NORMAL = 0;
    private static final int PHASE_MINE = 1;
    private static final int PHASE_EXPLODE = 2;
    private static final int PHASE_NONE = 3;
    private AnimatedAppearanceResource appearance;
    private EmitterFeature trailEmitter;
    private String sound;
    private float velocity;
    private float acceleration;
    private float radius;
    private EmitterFeature explosionEmitter;
    private ExplosionEffectFeature explosionEffect;
    private EmitterFeature groundEmitter;
    private int maxBullets;
    private boolean meteor;
    private String splitInto;
    private int hitpoints;
    private int mineTime;
    private boolean curveBall;
    private transient ALBuffer soundResource;
    private transient int numBullets;
    private transient EnemyBulletFeature splitIntoFeature;

    public EnemyBulletFeature(String name) {
        super(name);
        this.setAutoCreated();
    }

    public EnemyBullet spawn(Screen screen) {
        EnemyBulletInstance ret = new EnemyBulletInstance(this);
        ret.spawn(screen);
        if (this.soundResource != null) {
            Game.allocateSound((ALBuffer)this.soundResource);
        }
        return ret;
    }

    public boolean isCurveBall() {
        return this.curveBall;
    }

    public float getInitialVelocity() {
        return this.velocity;
    }

    public boolean isNotDifficultyAdjusted() {
        return this.explosionEmitter == null && !this.meteor && this.splitIntoFeature == null && this.mineTime == 0;
    }

    private static class EnemyBulletInstance
    extends EnemyBullet {
        private static final long serialVersionUID = 1L;
        private transient EnemyBulletFeature feature;
        private float vx;
        private float vy;
        private transient Emitter trailEmitter;
        private int hitpoints;
        private int phase;
        private int tick;
        private transient ExplosionEffect explosionInstance;
        private Sprite shadow;

        public EnemyBulletInstance(EnemyBulletFeature feature) {
            this.feature = feature;
            this.vy = feature.velocity;
            this.hitpoints = feature.hitpoints;
        }

        public void setVelocity(float vx, float vy) {
            this.vx = vx;
            this.vy = vy;
        }

        public void setVX(float vx) {
            this.vx = vx;
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.defaultWriteObject();
            stream.writeUTF(this.feature.getName());
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
            try {
                this.feature = (EnemyBulletFeature)Resources.get((String)stream.readUTF());
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }

        protected void doTick() {
            switch (this.phase) {
                case 0: {
                    if (this.feature.curveBall) {
                        this.vx *= 0.99f;
                    }
                    this.vy += this.feature.acceleration;
                    float y = this.getY() - this.vy;
                    if (y < 19.0f) {
                        y = 19.0f;
                        if (this.feature.groundEmitter != null) {
                            Emitter emitter = this.feature.groundEmitter.spawn((Screen)GameScreen.getInstance());
                            emitter.setLocation(this.getX(), y);
                            emitter.setFloor(19.0f);
                        }
                        if (this.trailEmitter != null) {
                            this.trailEmitter.remove();
                            this.trailEmitter = null;
                        }
                        if (this.feature.mineTime > 0) {
                            this.phase = 1;
                            SFX.enemyMineLanded();
                            break;
                        }
                        if (this.feature.explosionEffect != null) {
                            this.explode();
                            break;
                        }
                        this.remove();
                        break;
                    }
                    this.setLocation(this.getX() + this.vx, y);
                    if (this.trailEmitter == null) break;
                    this.trailEmitter.setLocation(this.getX(), this.getY());
                    break;
                }
                case 1: {
                    ++this.tick;
                    if (this.tick <= this.feature.mineTime) break;
                    if (this.feature.explosionEffect != null) {
                        this.explode();
                        break;
                    }
                    this.pop();
                    break;
                }
                case 2: {
                    if (this.explosionInstance != null && this.explosionInstance.isActive()) break;
                    this.remove();
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            if (this.shadow != null) {
                this.shadow.setLocation((float)((int)this.getX()), (float)((int)this.getY()), 0.0f);
            }
        }

        private void explode() {
            if (this.explosionInstance != null) {
                return;
            }
            this.phase = 2;
            this.explosionInstance = (ExplosionEffect)this.feature.explosionEffect.spawn(GameScreen.getInstance());
            this.explosionInstance.setLocation(this.getX(), this.getY());
            SFX.enemyBombDetonated();
            this.setVisible(false);
            if (this.shadow != null) {
                this.shadow.deallocate();
                this.shadow = null;
            }
        }

        protected void doSpawn() {
            EnemyBulletFeature enemyBulletFeature = this.feature;
            enemyBulletFeature.numBullets = enemyBulletFeature.numBullets + 1;
            if (this.feature.numBullets > this.feature.maxBullets + Invaders.getGameState().getLevel() / 25) {
                this.remove();
                return;
            }
            this.setAppearance((AnimatedAppearance)this.feature.appearance);
            if (this.feature.trailEmitter != null) {
                this.trailEmitter = this.feature.trailEmitter.spawn((Screen)GameScreen.getInstance());
            }
            this.setLayer(1);
            if (!this.feature.meteor && this.feature.mineTime == 0) {
                this.shadow = GameScreen.getInstance().allocateSprite(this);
                this.shadow.setAppearance(Res.getShadowAppearance());
                this.shadow.setLayer(0);
            }
        }

        protected void doRespawn() {
            EnemyBulletFeature enemyBulletFeature = this.feature;
            enemyBulletFeature.numBullets = enemyBulletFeature.numBullets + 1;
            if (this.feature.trailEmitter != null) {
                this.trailEmitter = this.feature.trailEmitter.spawn((Screen)GameScreen.getInstance());
            }
        }

        protected void doRemove() {
            if (this.trailEmitter != null) {
                this.trailEmitter.remove();
                this.trailEmitter = null;
            }
            if (this.explosionInstance != null) {
                this.explosionInstance.remove();
                this.explosionInstance = null;
            }
            if (this.shadow != null) {
                this.shadow.deallocate();
                this.shadow = null;
            }
            EnemyBulletFeature enemyBulletFeature = this.feature;
            enemyBulletFeature.numBullets = enemyBulletFeature.numBullets - 1;
            this.phase = 3;
        }

        public boolean canCollide() {
            if (this.phase == 2) {
                return this.explosionInstance != null && this.explosionInstance.isExploding();
            }
            return true;
        }

        public boolean isSolid() {
            return this.feature.meteor || this.feature.explosionEffect != null || this.feature.mineTime > 0;
        }

        public void onCollision(Entity entity) {
            entity.onCollisionWithEnemyBullet(this);
        }

        private void pop() {
            if (this.feature.explosionEmitter != null) {
                Emitter emitter = this.feature.explosionEmitter.spawn((Screen)GameScreen.getInstance());
                emitter.setLocation(this.getX(), this.getY());
                emitter.setFloor(19.0f);
            } else {
                SFX.enemyBombDetonated();
            }
            this.remove();
        }

        public void onCollisionWithPlayer(Player player) {
            this.remove();
        }

        public void onCollisionWithSmartbomb(Smartbomb smartBomb) {
            this.remove();
        }

        public void onCollisionWithBullet(Bullet bullet) {
            if (this.feature.meteor) {
                this.split(bullet.getDamage());
            } else if (this.isSolid()) {
                this.pop();
            }
        }

        public void onCollisionWithLaser(Laser laser) {
            if (this.feature.meteor) {
                this.split(1);
            }
        }

        private void split(int damage) {
            this.hitpoints -= damage;
            SFX.ricochet();
            if (this.hitpoints <= 0) {
                if (this.feature.splitIntoFeature != null) {
                    EnemyBulletInstance s1 = (EnemyBulletInstance)this.feature.splitIntoFeature.spawn(GameScreen.getInstance());
                    EnemyBulletInstance s2 = (EnemyBulletInstance)this.feature.splitIntoFeature.spawn(GameScreen.getInstance());
                    s1.setLocation(this.getX(), this.getY());
                    s2.setLocation(this.getX(), this.getY());
                    s1.setVelocity((float)(Math.random() * 4.0 - 2.0) * this.vx, this.vy);
                    s2.setVelocity((float)(Math.random() * 4.0 - 2.0) * this.vx, this.vy);
                }
                this.pop();
            }
        }

        public float getRadius() {
            if (this.explosionInstance != null) {
                return this.explosionInstance.getRadius();
            }
            return this.feature.radius;
        }

        public boolean canCollideWithLaser() {
            return this.isSolid();
        }

        public void update() {
        }
    }
}

