/*
 * Decompiled with CFR 0.152.
 */
package invaders;

import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.resources.Feature;
import com.shavenpuppy.jglib.sprites.AnimatedAppearance;
import com.shavenpuppy.jglib.sprites.AnimatedAppearanceResource;
import invaders.Bullet;
import invaders.EnemyBullet;
import invaders.Entity;
import invaders.ExplosionEffect;
import invaders.ExplosionEffectFeature;
import invaders.GameScreen;
import invaders.Gidrah;
import invaders.Invaders;
import invaders.Saucer;
import invaders.Turret;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import net.puppygames.applet.Game;
import net.puppygames.applet.Screen;
import net.puppygames.applet.effects.Emitter;
import net.puppygames.applet.effects.EmitterFeature;

public class BulletFeature
extends Feature {
    private static final long serialVersionUID = 1L;
    private static final int MAX_POWER = 10;
    private static final BulletFeature[] BULLET_TYPES = new BulletFeature[10];
    private static int maxPower;
    private String appearance;
    private String trail;
    private String sound;
    private float velocity;
    private float acceleration;
    private float radius;
    private int power;
    private int damage;
    private String explosion;
    private boolean register;
    private boolean count;
    private transient AnimatedAppearanceResource appearanceResource;
    private transient EmitterFeature trailEmitterFeature;
    private transient ALBuffer soundResource;
    private transient ExplosionEffectFeature explosionFeature;
    private transient int numBullets;
    private static final int PHASE_SHOOT = 0;
    private static final int PHASE_EXPLODE = 1;

    public BulletFeature(String name) {
        super(name);
        this.setAutoCreated();
    }

    public Bullet spawn(Screen screen) {
        if (this.count && this.numBullets >= Invaders.getGameState().getExtraBullets() + 2 && !Invaders.getGameState().getPlayer().hasSuperGun()) {
            return null;
        }
        BulletInstance ret = new BulletInstance(this, this.explosionFeature);
        ret.spawn(screen);
        if (this.soundResource != null) {
            Game.allocateSound((ALBuffer)this.soundResource);
        }
        return ret;
    }

    public static BulletFeature getGun(int power) {
        if (power < 0 || power > BULLET_TYPES.length) {
            return null;
        }
        return BULLET_TYPES[power];
    }

    public static BulletFeature getSuperGun() {
        return BULLET_TYPES[maxPower];
    }

    protected void doRegister() {
        super.doRegister();
        if (this.register) {
            BulletFeature.BULLET_TYPES[this.power] = this;
            maxPower = Math.max(maxPower, this.power);
        }
    }

    protected void doDeregister() {
        super.doDeregister();
        if (this.register) {
            BulletFeature.BULLET_TYPES[this.power] = null;
        }
    }

    private static class BulletInstance
    extends Bullet {
        private static final long serialVersionUID = 1L;
        private transient BulletFeature feature;
        private transient ExplosionEffectFeature explosionFeature;
        private float vy;
        private int phase;
        private transient Emitter trailEmitter;
        private transient ExplosionEffect explosionEffect;

        public BulletInstance(BulletFeature feature, ExplosionEffectFeature explosionFeature) {
            this.feature = feature;
            this.explosionFeature = explosionFeature;
            this.vy = feature.velocity;
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.defaultWriteObject();
            stream.writeUTF(this.feature.getName());
            stream.writeUTF(this.explosionFeature == null ? "" : this.explosionFeature.getName());
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
            try {
                this.feature = (BulletFeature)Resources.get((String)stream.readUTF());
                String serialisedExplosionFeature = stream.readUTF();
                if (!"".equals(serialisedExplosionFeature)) {
                    this.explosionFeature = (ExplosionEffectFeature)Resources.get((String)serialisedExplosionFeature);
                }
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }

        protected void doTick() {
            if (this.phase == 0) {
                this.vy += this.feature.acceleration;
                float y = this.getY() + this.vy;
                this.setLocation(this.getX(), y);
                if (this.trailEmitter != null) {
                    this.trailEmitter.setLocation(this.getX(), this.getY());
                }
            } else if (!this.explosionEffect.isActive()) {
                this.remove();
            }
        }

        protected void doSpawn() {
            BulletFeature bulletFeature = this.feature;
            bulletFeature.numBullets = bulletFeature.numBullets + 1;
            this.setAppearance((AnimatedAppearance)this.feature.appearanceResource);
            if (this.feature.trailEmitterFeature != null) {
                this.trailEmitter = this.feature.trailEmitterFeature.spawn((Screen)GameScreen.getInstance());
            }
        }

        protected void doRespawn() {
            BulletFeature bulletFeature = this.feature;
            bulletFeature.numBullets = bulletFeature.numBullets + 1;
            if (this.feature.trailEmitterFeature != null) {
                this.trailEmitter = this.feature.trailEmitterFeature.spawn((Screen)GameScreen.getInstance());
            }
            if (this.phase == 1) {
                this.remove();
            }
        }

        protected void doRemove() {
            BulletFeature bulletFeature = this.feature;
            bulletFeature.numBullets = bulletFeature.numBullets - 1;
            if (this.trailEmitter != null) {
                this.trailEmitter.remove();
                this.trailEmitter = null;
            }
        }

        public boolean canCollide() {
            if (this.phase == 0) {
                return true;
            }
            return this.explosionEffect.isExploding();
        }

        public void onCollision(Entity entity) {
            entity.onCollisionWithBullet(this);
        }

        public void onCollisionWithTurret(Turret turret) {
            this.hitSomething();
        }

        public void onCollisionWithGidrah(Gidrah gidrah) {
            this.hitSomething();
        }

        public void onCollisionWithSaucer(Saucer saucer) {
            if (!saucer.isChallenge()) {
                this.hitSomething();
            }
        }

        private void hitSomething() {
            if (this.phase == 0) {
                if (this.explosionFeature != null) {
                    this.explosionEffect = (ExplosionEffect)this.explosionFeature.spawn(GameScreen.getInstance());
                    this.explosionEffect.setLocation(this.getX(), this.getY());
                    this.phase = 1;
                    this.setVisible(false);
                    this.doRemove();
                } else {
                    this.remove();
                }
            }
        }

        public void onCollisionWithEnemyBullet(EnemyBullet enemyBullet) {
            if (enemyBullet.isSolid()) {
                this.hitSomething();
            }
        }

        public float getRadius() {
            if (this.phase == 0) {
                return this.feature.radius;
            }
            return this.explosionEffect.getRadius();
        }

        public int getDamage() {
            return this.feature.damage;
        }

        public boolean canCollideWithLaser() {
            return false;
        }

        public void update() {
        }
    }
}

