/*
 * Decompiled with CFR 0.152.
 */
package invaders;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.resources.Feature;
import com.shavenpuppy.jglib.sprites.AnimatedAppearance;
import com.shavenpuppy.jglib.sprites.AnimatedAppearanceResource;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.util.XMLUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.puppygames.applet.Screen;
import net.puppygames.applet.effects.Emitter;
import net.puppygames.applet.effects.EmitterFeature;
import org.w3c.dom.Element;

public class Background
extends Feature {
    private static final long serialVersionUID = 1L;
    private String saucer;
    private List sections;
    private List emitters;
    private transient AnimatedAppearanceResource saucerAppearance;
    private transient List emitterInstances;

    public Background(String name) {
        super(name);
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        super.load(element, loader);
        List children = XMLUtil.getChildren((Element)element, (String)"section");
        this.sections = new LinkedList();
        for (Element child : children) {
            Section section = new Section();
            section.load(child, loader);
            this.sections.add(section);
        }
        List emitterChildren = XMLUtil.getChildren((Element)element, (String)"emitter");
        this.emitters = new LinkedList();
        for (Element child : emitterChildren) {
            EmitterFeature emitterFeature = new EmitterFeature();
            emitterFeature.load(child, loader);
            this.emitters.add(emitterFeature);
        }
    }

    protected void doCreate() {
        super.doCreate();
        for (Section section : this.sections) {
            section.create();
        }
        for (EmitterFeature emitter : this.emitters) {
            emitter.create();
        }
    }

    protected void doDestroy() {
        super.doDestroy();
        for (Section section : this.sections) {
            section.destroy();
        }
        for (EmitterFeature emitter : this.emitters) {
            emitter.destroy();
        }
    }

    public void init(Screen screen) {
        for (Section section : this.sections) {
            section.init(screen);
        }
        this.emitterInstances = new ArrayList(this.emitters.size());
        for (EmitterFeature emitter : this.emitters) {
            this.emitterInstances.add(emitter.spawn(screen));
        }
    }

    public void cleanup() {
        for (Section section : this.sections) {
            section.cleanup();
        }
        for (Emitter emitter : this.emitterInstances) {
            emitter.remove();
        }
        this.emitterInstances = null;
    }

    public AnimatedAppearanceResource getSaucerAppearance() {
        return this.saucerAppearance;
    }

    private static class Section
    extends Feature {
        private static final long serialVersionUID = 1L;
        String appearance;
        String image;
        int x;
        int y;
        int layer;
        transient AnimatedAppearanceResource appearanceResource;
        transient Sprite sprite;

        Section() {
        }

        void init(Screen screen) {
            this.sprite = screen.allocateSprite((Serializable)((Object)this));
            if (this.sprite != null) {
                this.sprite.setLocation((float)this.x, (float)this.y, 0.0f);
                this.sprite.setLayer(this.layer);
                if (this.appearanceResource != null) {
                    this.sprite.setAppearance((AnimatedAppearance)this.appearanceResource);
                }
            }
        }

        void cleanup() {
            if (this.sprite != null) {
                this.sprite.deallocate();
                this.sprite = null;
            }
        }
    }
}

