/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Sys;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.OpenGLException;
import org.lwjgl.opengl.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GLContext {
    private static final ThreadLocal<ContextCapabilities> current_capabilities = new ThreadLocal();
    private static CapabilitiesCacheEntry fast_path_cache = new CapabilitiesCacheEntry();
    private static final ThreadLocal<CapabilitiesCacheEntry> thread_cache_entries = new ThreadLocal();
    private static final Map<Object, ContextCapabilities> capability_cache = new WeakHashMap<Object, ContextCapabilities>();
    private static int gl_ref_count;
    private static boolean did_auto_load;

    static {
        Sys.initialize();
    }

    public static ContextCapabilities getCapabilities() {
        CapabilitiesCacheEntry recent_cache_entry = fast_path_cache;
        if (recent_cache_entry.owner == Thread.currentThread()) {
            return recent_cache_entry.capabilities;
        }
        return GLContext.getThreadLocalCapabilities();
    }

    private static ContextCapabilities getThreadLocalCapabilities() {
        return current_capabilities.get();
    }

    static void setCapabilities(ContextCapabilities capabilities) {
        current_capabilities.set(capabilities);
        CapabilitiesCacheEntry thread_cache_entry = thread_cache_entries.get();
        if (thread_cache_entry == null) {
            thread_cache_entry = new CapabilitiesCacheEntry();
            thread_cache_entries.set(thread_cache_entry);
        }
        thread_cache_entry.owner = Thread.currentThread();
        thread_cache_entry.capabilities = capabilities;
        fast_path_cache = thread_cache_entry;
    }

    static long getPlatformSpecificFunctionAddress(String function_prefix, String[] os_prefixes, String[] os_function_prefixes, String function) {
        String os_name = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("os.name");
            }
        });
        int i = 0;
        while (i < os_prefixes.length) {
            if (os_name.startsWith(os_prefixes[i])) {
                String platform_function_name = function.replaceFirst(function_prefix, os_function_prefixes[i]);
                long address = GLContext.getFunctionAddress(platform_function_name);
                return address;
            }
            ++i;
        }
        return 0L;
    }

    static long getFunctionAddress(String[] aliases) {
        String[] stringArray = aliases;
        int n = aliases.length;
        int n2 = 0;
        while (n2 < n) {
            String alias = stringArray[n2];
            long address = GLContext.getFunctionAddress(alias);
            if (address != 0L) {
                return address;
            }
            ++n2;
        }
        return 0L;
    }

    static native long getFunctionAddress(String var0);

    static int getSupportedExtensions(Set<String> supported_extensions) {
        int profileMask;
        block12: {
            int minorVersion;
            int majorVersion;
            block11: {
                String version = GL11.glGetString(7938);
                if (version == null) {
                    throw new IllegalStateException("glGetString(GL_VERSION) returned null - possibly caused by missing current context.");
                }
                StringTokenizer version_tokenizer = new StringTokenizer(version, ". ");
                String major_string = version_tokenizer.nextToken();
                String minor_string = version_tokenizer.nextToken();
                majorVersion = 0;
                minorVersion = 0;
                try {
                    majorVersion = Integer.parseInt(major_string);
                    minorVersion = Integer.parseInt(minor_string);
                }
                catch (NumberFormatException e) {
                    LWJGLUtil.log("The major and/or minor OpenGL version is malformed: " + e.getMessage());
                }
                int[][] nArrayArray = new int[4][];
                nArrayArray[0] = new int[]{1, 2, 3, 4, 5};
                int[] nArray = new int[2];
                nArray[1] = 1;
                nArrayArray[1] = nArray;
                int[] nArray2 = new int[4];
                nArray2[1] = 1;
                nArray2[2] = 2;
                nArray2[3] = 3;
                nArrayArray[2] = nArray2;
                int[] nArray3 = new int[2];
                nArray3[1] = 1;
                nArrayArray[3] = nArray3;
                int[][] GL_VERSIONS = nArrayArray;
                int major = 1;
                while (major <= GL_VERSIONS.length) {
                    int[] minors;
                    int[] nArray4 = minors = GL_VERSIONS[major - 1];
                    int n = minors.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int minor = nArray4[n2];
                        if (major < majorVersion || major == majorVersion && minor <= minorVersion) {
                            supported_extensions.add("OpenGL" + Integer.toString(major) + Integer.toString(minor));
                        }
                        ++n2;
                    }
                    ++major;
                }
                profileMask = 0;
                if (majorVersion >= 3) break block11;
                String extensions_string = GL11.glGetString(7939);
                if (extensions_string == null) {
                    throw new IllegalStateException("glGetString(GL_EXTENSIONS) returned null - is there a context current?");
                }
                StringTokenizer tokenizer = new StringTokenizer(extensions_string);
                while (tokenizer.hasMoreTokens()) {
                    supported_extensions.add(tokenizer.nextToken());
                }
                break block12;
            }
            int extensionCount = GL11.glGetInteger(33309);
            int i = 0;
            while (i < extensionCount) {
                supported_extensions.add(GL30.glGetStringi(7939, i));
                ++i;
            }
            if (3 >= majorVersion && 2 > minorVersion) break block12;
            Util.checkGLError();
            try {
                profileMask = GL11.glGetInteger(37158);
                Util.checkGLError();
            }
            catch (OpenGLException e) {
                LWJGLUtil.log("Failed to retrieve CONTEXT_PROFILE_MASK");
            }
        }
        return profileMask;
    }

    static void initNativeStubs(final Class<?> extension_class, Set supported_extensions, String ext_name) {
        GLContext.resetNativeStubs(extension_class);
        if (supported_extensions.contains(ext_name)) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        Method init_stubs_method = extension_class.getDeclaredMethod("initNativeStubs", new Class[0]);
                        init_stubs_method.invoke(null, new Object[0]);
                        return null;
                    }
                });
            }
            catch (Exception e) {
                LWJGLUtil.log("Failed to initialize extension " + extension_class + " - exception: " + e);
                supported_extensions.remove(ext_name);
            }
        }
    }

    public static synchronized void useContext(Object context) throws LWJGLException {
        GLContext.useContext(context, false);
    }

    public static synchronized void useContext(Object context, boolean forwardCompatible) throws LWJGLException {
        if (context == null) {
            ContextCapabilities.unloadAllStubs();
            GLContext.setCapabilities(null);
            if (did_auto_load) {
                GLContext.unloadOpenGLLibrary();
            }
            return;
        }
        if (gl_ref_count == 0) {
            GLContext.loadOpenGLLibrary();
            did_auto_load = true;
        }
        try {
            ContextCapabilities capabilities = capability_cache.get(context);
            if (capabilities == null) {
                new ContextCapabilities(forwardCompatible);
                capability_cache.put(context, GLContext.getCapabilities());
            } else {
                GLContext.setCapabilities(capabilities);
            }
        }
        catch (LWJGLException e) {
            if (did_auto_load) {
                GLContext.unloadOpenGLLibrary();
            }
            throw e;
        }
    }

    public static synchronized void loadOpenGLLibrary() throws LWJGLException {
        if (gl_ref_count == 0) {
            GLContext.nLoadOpenGLLibrary();
        }
        ++gl_ref_count;
    }

    private static native void nLoadOpenGLLibrary() throws LWJGLException;

    public static synchronized void unloadOpenGLLibrary() {
        if (--gl_ref_count == 0 && LWJGLUtil.getPlatform() != 1) {
            GLContext.nUnloadOpenGLLibrary();
        }
    }

    private static native void nUnloadOpenGLLibrary();

    static native void resetNativeStubs(Class var0);

    private static final class CapabilitiesCacheEntry {
        Thread owner;
        ContextCapabilities capabilities;

        private CapabilitiesCacheEntry() {
        }
    }
}

