/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.ByteBuffer;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Sys;
import org.lwjgl.opencl.CLCapabilities;

public final class CL {
    private static boolean created;

    static {
        Sys.initialize();
    }

    private CL() {
    }

    private static native void nCreate(String var0) throws LWJGLException;

    private static native void nCreateDefault() throws LWJGLException;

    private static native void nDestroy();

    public static boolean isCreated() {
        return created;
    }

    public static void create() throws LWJGLException {
        String[] library_names;
        String libname;
        if (created) {
            return;
        }
        switch (LWJGLUtil.getPlatform()) {
            case 3: {
                libname = "OpenCL";
                library_names = new String[]{"OpenCL.dll"};
                break;
            }
            case 1: {
                libname = "OpenCL";
                library_names = new String[]{"libOpenCL64.so", "libOpenCL.so"};
                break;
            }
            case 2: {
                libname = "OpenCL";
                library_names = new String[]{"OpenCL.dylib"};
                break;
            }
            default: {
                throw new LWJGLException("Unknown platform: " + LWJGLUtil.getPlatform());
            }
        }
        String[] oclPaths = LWJGLUtil.getLibraryPaths(libname, library_names, CL.class.getClassLoader());
        LWJGLUtil.log("Found " + oclPaths.length + " OpenCL paths");
        String[] stringArray = oclPaths;
        int n = oclPaths.length;
        int n2 = 0;
        while (n2 < n) {
            String oclPath = stringArray[n2];
            try {
                CL.nCreate(oclPath);
                created = true;
                break;
            }
            catch (LWJGLException e) {
                LWJGLUtil.log("Failed to load " + oclPath + ": " + e.getMessage());
                ++n2;
            }
        }
        if (!created && LWJGLUtil.getPlatform() == 2) {
            CL.nCreateDefault();
            created = true;
        }
        if (!created) {
            throw new LWJGLException("Could not locate OpenCL library.");
        }
        if (!CLCapabilities.OpenCL10) {
            throw new RuntimeException("OpenCL 1.0 not supported.");
        }
    }

    public static void destroy() {
    }

    static long getFunctionAddress(String[] aliases) {
        String[] stringArray = aliases;
        int n = aliases.length;
        int n2 = 0;
        while (n2 < n) {
            String aliase = stringArray[n2];
            long address = CL.getFunctionAddress(aliase);
            if (address != 0L) {
                return address;
            }
            ++n2;
        }
        return 0L;
    }

    static native long getFunctionAddress(String var0);

    static native ByteBuffer getHostBuffer(long var0, int var2);

    private static native void resetNativeStubs(Class var0);
}

