/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet.screens;

import com.shavenpuppy.jglib.resources.MappedColor;
import com.shavenpuppy.jglib.sprites.SimpleRenderer;
import java.util.prefs.BackingStoreException;
import net.puppygames.applet.Area;
import net.puppygames.applet.Game;
import net.puppygames.applet.PlayerSlot;
import net.puppygames.applet.Res;
import net.puppygames.applet.TickableObject;
import net.puppygames.applet.effects.SFX;
import net.puppygames.applet.screens.DialogScreen;
import net.puppygames.applet.widgets.TextField;
import org.lwjgl.util.ReadableColor;

public class EnterNameDialog
extends DialogScreen {
    public static final long serialVersionUID = 1L;
    private static EnterNameDialog instance;
    private static final String NAME = "name";
    private int name_x;
    private int name_y;
    private MappedColor topColor;
    private MappedColor bottomColor;
    private MappedColor color;
    private boolean allCaps;
    private boolean allowUppercase;
    private transient TextField nameField;
    private transient boolean allowCancel;
    private transient boolean okClicked;
    private transient TickableObject nameObject;

    public EnterNameDialog(String name) {
        super(name);
    }

    protected void doCreateScreen() {
        this.nameField = new TextField(14, this.getArea(NAME).getBounds().getWidth()){

            public boolean acceptChar(char c) {
                return Character.isLetterOrDigit(c) || c == ' ' || c == '_';
            }

            protected void onChangeFocus() {
                SFX.textEntered();
                EnterNameDialog.this.requestFocus(EnterNameDialog.this.getArea("ok"));
            }

            protected void onEdited() {
                SFX.keyTyped();
                EnterNameDialog.this.checkValid();
            }
        };
        if (this.color != null) {
            this.nameField.setColour((ReadableColor)this.color);
        }
        if (this.topColor != null) {
            this.nameField.setTopColour((ReadableColor)this.topColor);
        }
        if (this.bottomColor != null) {
            this.nameField.setBottomColour((ReadableColor)this.bottomColor);
        }
        this.nameField.setAllCaps(this.allCaps);
        this.nameField.setAllowUppercase(this.allowUppercase);
        this.nameField.setFont(Res.getTinyFont());
        Area field = this.getArea(NAME);
        this.nameField.setLocation(this.name_x + field.getBounds().getX(), this.name_y + field.getBounds().getY());
    }

    protected void onResized() {
        Area field = this.getArea(NAME);
        this.nameField.setLocation(this.name_x + field.getBounds().getX(), this.name_y + field.getBounds().getY());
    }

    protected void doRegister() {
        instance = this;
    }

    protected void doDeregister() {
        instance = null;
    }

    public static void show(boolean allowCancel, Runnable callback) {
        if (!instance.isCreated()) {
            try {
                instance.create();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        instance.setAllowCancel(allowCancel);
        instance.doModal("PROFILE NAME", "", callback);
        instance.open();
    }

    protected void doOnOpen() {
        Game.setPauseEnabled(false);
        this.nameField.setEditing(true);
        if (this.allowCancel) {
            this.setEnabled("cancel", true);
            this.setVisible("cancel", true);
        } else {
            this.setEnabled("cancel", false);
            this.setVisible("cancel", false);
        }
        this.checkValid();
        this.nameObject = new TickableObject(){

            protected void render() {
                EnterNameDialog.this.nameField.render((SimpleRenderer)this);
            }
        };
        this.nameObject.setLayer(100);
        this.nameObject.spawn(this);
    }

    protected void doOnClose() {
        Game.setPauseEnabled(true);
        if (this.nameObject != null) {
            this.nameObject.remove();
            this.nameObject = null;
        }
    }

    protected void onClicked(String id) {
        if (id.equals(NAME)) {
            this.nameField.setEditing(true);
        } else if (id.equals("ok")) {
            PlayerSlot newSlot = new PlayerSlot(this.nameField.getText().trim().toLowerCase());
            if (newSlot.exists()) {
                Res.getErrorDialog().doModal("ERROR!", "THAT PROFILE NAME ALREADY EXISTS. PLEASE TRY ANOTHER NAME, OR CANCEL AND SELECT THAT PROFILE.", null);
                return;
            }
            try {
                newSlot.create();
                Game.setPlayerSlot(newSlot);
                this.okClicked = true;
                this.close();
            }
            catch (BackingStoreException e) {
                e.printStackTrace(System.err);
                Res.getErrorDialog().doModal("ERROR!", "SORRY, CAN'T USE THAT PROFILE NAME. PLEASE TRY ANOTHER.", null);
                return;
            }
        } else if (id.equals("cancel") && this.allowCancel) {
            this.okClicked = false;
            this.close();
        }
    }

    protected void doTick() {
        if (!this.isBlocked()) {
            if (!this.nameField.isEditing()) {
                this.nameField.setEditing(true);
            }
            this.nameField.tick();
        } else if (this.nameField.isEditing()) {
            this.nameField.setEditing(false);
        }
    }

    private void setAllowCancel(boolean allowCancel) {
        this.allowCancel = allowCancel;
    }

    private boolean checkValid() {
        boolean ret = !this.nameField.getText().trim().equals("");
        this.setEnabled("ok", ret);
        return ret;
    }

    public static boolean isOKClicked() {
        return EnterNameDialog.instance.okClicked;
    }

    public static String getSlotName() {
        return EnterNameDialog.instance.nameField.getText().trim();
    }

    public static void setSlotName(String slotName) {
        EnterNameDialog.instance.nameField.setText(slotName == null ? "" : slotName);
    }
}

