/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet.effects;

import com.shavenpuppy.jglib.interpolators.ColorInterpolator;
import com.shavenpuppy.jglib.interpolators.Interpolator;
import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.opengl.GLRenderable;
import com.shavenpuppy.jglib.resources.ColorSequenceWrapper;
import net.puppygames.applet.Game;
import net.puppygames.applet.TickableObject;
import net.puppygames.applet.effects.Effect;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;
import org.lwjgl.util.ReadableColor;

public class StrobeEffect
extends Effect {
    private static StrobeEffect instance;
    private final Color cachedColor = new Color();
    private ReadableColor color;
    private ReadableColor finalColor;
    private ColorSequenceWrapper sequence;
    private int duration;
    private int tick;
    private TickableObject tickableObject;

    private StrobeEffect() {
        if (instance != null) {
            instance.remove();
            instance = this;
        }
    }

    public StrobeEffect(ReadableColor color, int duration) {
        this();
        this.color = color;
        this.finalColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), 0);
        this.duration = duration;
    }

    public StrobeEffect(ColorSequenceWrapper sequence) {
        this();
        this.sequence = sequence;
    }

    public boolean isActive() {
        if (this.sequence != null) {
            return !this.sequence.isFinished(this.tick);
        }
        return this.tick < this.duration;
    }

    protected void doTick() {
        ++this.tick;
        if (this.sequence == null) {
            ColorInterpolator.interpolate((ReadableColor)this.color, (ReadableColor)this.finalColor, (float)((float)this.tick / (float)this.duration), (Interpolator)LinearInterpolator.instance, (Color)this.cachedColor);
        } else {
            this.sequence.getColor(this.tick, this.cachedColor);
        }
    }

    protected void doRender() {
    }

    protected void doSpawn() {
        this.tickableObject = new TickableObject(){

            protected void render() {
                if (!StrobeEffect.this.isStarted()) {
                    return;
                }
                if ((StrobeEffect.this.tick & 4) == 0) {
                    this.glRender(new GLRenderable(){

                        public void render() {
                            GL11.glEnable((int)3042);
                            GL11.glDisable((int)3553);
                            GL11.glBlendFunc((int)770, (int)1);
                        }
                    });
                    this.glColor4ub(StrobeEffect.this.cachedColor.getRedByte(), StrobeEffect.this.cachedColor.getGreenByte(), StrobeEffect.this.cachedColor.getBlueByte(), StrobeEffect.this.cachedColor.getAlphaByte());
                    this.glBegin(7);
                    this.glVertex2f(0.0f, 0.0f);
                    this.glVertex2f(Game.getWidth(), 0.0f);
                    this.glVertex2f(Game.getWidth(), Game.getHeight());
                    this.glVertex2f(0.0f, Game.getHeight());
                    this.glEnd();
                }
            }
        };
        this.tickableObject.spawn(this.getScreen());
        this.tickableObject.setLayer(Integer.MAX_VALUE);
    }

    protected void doRemove() {
        if (this.tickableObject != null) {
            this.tickableObject.remove();
            this.tickableObject = null;
        }
        instance = null;
    }

    public boolean isBackgroundEffect() {
        return false;
    }
}

