/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet.effects;

import com.shavenpuppy.jglib.sprites.AnimatedAppearance;
import com.shavenpuppy.jglib.sprites.Sprite;
import java.io.Serializable;
import net.puppygames.applet.effects.SimpleBaseEffect;
import org.lwjgl.util.ReadableColor;
import org.lwjgl.util.ReadablePoint;

public class SpriteEffect
extends SimpleBaseEffect {
    private static final long serialVersionUID = 1L;
    private Sprite sprite;
    private int layer;
    private AnimatedAppearance appearance;

    public SpriteEffect(AnimatedAppearance appearance, int layer, ReadableColor startColor, ReadableColor endColor, int duration, int fadeDuration) {
        super(startColor, endColor, duration, fadeDuration);
        this.appearance = appearance;
        this.layer = layer;
    }

    protected void doSpawn() {
        this.sprite = this.getScreen().allocateSprite((Serializable)((Object)this.getScreen()));
        if (this.sprite == null) {
            this.remove();
        }
        this.sprite.setAppearance(this.appearance);
        this.sprite.setLayer(this.layer);
    }

    protected void doSetLocation() {
        if (this.sprite == null) {
            return;
        }
        ReadablePoint offset = this.getOffset();
        float x = this.getX();
        float y = this.getY();
        if (offset != null) {
            x += (float)offset.getX();
            y += (float)offset.getY();
        }
        this.sprite.setLocation(x, y, 0.0f);
    }

    protected void doEffectRender() {
        this.sprite.setVisible(this.isVisible());
        this.sprite.setColors((ReadableColor)this.getCachedColor());
    }

    protected void doSimpleTick() {
        if (this.sprite.getEvent() == 1) {
            this.finish();
        }
    }

    protected void doRemove() {
        if (this.sprite != null) {
            this.sprite.deallocate();
            this.sprite = null;
        }
    }
}

