/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet.effects;

import com.shavenpuppy.jglib.TextLayout;
import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.opengl.ColorUtil;
import com.shavenpuppy.jglib.opengl.GLTextArea;
import com.shavenpuppy.jglib.resources.Background;
import net.puppygames.applet.Game;
import net.puppygames.applet.Res;
import net.puppygames.applet.effects.Effect;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;
import org.lwjgl.util.ReadableColor;
import org.lwjgl.util.ReadableRectangle;
import org.lwjgl.util.Rectangle;

public class ProgressEffect
extends Effect {
    private static final int MAX = 30;
    private final GLTextArea textArea = new GLTextArea();
    private int width;
    private int height;
    private int progress;
    private int direction;
    private Background.Instance background;
    private ReadableColor border;
    private ReadableColor bar;
    private Color fadeBar;
    private boolean finished;

    public ProgressEffect(String message, ReadableColor border, ReadableColor bar) {
        this.textArea.setFont(Res.getSmallFont());
        this.textArea.setVerticalAlignment(GLTextArea.BOTTOM);
        this.textArea.setHorizontalAlignment(TextLayout.CENTERED);
        this.textArea.setWidth((int)((float)Game.getWidth() * 0.66f));
        this.background = Res.getProgressBackground().spawn();
        this.setMessage(message);
        this.background.setColor(border);
        this.border = border;
        this.bar = bar;
        this.fadeBar = new Color(bar);
        this.fadeBar.setAlpha(0);
    }

    protected void doTick() {
        this.progress += this.direction;
        if (this.progress == 0) {
            this.direction = 1;
        } else if (this.progress == 29) {
            this.direction = -1;
        }
    }

    protected void doRender() {
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
        int x = this.textArea.getX();
        int y = this.textArea.getY();
        GL11.glEnable((int)3553);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)(y - 12), (float)0.0f);
        this.background.render();
        GL11.glPopMatrix();
        ColorUtil.setGLColor((ReadableColor)ReadableColor.WHITE);
        this.textArea.render();
        int xpos = (int)LinearInterpolator.instance.interpolate((float)(x + 8), (float)(Game.getWidth() - x - 8), (float)this.progress / 30.0f);
        int len = (Game.getWidth() - 2 * x) / 30;
        GL11.glDisable((int)3553);
        GL11.glBegin((int)7);
        ColorUtil.setGLColor((ReadableColor)(this.direction == 1 ? this.fadeBar : this.bar));
        GL11.glVertex2i((int)xpos, (int)(y - 4));
        ColorUtil.setGLColor((ReadableColor)(this.direction == 1 ? this.bar : this.fadeBar));
        GL11.glVertex2i((int)(xpos + len), (int)(y - 4));
        GL11.glVertex2i((int)(xpos + len), (int)y);
        ColorUtil.setGLColor((ReadableColor)(this.direction == 1 ? this.fadeBar : this.bar));
        GL11.glVertex2i((int)xpos, (int)y);
        GL11.glEnd();
    }

    public boolean isActive() {
        return !this.finished;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    public void setMessage(String message) {
        this.textArea.setText(message);
        this.width = this.textArea.getWidth();
        this.height = this.textArea.getTextHeight() + 16;
        int x = (Game.getWidth() - this.width) / 2;
        int y = (Game.getHeight() - this.height) / 2;
        this.textArea.setLocation(x, y);
        this.background.setBounds((ReadableRectangle)new Rectangle(0, 0, this.width, this.height));
    }

    public void setBorder(Color border) {
        this.border = border;
    }
}

