/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet.effects;

import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.interpolators.SineInterpolator;
import com.shavenpuppy.jglib.opengl.GLBaseTexture;
import com.shavenpuppy.jglib.opengl.GLRenderable;
import net.puppygames.applet.TickableObject;
import net.puppygames.applet.effects.Effect;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.ReadablePoint;

public class BlastEffect
extends Effect {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_LAYER = 99;
    private int duration;
    private float finalRadius;
    private float width;
    private float radius;
    private int tick;
    private int layer = 99;
    private float x;
    private float y;
    private GLBaseTexture texture;
    private int fadeDuration;
    private boolean fading;
    private boolean fadeWhenExpanding;
    private TickableObject tickableObject;

    public BlastEffect(float x, float y, int duration, int fadeDuration, float radius, float width, GLBaseTexture texture) {
        this.x = x;
        this.y = y;
        this.duration = duration;
        this.fadeDuration = fadeDuration;
        this.finalRadius = radius;
        this.width = width;
        this.texture = texture;
    }

    protected void doTick() {
        ++this.tick;
        if (!this.fading) {
            this.radius = SineInterpolator.instance.interpolate(0.0f, this.finalRadius, (float)this.tick / (float)this.duration);
            if (this.tick >= this.duration && !this.fadeWhenExpanding) {
                this.tick = 0;
                this.fading = true;
            }
        }
    }

    protected void doSpawn() {
        this.tickableObject = new TickableObject(){

            protected void render() {
                float innerRadius;
                float alpha;
                this.glRender(new GLRenderable(){

                    public void render() {
                        GL11.glEnable((int)3553);
                        GL11.glEnable((int)3042);
                        GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
                        GL11.glBlendFunc((int)770, (int)1);
                        BlastEffect.this.texture.render();
                    }
                });
                float xx = BlastEffect.this.x;
                float yy = BlastEffect.this.y;
                ReadablePoint offset = BlastEffect.this.getOffset();
                if (offset != null) {
                    xx += (float)offset.getX();
                    yy += (float)offset.getY();
                }
                this.glBegin(5);
                if (BlastEffect.this.fading) {
                    alpha = LinearInterpolator.instance.interpolate(1.0f, 0.0f, (float)BlastEffect.this.tick / (float)BlastEffect.this.fadeDuration);
                    innerRadius = SineInterpolator.instance.interpolate(Math.max(0.0f, BlastEffect.this.finalRadius - BlastEffect.this.width), BlastEffect.this.finalRadius, (float)BlastEffect.this.tick / (float)BlastEffect.this.fadeDuration);
                } else {
                    alpha = BlastEffect.this.fadeWhenExpanding ? LinearInterpolator.instance.interpolate(1.0f, 0.0f, (float)BlastEffect.this.tick / (float)BlastEffect.this.fadeDuration) : 1.0f;
                    innerRadius = SineInterpolator.instance.interpolate(0.0f, Math.max(0.0f, BlastEffect.this.finalRadius - BlastEffect.this.width), (float)BlastEffect.this.tick / (float)BlastEffect.this.duration);
                }
                int i = 0;
                while (i <= 360) {
                    this.glColor4f(1.0f, 1.0f, 1.0f, 0.0f);
                    this.glTexCoord2f(i, 1.0f);
                    this.glVertex2f(xx + (float)Math.cos(Math.toRadians(i)) * innerRadius, yy + (float)Math.sin(Math.toRadians(i)) * innerRadius);
                    this.glColor4f(1.0f, 1.0f, 1.0f, alpha);
                    this.glTexCoord2f(i, 0.0f);
                    this.glVertex2f(xx + (float)Math.cos(Math.toRadians(i)) * BlastEffect.this.radius, yy + (float)Math.sin(Math.toRadians(i)) * BlastEffect.this.radius);
                    i += 8;
                }
                this.glEnd();
            }
        };
        this.tickableObject.setVisible(this.isVisible());
        this.tickableObject.setLayer(this.layer);
        this.tickableObject.spawn(this.getScreen());
    }

    public void setLayer(int layer) {
        this.layer = layer;
        if (this.tickableObject != null) {
            this.tickableObject.setLayer(layer);
        }
    }

    public int getLayer() {
        return this.layer;
    }

    protected void onSetVisible() {
        if (this.tickableObject != null) {
            this.tickableObject.setVisible(this.isVisible());
        }
    }

    protected void doRemove() {
        if (this.tickableObject != null) {
            this.tickableObject.remove();
            this.tickableObject = null;
        }
    }

    protected void doRender() {
    }

    public boolean isActive() {
        return this.fadeWhenExpanding ? this.tick < this.duration : !this.fading || this.tick < this.fadeDuration;
    }

    public float getRadius() {
        return this.radius;
    }

    public boolean isFading() {
        return this.fading;
    }

    public void setFadeWhenExpanding(boolean fadeWhenExpanding) {
        this.fadeWhenExpanding = fadeWhenExpanding;
    }
}

