/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet;

import com.shavenpuppy.jglib.interpolators.LinearInterpolator;
import com.shavenpuppy.jglib.sprites.SpriteAllocator;
import net.puppygames.applet.Screen;
import net.puppygames.applet.Transition;
import org.lwjgl.opengl.GL11;

public class ZoomTransition
extends Transition {
    private static final int FADE_TIME = 15;
    private static final float START_DEPTH = -200.0f;
    private static final float END_DEPTH = 400.0f;

    public ZoomTransition() {
    }

    public ZoomTransition(String name) {
        super(name);
    }

    public int getClosingDuration() {
        return 15;
    }

    public int getOpeningDuration() {
        return 15;
    }

    public void postRenderClosing(SpriteAllocator screen, int tick) {
        GL11.glPopMatrix();
    }

    public void postRenderOpening(SpriteAllocator screen, int tick) {
        GL11.glPopMatrix();
    }

    public void preRenderClosing(Screen screen, int tick) {
        float alpha = LinearInterpolator.instance.interpolate(1.0f, 0.0f, (float)tick / 15.0f);
        float depth = LinearInterpolator.instance.interpolate(0.0f, 400.0f, (float)tick / 15.0f);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)depth);
        screen.setAlpha(alpha);
    }

    public void preRenderOpening(Screen screen, int tick) {
        float alpha = LinearInterpolator.instance.interpolate(0.0f, 1.0f, (float)tick / 15.0f);
        float depth = LinearInterpolator.instance.interpolate(-200.0f, 0.0f, (float)tick / 15.0f);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)depth);
        screen.setAlpha(alpha);
    }
}

