/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet;

import com.shavenpuppy.jglib.Image;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.jpeg.JPEGDecoder;
import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.openal.ALStream;
import com.shavenpuppy.jglib.resources.Data;
import com.shavenpuppy.jglib.resources.DynamicResource;
import com.shavenpuppy.jglib.resources.Feature;
import com.shavenpuppy.jglib.resources.StringArray;
import com.shavenpuppy.jglib.resources.TextResource;
import com.shavenpuppy.jglib.sound.SoundEffect;
import com.shavenpuppy.jglib.sound.SoundPlayer;
import com.shavenpuppy.jglib.sprites.SoundCommand;
import com.shavenpuppy.jglib.util.CheckOnline;
import com.shavenpuppy.jglib.util.Util;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.rmi.Naming;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Random;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import net.puppygames.applet.Binding;
import net.puppygames.applet.Configuration;
import net.puppygames.applet.GameState;
import net.puppygames.applet.PlayerSlot;
import net.puppygames.applet.Res;
import net.puppygames.applet.Screen;
import net.puppygames.applet.Splash;
import net.puppygames.applet.Support;
import net.puppygames.applet.effects.EffectFeature;
import net.puppygames.applet.effects.SFX;
import net.puppygames.applet.screens.BindingsScreen;
import net.puppygames.applet.screens.CreditsScreen;
import net.puppygames.applet.screens.DialogScreen;
import net.puppygames.applet.screens.HiscoresScreen;
import net.puppygames.applet.screens.InstructionsScreen;
import net.puppygames.applet.screens.NagScreen;
import net.puppygames.applet.screens.RegisterScreen;
import net.puppygames.applet.screens.TitleScreen;
import net.puppygames.gamecommerce.shared.GameInfo;
import net.puppygames.gamecommerce.shared.GameInfoServerRemote;
import net.puppygames.gamecommerce.shared.RegistrationDetails;
import org.lwjgl.LWJGLException;
import org.lwjgl.Sys;
import org.lwjgl.input.Controllers;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Rectangle;
import org.lwjgl.util.Timer;

public abstract class Game
extends Feature {
    private static final long serialVersionUID = 1L;
    private static final String RESTORE_GAME_DIALOG_FEATURE = "restore_game.dialog";
    private static final String SAVE_GAME_EFFECT_FEATURE = "save_game.effect";
    private static final String DEFAULT_GAME_RESOURCE_NAME = "game.puppygames";
    private static final String DEFAULT_USER_PREFS_FILENAME = "prefs.xml";
    public static final boolean DEBUG = false;
    private static final boolean REGISTERED = false;
    private static final boolean FORCEUSELOG = false;
    private static final boolean TESTREGISTER = false;
    private static final boolean FORCEUSEOGGCACHE = false;
    private static final boolean[] KEYDOWN = new boolean[256];
    private static final boolean[] KEYWASDOWN = new boolean[256];
    protected static final String RESTORE_FILE = "restore.dat";
    private static boolean alwaysRun;
    private static boolean doBuy;
    private static boolean preventBuy;
    private static boolean pauseEnabled;
    private static boolean sfxEnabled;
    private static boolean musicEnabled;
    private static boolean paused;
    private static boolean finished;
    private static boolean initialised;
    private static Properties properties;
    private static RegistrationDetails registrationDetails;
    private static boolean registered;
    private static long installation;
    private static String scoreGroup;
    private static Preferences PREFS;
    private static Preferences GLOBALPREFS;
    private static Configuration configuration;
    private static int playedThisSession;
    private static boolean shownInstructions;
    private static Game game;
    private static GameInfo gameInfo;
    private static SoundPlayer soundPlayer;
    private static List<SoundPlayer> soundPlayers;
    private static SoundEffect music;
    private static String dirPrefix;
    private static String GAMEINFO_FILE;
    private static int playedTicks;
    private static int musicVolume;
    private static int sfxVolume;
    private static DisplayMode initialMode;
    private static Rectangle viewPort;
    private static GameState gameState;
    private static boolean allowSave;
    public static Screen topScreen;
    private static String title;
    private static String internalTitle;
    private static String version;
    private static String internalVersion;
    private static DialogScreen restoreGameDialog;
    private static PlayerSlot playerSlot;
    private static boolean customDisplayMode;
    private static int viewportXoffset;
    private static int viewportYoffset;
    private static int viewportWidth;
    private static int viewportHeight;
    private int width;
    private int height;
    private int frameRate;
    private int messageSequence;
    @Data
    private String supportEmail = "support@puppygames.net";
    @Data
    private String supportURL = "www.puppygames.net/support/support.php";
    @Data
    private String contactURL = "www.puppygames.net/contact.php";
    @Data
    private String website = "www.puppygames.net";
    @Data
    private String download = "www.puppygames.net";
    @Data
    private String buyURL = "";
    @Data
    private String moreGamesURL = "www.puppygames.net";
    private int defaultFullscreen = 0;
    private boolean dontUseRemoteHiscores;
    private boolean dontCheckMessages;
    private boolean useSlotManagement;
    private int soundVoices = 64;
    private boolean useWindowSizing;
    private int scale;
    private boolean preregistered;
    @Data
    private String preregisteredTo;
    @Data
    private String preregisteredUntil;
    @Data
    private String preregisteredLocale;
    @Data
    private String preregisteredLanguage;
    private transient float windowSize;
    private transient int panic;
    private transient boolean wasGrabbed;
    private transient boolean submitRemoteHiscores;
    private transient int logicalWidth;
    private transient int logicalHeight;
    private transient boolean catchUp;
    private transient float masterGain;
    private transient float targetMasterGain;
    public static PrefsSaverThread prefsSaver;

    static {
        pauseEnabled = true;
        sfxEnabled = true;
        musicEnabled = true;
        allowSave = true;
        Image.setDecompressor((Image.JPEGDecompressor)new Image.JPEGDecompressor(){

            public void decompress(ByteBuffer src, ByteBuffer dest) throws Exception {
                byte[] data = new byte[src.capacity()];
                src.get(data);
                ByteArrayInputStream bais = new ByteArrayInputStream(data);
                Image img = JPEGDecoder.loadFromByteStream((InputStream)bais);
                dest.put(img.getData());
                img.dispose();
                dest.flip();
            }
        });
    }

    public Game(String name) {
        super(name);
    }

    public static void setPauseEnabled(boolean pauseEnabled) {
        Game.pauseEnabled = pauseEnabled;
        if (paused && !pauseEnabled) {
            paused = false;
        }
    }

    public static Game getGame() {
        return game;
    }

    public static int getWidth() {
        return Game.game.logicalWidth;
    }

    public static void setSize(int width, int height) {
        int oldWidth = Game.game.width;
        int oldHeight = Game.game.height;
        Game.game.width = width;
        Game.game.height = height;
        try {
            Game.setFullscreen(false);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            Game.game.width = oldWidth;
            Game.game.height = oldHeight;
        }
    }

    public static int getHeight() {
        return Game.game.logicalHeight;
    }

    public static int getFrameRate() {
        return Game.game.frameRate;
    }

    public static String getTitle() {
        return title;
    }

    public static String getVersion() {
        return version;
    }

    public static String getInternalVersion() {
        return internalVersion;
    }

    public static String getWebsite() {
        return Game.game.website;
    }

    public static String getDownload() {
        return Game.game.download;
    }

    public static String getSupportURL() {
        return Game.game.supportURL;
    }

    public static String getSupportEmail() {
        return Game.game.supportEmail;
    }

    public static String getContactURL() {
        return Game.game.contactURL;
    }

    public static Configuration getConfiguration() {
        return configuration;
    }

    public static GameInfo getGameInfo() {
        return gameInfo;
    }

    public static long getInstallation() {
        return installation;
    }

    public static Preferences getGlobalPreferences() {
        return GLOBALPREFS;
    }

    public static Preferences getPreferences() {
        return PREFS;
    }

    public static RegistrationDetails getRegistrationDetails() {
        return registrationDetails;
    }

    public static boolean isFinished() {
        return finished;
    }

    public static boolean isPaused() {
        return paused;
    }

    public static boolean isRegistered() {
        return registered || Game.game.preregistered;
    }

    private static PrintStream redirectOutput(final PrintStream output, String fileName) throws FileNotFoundException {
        if (fileName == null || fileName.equals("")) {
            return output;
        }
        boolean append = true;
        File outFile = new File(String.valueOf(dirPrefix) + File.separator + fileName);
        if (outFile.exists() && outFile.length() > 65535L) {
            outFile.renameTo(new File(String.valueOf(dirPrefix) + File.separator + fileName + ".old"));
            append = false;
        }
        final FileOutputStream fos = new FileOutputStream(outFile, append);
        OutputStream os = new OutputStream(){
            boolean wroteDate;

            public void write(int b) throws IOException {
                if (!this.wroteDate) {
                    this.wroteDate = true;
                    this.write(new Date().toString());
                    this.write("\t");
                }
                output.write(b);
                fos.write(b);
                if (b == 10) {
                    this.flush();
                    output.flush();
                    this.wroteDate = false;
                }
            }

            private void write(String s) throws IOException {
                int len = s.length();
                int i = 0;
                while (i < len) {
                    this.write(s.charAt(i));
                    ++i;
                }
            }
        };
        return new PrintStream(os);
    }

    public static synchronized void init(Properties properties, InputStream resourcesStream) throws Exception {
        PlayerSlot slot;
        String slotName;
        block51: {
            boolean zapPrefs;
            block49: {
                String gameResource;
                if (initialised) {
                    return;
                }
                initialised = true;
                finished = false;
                Game.properties = properties;
                Resources.load((InputStream)resourcesStream);
                title = ((TextResource)Resources.get((String)"title")).getText().trim();
                version = ((TextResource)Resources.get((String)"version")).getText().trim();
                TextResource iv = (TextResource)Resources.peek((String)"internalVersion");
                internalVersion = iv != null ? iv.getText().trim() : version;
                Game.initFiles();
                try {
                    System.setOut(Game.redirectOutput(System.out, properties.getProperty("out", "out.log")));
                    System.setErr(Game.redirectOutput(System.err, properties.getProperty("err", "err.log")));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                System.out.println(new Date() + " Game: " + title + " " + version + " [" + internalVersion + "]");
                GLOBALPREFS = Preferences.userNodeForPackage(Game.class);
                installation = GLOBALPREFS.getLong("installation", 0L);
                if (installation == 0L) {
                    installation = (long)(Math.random() * 9.223372036854776E18);
                    GLOBALPREFS.putLong("installation", installation);
                }
                System.out.println("Serial " + installation);
                try {
                    gameResource = System.getProperty("net.puppygames.applet.Game.gameResource", properties.getProperty("gameresource", DEFAULT_GAME_RESOURCE_NAME));
                }
                catch (SecurityException e) {
                    e.printStackTrace(System.err);
                    gameResource = DEFAULT_GAME_RESOURCE_NAME;
                }
                System.out.println("Game resource: " + gameResource);
                game = (Game)Resources.peek((String)gameResource);
                FileInputStream fis = null;
                BufferedInputStream bis = null;
                File prefsFile = new File(Game.getUserPrefsFileName());
                zapPrefs = false;
                if (prefsFile.exists()) {
                    try {
                        try {
                            fis = new FileInputStream(prefsFile);
                            bis = new BufferedInputStream(fis);
                            Preferences.importPreferences(bis);
                            System.out.println("Loaded preferences file " + prefsFile);
                        }
                        catch (Exception e) {
                            e.printStackTrace(System.err);
                            zapPrefs = true;
                            if (fis != null) {
                                try {
                                    fis.close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block49;
                        }
                    }
                    catch (Throwable throwable) {
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException iOException) {}
                    }
                } else {
                    System.out.println("Preferences file " + prefsFile + " does not exist.");
                    zapPrefs = true;
                }
            }
            PREFS = Preferences.userNodeForPackage(Game.class).node(title);
            if (zapPrefs) {
                PREFS.removeNode();
                PREFS.flush();
                PREFS = null;
                PREFS = Preferences.userNodeForPackage(Game.class).node(title);
                Game.doFlushPrefs();
            }
            prefsSaver = new PrefsSaverThread();
            prefsSaver.start();
            byte[] cfg = PREFS.getByteArray("configuration", null);
            if (cfg == null) {
                Game.createConfiguration();
            } else {
                ByteArrayInputStream bais = new ByteArrayInputStream(cfg);
                ObjectInputStream ois = new ObjectInputStream(bais);
                try {
                    try {
                        configuration = (Configuration)ois.readObject();
                    }
                    catch (Exception e) {
                        Game.createConfiguration();
                        ois.close();
                        break block51;
                    }
                }
                catch (Throwable throwable) {
                    ois.close();
                    throw throwable;
                }
                ois.close();
            }
        }
        Game.checkRegistration();
        boolean wasBadExit = PREFS.getBoolean("badexit", false);
        gameInfo = new GameInfo(Game.getTitle(), Game.getVersion(), Game.getInstallation(), wasBadExit, Display.getAdapter(), Display.getVersion(), configuration.encode());
        System.out.println("Starting " + Game.getTitle() + " " + Game.getVersion());
        if (wasBadExit) {
            Game.alert(String.valueOf(Game.getTitle()) + " did not shut down correctly last time you tried to play.\n\nIf you are experiencing problems or bugs please " + ("".equals(Game.getSupportEmail()) ? "visit " + Game.getContactURL() : "contact " + Game.getSupportEmail()) + "\nand tell us!");
            Support.doSupport("crash");
        }
        PREFS.putBoolean("badexit", true);
        Game.flushPrefs();
        DynamicResource.createAll();
        Game.initSound();
        try {
            Controllers.create();
        }
        catch (Exception e) {
            System.err.println("No gamepads or joysticks enabled due to " + e);
        }
        try {
            Game.initDisplay();
        }
        catch (Exception e) {
            e.printStackTrace();
            gameInfo.setException((Throwable)e);
            Game.alert("You need to get new graphics card drivers in order to play " + Game.getTitle() + ".\nPlease contact your system vendor for assistance.");
            Support.doSupport("opengl");
            Game.exit();
        }
        Display.setVSyncEnabled((boolean)false);
        Splash splash = Splash.getInstance();
        if (splash != null) {
            try {
                splash.create();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                splash = null;
            }
        }
        SFX.createSFX();
        Res.createResources();
        Feature.autoCreate();
        Resources.setRunMode((boolean)true);
        String glvendor = GL11.glGetString((int)7936);
        String glrenderer = GL11.glGetString((int)7937);
        String glversion = GL11.glGetString((int)7938);
        String gldriver = null;
        int i = glversion.indexOf(32);
        if (i != -1) {
            gldriver = glversion.substring(i + 1);
            glversion = glversion.substring(0, i);
        }
        gameInfo.update(glvendor, glrenderer, glversion, gldriver, registrationDetails);
        game.create();
        Game.loadBindings();
        if (splash != null) {
            splash.destroy();
            splash = null;
        }
        Game.initVsync();
        if (Game.isSlotManaged() && (slotName = PREFS.get("slot_" + Game.getInternalVersion(), null)) != null && (slot = new PlayerSlot(slotName)).exists()) {
            Game.setPlayerSlot(slot);
        }
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glFrustum((double)((double)(-Game.getWidth()) / 64.0), (double)((double)Game.getWidth() / 64.0), (double)((double)(-Game.getHeight()) / 64.0), (double)((double)Game.getHeight() / 64.0), (double)8.0, (double)65536.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        if (!Game.isRegistered()) {
            Game.showRegisterScreen();
        } else if (Game.game.preregistered) {
            Game.preRegisteredStartup();
        } else {
            Game.showTitleScreen();
        }
        Game.game.submitRemoteHiscores = PREFS.getBoolean("submitremotehiscores", !Game.game.dontUseRemoteHiscores);
        resourcesStream.close();
        resourcesStream = null;
        try {
            try {
                game.run();
            }
            catch (Throwable t) {
                System.err.println("Set exception to " + t + " : " + t.getMessage() + " Stack trace follows:");
                t.printStackTrace(System.err);
                gameInfo.setException(t);
                Game.exit();
            }
        }
        finally {
            Game.exit();
        }
    }

    private static void preRegisteredStartup() {
        game.onPreRegisteredStartup();
    }

    protected void onPreRegisteredStartup() {
        Game.showTitleScreen();
    }

    private static String getSettingsDir() {
        return properties.getProperty("home", System.getProperty("os.name").startsWith("Mac OS") ? String.valueOf(System.getProperty("user.home", "")) + "/Library/Application Support" : System.getProperty("user.home", ""));
    }

    public static String getDirectoryPrefix() {
        return dirPrefix;
    }

    public static String getPlayerDirectoryPrefix() {
        String ret = String.valueOf(dirPrefix) + "slots_" + Game.getInternalVersion() + File.separator + playerSlot.getName();
        File f = new File(ret);
        if (!f.exists()) {
            f.mkdirs();
        }
        return String.valueOf(ret) + File.separator;
    }

    public static String getSlotDirectoryPrefix() {
        String ret = String.valueOf(dirPrefix) + "slots_" + Game.getInternalVersion();
        File f = new File(ret);
        if (!f.exists()) {
            f.mkdirs();
        }
        return String.valueOf(ret) + File.separator;
    }

    private static void initFiles() {
        boolean dirPrefixExists;
        String settingsDirName = String.valueOf(Game.getSettingsDir()) + File.separator + "." + Game.getTitle().replace(' ', '_').toLowerCase() + '_' + Game.getInternalVersion();
        System.out.println("settingsDirName=" + settingsDirName);
        File settingsDir = new File(settingsDirName);
        if (!settingsDir.exists()) {
            System.out.println("Creating settingsDir: " + settingsDirName);
            settingsDir.mkdirs();
            dirPrefixExists = settingsDir.exists();
        } else {
            dirPrefixExists = true;
        }
        dirPrefix = dirPrefixExists ? String.valueOf(settingsDirName) + File.separator : String.valueOf(Game.getSettingsDir()) + File.separator;
        System.out.println("dirPrefix=" + dirPrefix);
        GAMEINFO_FILE = String.valueOf(dirPrefix) + "log.dat";
    }

    private static void writeTix() {
        int tix = PREFS.getInt("tix", 0);
        int newTix = playedTicks / Game.getFrameRate();
        playedTicks = 0;
        gameInfo.addTime(newTix);
        PREFS.putInt("tix", tix += newTix);
    }

    public static void onTicked() {
        ++playedTicks;
    }

    private static void writeLog() {
        block71: {
            List<Object> logList;
            File log;
            block70: {
                if (gameInfo == null) {
                    System.out.println("No game info log");
                }
                if (GAMEINFO_FILE == null) {
                    System.out.println("Couldn't write log - no filename");
                    return;
                }
                log = new File(String.valueOf(Game.getSettingsDir()) + File.separator + GAMEINFO_FILE);
                logList = null;
                if (log.exists()) {
                    ObjectInputStream ois = null;
                    BufferedInputStream bis = null;
                    FileInputStream fis = null;
                    try {
                        try {
                            fis = new FileInputStream(log);
                            bis = new BufferedInputStream(fis);
                            ois = new ObjectInputStream(bis);
                            logList = (List)ois.readObject();
                        }
                        catch (Exception e) {
                            e.printStackTrace(System.err);
                            logList = new ArrayList(1);
                            if (ois != null) {
                                try {
                                    ois.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (bis != null) {
                                try {
                                    bis.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (fis != null) {
                                try {
                                    fis.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            ois = null;
                            bis = null;
                            fis = null;
                            break block70;
                        }
                    }
                    catch (Throwable throwable) {
                        if (ois != null) {
                            try {
                                ois.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (bis != null) {
                            try {
                                bis.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        ois = null;
                        bis = null;
                        fis = null;
                        throw throwable;
                    }
                    if (ois != null) {
                        try {
                            ois.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (bis != null) {
                        try {
                            bis.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ois = null;
                    bis = null;
                    fis = null;
                } else {
                    if (Game.isRegistered() && !Support.isSupportQueued()) {
                        return;
                    }
                    logList = new ArrayList<GameInfo>(1);
                }
            }
            if (gameInfo != null) {
                Game.writeTix();
                logList.add(gameInfo);
            }
            boolean isOnline = Game.isRemoteCallAllowed();
            boolean submitted = false;
            if (CheckOnline.isOnline() && (isOnline || Support.isSupportQueued() || gameInfo.isCrashRecovery() || gameInfo.getException() != null)) {
                try {
                    GameInfoServerRemote server = (GameInfoServerRemote)Naming.lookup("//puppygames.net/puppygames_gameinfo_server");
                    server.submit(logList);
                    Game.onRemoteCallSuccess();
                    submitted = true;
                    log.delete();
                }
                catch (Throwable e) {
                    System.err.println(" Failed to write log: " + e);
                    e.printStackTrace(System.err);
                }
            }
            if (!submitted) {
                FileOutputStream fos = null;
                FilterOutputStream bos = null;
                ObjectOutputStream oos = null;
                try {
                    try {
                        fos = new FileOutputStream(log);
                        bos = new BufferedOutputStream(fos);
                        oos = new ObjectOutputStream(bos);
                        oos.writeObject(logList);
                        oos.flush();
                        ((BufferedOutputStream)bos).flush();
                        fos.flush();
                    }
                    catch (IOException iOException) {
                        if (oos != null) {
                            try {
                                oos.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (bos != null) {
                            try {
                                bos.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (fos == null) break block71;
                        try {
                            fos.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                finally {
                    if (oos != null) {
                        try {
                            oos.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (bos != null) {
                        try {
                            bos.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
    }

    public static void clearBuy() {
        doBuy = false;
    }

    public static void showMoreGames() {
        preventBuy = true;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                try {
                    String page;
                    PREFS.putBoolean("showregister", true);
                    if (Resources.exists((String)"moregames_url")) {
                        TextResource tr = (TextResource)Resources.get((String)"moregames_url");
                        page = tr.getText();
                    } else {
                        page = game.moreGamesURL != null && !"".equals(game.moreGamesURL) ? game.moreGamesURL : (!System.getProperty("moregames_url", "!").equals("!") ? System.getProperty("moregames_url") : "http://" + Game.getWebsite());
                    }
                    if (!Sys.openURL((String)page)) {
                        throw new Exception("Failed to open URL " + page);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    Game.alert("Please open your web browser on the page http://" + Game.getWebsite());
                }
            }
        });
        Game.exit();
    }

    public static void buy(boolean doExit) {
        if (!doBuy) {
            doBuy = true;
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    if (Game.isRegistered()) {
                        return;
                    }
                    PREFS.putBoolean("showregister", true);
                    try {
                        String page;
                        if (Resources.exists((String)"buy_url")) {
                            TextResource tr = (TextResource)Resources.get((String)"buy_url");
                            page = tr.getText();
                        } else {
                            page = game.buyURL != null && !"".equals(game.buyURL) ? game.buyURL : (!System.getProperty("buy_url", "!").equals("!") ? System.getProperty("buy_url") : "http://" + Game.getWebsite() + "/purchase/buy.php?game=" + URLEncoder.encode(Game.getTitle(), "utf-8") + "&configuration=" + URLEncoder.encode(configuration.encode(), "utf-8") + "@installation@");
                        }
                        String replacement = "&installation=" + URLEncoder.encode(String.valueOf(installation), "utf-8");
                        int idx = page.indexOf("@installation@");
                        if (idx != -1) {
                            StringBuilder sb = new StringBuilder(page);
                            sb.replace(idx, idx + 14, replacement);
                            page = sb.toString();
                        }
                        if (!Sys.openURL((String)page)) {
                            throw new Exception("Failed to open URL " + page);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                        Game.alert("Please open your web browser on the page http://" + Game.getWebsite());
                    }
                }
            });
        }
        if (doExit) {
            Game.exit();
        }
    }

    public static void requestExit() {
        game.doRequestExit();
    }

    protected void doRequestExit() {
        Game.exit();
    }

    public static synchronized void exit() {
        if (!initialised) {
            return;
        }
        if (game != null) {
            game.onExit();
        }
        initialised = false;
        finished = true;
        if (soundPlayer != null && soundPlayer.isCreated()) {
            soundPlayer.destroy();
        }
        if (game != null) {
            game.cleanup();
        }
        Game.writeLog();
        if (PREFS != null) {
            PREFS.putBoolean("badexit", false);
        }
        if (prefsSaver != null) {
            prefsSaver.finish();
            prefsSaver = null;
        }
        if (game != null && !preventBuy) {
            Game.buy(false);
        }
        System.exit(0);
    }

    protected void onExit() {
    }

    public static SoundEffect allocateSound(ALBuffer buffer) {
        return Game.allocateSound(buffer, 1.0f, 1.0f);
    }

    public static SoundEffect allocateSound(ALBuffer buffer, float gain, float pitch) {
        return Game.allocateSound(buffer, gain, pitch, Game.class);
    }

    public static SoundEffect allocateSound(ALBuffer buffer, float gain, float pitch, Object owner) {
        if (!AL.isCreated() || !Game.isSFXEnabled() || buffer == null || buffer.getWave() == null || soundPlayer == null) {
            return null;
        }
        SoundEffect effect = soundPlayer.allocate(buffer, (int)((float)buffer.getPriority() * gain), owner);
        if (effect != null && effect.getBuffer() != null) {
            effect.setAttenuated(false, owner);
            effect.setGain(effect.getBuffer().getGain() * (float)sfxVolume * gain / 100.0f, owner);
            effect.setPitch(effect.getBuffer().getPitch() * pitch, owner);
            if (buffer.getWave().getType() == 1) {
                effect.setPosition(0.0f, 0.0f, 0.0f, owner);
            }
        }
        return effect;
    }

    public static SoundEffect allocateSound(ALStream buffer) {
        if (!AL.isCreated() || !Game.isSFXEnabled() || buffer == null || soundPlayer == null) {
            return null;
        }
        SoundEffect effect = soundPlayer.allocate(buffer, Game.class);
        if (effect != null) {
            effect.setAttenuated(false, Game.class);
            effect.setGain(effect.getStream().getSourceStream().getGain() * (float)sfxVolume / 100.0f, Game.class);
            if (effect.getStream().getType() == 1) {
                effect.setPosition(0.0f, 0.0f, 0.0f, Game.class);
            }
        }
        return effect;
    }

    public static boolean isSFXEnabled() {
        return sfxEnabled;
    }

    public static boolean isMusicEnabled() {
        return musicEnabled;
    }

    public static void playMusic(ALStream buf, int fade, float gain) {
        boolean xfade;
        if (music == null && buf == null || music != null && (music.getStream() == null || buf == music.getStream().getSourceStream())) {
            if (music != null) {
                music.setFade(fade + 1, gain * music.getStream().getSourceStream().getGain() * (float)musicVolume / 100.0f, false, Game.class);
            }
            return;
        }
        boolean bl = xfade = music != null;
        if (xfade) {
            music.setFade(fade + 1, 0.0f, true, Game.class);
        }
        if ((music = buf == null || !Game.isMusicEnabled() ? null : Game.allocateSound(buf)) != null) {
            if (xfade) {
                music.setGain(0.0f, Game.class);
                music.setFade(fade + 1, buf == null ? 0.0f : gain * buf.getGain() * (float)musicVolume / 100.0f, false, Game.class);
            } else {
                music.setGain(buf == null ? 0.0f : gain * buf.getGain() * (float)musicVolume / 100.0f, Game.class);
            }
        }
    }

    public static void playMusic(ALStream buf, int fade) {
        Game.playMusic(buf, fade, 1.0f);
    }

    public static void playMusic(ALBuffer buf, int fade, float gain) {
        boolean xfade;
        if (music == null && buf == null || music != null && buf == music.getBuffer()) {
            return;
        }
        boolean bl = xfade = music != null;
        if (xfade) {
            music.setFade(fade, 0.0f, true, Game.class);
        }
        if ((music = buf == null || !Game.isMusicEnabled() ? null : Game.allocateSound(buf)) != null) {
            if (xfade) {
                music.setGain(0.0f, Game.class);
                music.setFade(fade, buf == null ? 0.0f : gain * buf.getGain() * (float)musicVolume / 100.0f, false, Game.class);
            } else {
                music.setGain(buf == null ? 0.0f : gain * buf.getGain() * (float)musicVolume / 100.0f, Game.class);
            }
        }
    }

    public static void playMusic(ALBuffer buf, int fade) {
        Game.playMusic(buf, fade, 1.0f);
    }

    public static SoundEffect getMusic() {
        return music;
    }

    private static void initSound() {
        block2: {
            try {
                System.out.println("Initing sound");
                AL.create();
                soundPlayer = new SoundPlayer(Game.game.soundVoices);
                soundPlayer.create();
                SoundCommand.setDefaultSoundPlayer((SoundPlayer)soundPlayer);
                musicVolume = PREFS.getInt("musicvolume", 70);
                sfxVolume = PREFS.getInt("sfxvolume", 70);
                music = null;
            }
            catch (Exception e) {
                sfxEnabled = false;
                musicEnabled = false;
                e.printStackTrace();
                Game.alert("You need a sound card to to hear the sound effects and music in " + Game.getTitle() + ".\n\nYou may have a suitable card but not have appropriate drivers.\n\nPlease contact " + Game.getSupportEmail() + " for assistance or visit our website if you need help finding drivers for your sound card.");
                Support.doSupport("openal");
                if (!AL.isCreated()) break block2;
                AL.destroy();
            }
        }
    }

    private static void initDisplay() throws Exception {
        Display.setTitle((String)Game.getTitle());
        if (Display.getParent() != null) {
            initialMode = new DisplayMode(Display.getParent().getWidth(), Display.getParent().getHeight());
            customDisplayMode = false;
        } else {
            if (properties.containsKey("width") && properties.containsKey("height")) {
                initialMode = new DisplayMode(Integer.parseInt(properties.getProperty("width", "800")), Integer.parseInt(properties.getProperty("height", "600")));
                customDisplayMode = true;
            } else {
                initialMode = Display.getDesktopDisplayMode();
                customDisplayMode = false;
            }
            if (properties.containsKey("vx")) {
                viewportXoffset = Integer.parseInt(properties.getProperty("vx", "0"));
            }
            if (properties.containsKey("vy")) {
                viewportYoffset = Integer.parseInt(properties.getProperty("vy", "0"));
            }
            if (properties.containsKey("vw")) {
                viewportWidth = Integer.parseInt(properties.getProperty("vw", "0"));
            }
            if (properties.containsKey("vh")) {
                viewportHeight = Integer.parseInt(properties.getProperty("vh", "0"));
            }
        }
        if ("!".equals(PREFS.get("fullscreen2", "!"))) {
            PREFS.putInt("fullscreen2", Game.game.defaultFullscreen);
        }
        if (Boolean.getBoolean("net.puppygames.applet.Game.windowed")) {
            Game.setFullscreen(false);
        } else {
            int fs = PREFS.getInt("fullscreen2", 0);
            switch (fs) {
                case 0: {
                    Game.setFullscreen(configuration.isFullscreen());
                    break;
                }
                case 1: {
                    Game.setFullscreen(false);
                    break;
                }
                case 2: {
                    Game.setFullscreen(true);
                }
            }
        }
    }

    public static void setFullscreen(boolean fullscreen) throws Exception {
        try {
            if (fullscreen) {
                try {
                    Game.initFullscreen();
                }
                catch (LWJGLException e) {
                    fullscreen = false;
                    Game.initWindow();
                }
            } else {
                Game.initWindow();
            }
            PREFS.putInt("fullscreen2", fullscreen ? 2 : 1);
        }
        catch (Exception e) {
            System.err.println("Failed to set fullscreen=" + fullscreen + " due to " + e);
            throw e;
        }
    }

    private static void initVsync() {
        int freq = Display.getDisplayMode().getFrequency();
        if (freq != Game.getFrameRate()) {
            Display.setVSyncEnabled((boolean)false);
        } else {
            Display.setVSyncEnabled((boolean)true);
        }
    }

    private static int getRecommendedBPP() {
        return PREFS.getInt("recommendedbpp", initialMode.getBitsPerPixel());
    }

    private static void initFullscreen() throws Exception {
        int displayHeight;
        System.out.println("Initialising full screen display");
        Display.setDisplayModeAndFullscreen((DisplayMode)Display.getDesktopDisplayMode());
        if (Display.isCreated()) {
            Display.update();
        }
        System.out.println("Set fullscreen displaymode to " + Display.getDisplayMode());
        Game.initVsync();
        if (!Display.isCreated()) {
            Display.create();
        }
        viewPort = new Rectangle(0, 0, Display.getDisplayMode().getWidth(), Display.getDisplayMode().getHeight());
        Game.resetViewport();
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glClear((int)16384);
        Display.update();
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        int displayWidth = viewportWidth == 0 ? Display.getDisplayMode().getWidth() : viewportWidth;
        int n = displayHeight = viewportHeight == 0 ? Display.getDisplayMode().getHeight() : viewportHeight;
        if (Game.game.useWindowSizing) {
            int ratio = displayWidth < displayHeight ? displayWidth / Game.game.scale : displayHeight / Game.game.scale;
            Game.game.logicalWidth = displayWidth / ratio;
            Game.game.logicalHeight = displayHeight / ratio;
            viewPort = new Rectangle(viewportXoffset, viewportYoffset, displayWidth, displayHeight);
        } else {
            int gw;
            int gh;
            Game.game.logicalWidth = Game.game.width;
            Game.game.logicalHeight = Game.game.height;
            if ((float)displayWidth / (float)displayHeight > (float)Game.getWidth() / (float)Game.getHeight()) {
                gh = displayHeight;
                gw = (int)((float)Game.game.width * (float)displayHeight / (float)Game.game.height);
            } else {
                gw = displayWidth;
                gh = (int)((float)Game.game.height * (float)displayWidth / (float)Game.game.width);
            }
            System.out.println("Game scaled to " + gw + " x " + gh);
            int x = (displayWidth - gw) / 2 + viewportXoffset;
            int y = (displayHeight - gh) / 2 + viewportYoffset;
            viewPort = new Rectangle(x, y, gw, gh);
        }
        GL11.glFrustum((double)((double)(-Game.game.logicalWidth) / 64.0), (double)((double)Game.game.logicalWidth / 64.0), (double)((double)(-Game.game.logicalHeight) / 64.0), (double)((double)Game.game.logicalHeight / 64.0), (double)8.0, (double)65536.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        Game.resetViewport();
        Display.update();
        Screen.onGameResized();
    }

    private static void initWindow() throws Exception {
        System.out.println("Initialising window");
        Display.setFullscreen((boolean)false);
        Display.setVSyncEnabled((boolean)false);
        if (Game.game.useWindowSizing) {
            if (Game.game.windowSize == 0.0f) {
                Game.setWindowSize(2.0f);
                return;
            }
            Display.setDisplayMode((DisplayMode)new DisplayMode(Game.game.width, Game.game.height));
        } else if ((double)initialMode.getWidth() > (double)Game.getWidth() * 2.25 && (double)initialMode.getHeight() > (double)Game.getHeight() * 2.25) {
            Display.setDisplayMode((DisplayMode)new DisplayMode(Game.game.width * 2, Game.game.height * 2));
        } else {
            Display.setDisplayMode((DisplayMode)new DisplayMode(Game.game.width, Game.game.height));
        }
        if (!Display.isCreated()) {
            Display.create();
        }
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        if (Game.game.useWindowSizing) {
            if (Game.game.width < Game.game.height) {
                double ratio = (double)Game.game.width / (double)Game.game.scale;
                Game.game.logicalWidth = Game.game.scale;
                Game.game.logicalHeight = (int)((double)Game.game.height / ratio);
            } else {
                double ratio = (double)Game.game.height / (double)Game.game.scale;
                Game.game.logicalHeight = Game.game.scale;
                Game.game.logicalWidth = (int)((double)Game.game.width / ratio);
            }
        } else {
            Game.game.logicalWidth = Game.game.width;
            Game.game.logicalHeight = Game.game.height;
        }
        GL11.glFrustum((double)((double)(-Game.game.logicalWidth) / 64.0), (double)((double)Game.game.logicalWidth / 64.0), (double)((double)(-Game.game.logicalHeight) / 64.0), (double)((double)Game.game.logicalHeight / 64.0), (double)8.0, (double)65536.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        viewPort = new Rectangle(0, 0, Display.getDisplayMode().getWidth(), Display.getDisplayMode().getHeight());
        Game.resetViewport();
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glClear((int)16384);
        Screen.onGameResized();
        System.out.println("Window sized to " + Display.getDisplayMode());
    }

    public static void resetViewport() {
        System.out.println("Set viewport to " + viewPort);
        GL11.glViewport((int)viewPort.getX(), (int)viewPort.getY(), (int)viewPort.getWidth(), (int)viewPort.getHeight());
    }

    protected void cleanup() {
    }

    private static long generatePregregistrationKey() {
        return Game.getInstallation() ^ (long)System.getProperty("user.country").hashCode() ^ (long)System.getProperty("user.language").hashCode() << 16 ^ (long)System.getProperty("user.home").hashCode() << 32;
    }

    private static void checkRegistration() {
        if (Game.game.preregistered) {
            return;
        }
        if (Game.game.preregisteredUntil != null) {
            if (PREFS.getLong("preregistered-installation", 0L) == Game.generatePregregistrationKey()) {
                boolean ok = true;
                if (Game.game.preregisteredLocale != null) {
                    String country = Locale.getDefault().getCountry();
                    System.out.println("Country check: " + country + " vs " + Game.game.preregisteredLocale);
                    if (!Game.game.preregisteredLocale.equals(country)) {
                        ok = false;
                    }
                }
                if (Game.game.preregisteredLanguage != null) {
                    String language = Locale.getDefault().getLanguage();
                    System.out.println("Language check: " + language + " vs " + Game.game.preregisteredLanguage);
                    if (!Game.game.preregisteredLanguage.equals(language)) {
                        ok = false;
                    }
                }
                if (ok) {
                    registered = true;
                    return;
                }
            } else {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    Date until = df.parse(Game.game.preregisteredUntil);
                    if (new Date().before(until)) {
                        String language;
                        String country;
                        boolean ok = true;
                        if (Game.game.preregisteredLocale != null && !Game.game.preregisteredLocale.equals(country = Locale.getDefault().getCountry())) {
                            ok = false;
                        }
                        if (Game.game.preregisteredLanguage != null && !Game.game.preregisteredLanguage.equals(language = Locale.getDefault().getLanguage())) {
                            ok = false;
                        }
                        if (ok) {
                            PREFS.putLong("preregistered-installation", Game.generatePregregistrationKey());
                            registered = true;
                            return;
                        }
                    }
                }
                catch (ParseException e) {
                    e.printStackTrace(System.err);
                }
            }
        }
        try {
            RegistrationDetails checkedDetails = RegistrationDetails.checkRegistration((String)Game.getTitle());
            Game.setRegistrationDetails(checkedDetails);
        }
        catch (Exception e) {
            Game.setRegistrationDetails(null);
        }
    }

    public static void setRegistrationDetails(RegistrationDetails registrationDetails) {
        if (Game.registrationDetails == registrationDetails) {
            return;
        }
        Game.registrationDetails = registrationDetails;
        if (registrationDetails != null) {
            registered = true;
            System.out.println("Game is registered: " + registrationDetails);
            registrationDetails.toPreferences();
        } else {
            System.out.println("Game is unregistered.");
            registered = false;
            RegistrationDetails.clearRegistration((String)Game.getTitle());
        }
    }

    private static void createConfiguration() throws Exception {
        configuration = new Configuration();
        if (Resources.exists((String)"configurations")) {
            StringArray configurations = (StringArray)Resources.peek((String)"configurations");
            String config = configurations.getString(Util.random((int)0, (int)(configurations.getNumStrings() - 1)));
            configuration.decode(config);
        } else {
            configuration.init();
        }
        Game.writeConfiguration();
    }

    private static void writeConfiguration() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(configuration);
        oos.flush();
        byte[] cfg = baos.toByteArray();
        PREFS.putByteArray("configuration", cfg);
        oos.close();
    }

    public static void setConfiguration(Configuration newConfiguration) throws Exception {
        configuration = newConfiguration;
        Game.writeConfiguration();
    }

    private void run() {
        int ticksToDo = 1;
        long then = Sys.getTime() & Long.MAX_VALUE;
        long framesTicked = 0L;
        long timerResolution = Sys.getTimerResolution();
        while (!finished) {
            if (Display.isCloseRequested()) {
                Game.exit();
            } else if (Display.isActive() || alwaysRun) {
                long now = Sys.getTime() & Long.MAX_VALUE;
                long currentTimerResolution = Sys.getTimerResolution();
                if (currentTimerResolution != timerResolution) {
                    timerResolution = currentTimerResolution;
                    then = now;
                }
                if (now > then) {
                    long ticksElapsed = now - then;
                    double shouldHaveTickedThisMany = (double)((long)Game.getFrameRate() * ticksElapsed) / (double)timerResolution;
                    ticksToDo = (int)Math.max(0.0, shouldHaveTickedThisMany - (double)framesTicked);
                    if (ticksToDo > 5) {
                        ticksToDo = 1;
                        then = now;
                        framesTicked = 0L;
                    }
                } else if (now < then) {
                    ticksToDo = 0;
                    then = now;
                    framesTicked = 0L;
                } else {
                    ticksToDo = 0;
                }
                if (ticksToDo > 0) {
                    int i = 0;
                    while (i < ticksToDo) {
                        if (i > 0) {
                            Display.processMessages();
                            this.catchUp = true;
                        } else {
                            this.catchUp = false;
                        }
                        long tickThen = Sys.getTime() & Long.MAX_VALUE;
                        this.tick();
                        long tickNow = Sys.getTime() & Long.MAX_VALUE;
                        long tickElapsed = tickNow - tickThen;
                        if (tickElapsed < 0L || (double)tickElapsed > (double)timerResolution / (double)Game.getFrameRate()) {
                            ticksToDo = 0;
                            then = tickThen;
                            framesTicked = 1L;
                            this.catchUp = false;
                        }
                        ++i;
                    }
                    framesTicked += (long)ticksToDo;
                    this.render();
                    Display.update();
                }
                Thread.yield();
                this.targetMasterGain = 1.0f;
            } else {
                this.targetMasterGain = 0.0f;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (Display.isVisible() || Display.isDirty()) {
                    this.render();
                }
                Display.update();
                if (Mouse.isGrabbed()) {
                    Mouse.setGrabbed((boolean)false);
                }
            }
            this.masterGain = Math.abs(this.targetMasterGain - this.masterGain) < 0.1f ? this.targetMasterGain : (this.targetMasterGain > this.masterGain ? (this.masterGain += 0.1f) : (this.masterGain -= 0.1f));
            if (!Game.isSFXEnabled()) continue;
            AL10.alListenerf((int)4106, (float)this.masterGain);
        }
    }

    public static boolean isCatchUp() {
        return Game.game.catchUp;
    }

    public static boolean isDemoExpired() {
        return game.doIsDemoExpired();
    }

    protected boolean doIsDemoExpired() {
        if (Game.isRegistered()) {
            return false;
        }
        int played = PREFS.getInt("played" + Game.getVersion(), 0);
        played ^= 0xAF6AD755;
        played = played >> 16 & 0xFFFF | played << 16;
        if ((played ^= 0xCCCCCABE) == 463037908) {
            played = 0;
        }
        int tix = PREFS.getInt("tix", 0);
        return played < 0 || (played > configuration.getMaxGames() && configuration.getMaxGames() > 0 || configuration.getMaxGames() == 0) && (tix > configuration.getMaxTime() && configuration.getMaxTime() > 0 || configuration.getMaxTime() == 0);
    }

    public static boolean maybeShowHelp() {
        return game.doMaybeShowHelp();
    }

    protected boolean doMaybeShowHelp() {
        Game.showHelp();
        return true;
    }

    public static void beginNewGame() {
        System.out.println("Begin new game");
        if (!Game.isRegistered()) {
            if (!shownInstructions && Game.maybeShowHelp()) {
                return;
            }
            int played = PREFS.getInt("played" + Game.getVersion(), 0);
            played ^= 0xAF6AD755;
            played = played >> 16 & 0xFFFF | played << 16;
            if ((played ^= 0xCCCCCABE) == 463037908) {
                played = 0;
            }
            int tix = PREFS.getInt("tix", 0);
            System.out.println("You have played " + Game.getTitle() + " " + played + " times for " + tix / 60 + " minutes");
            System.out.println("Max games " + configuration.getMaxGames() + " / max time " + configuration.getMaxTime() / 60 + " / max level " + configuration.getMaxLevel());
            if (Game.isDemoExpired() && (configuration.isCrippled() || playedThisSession > 0)) {
                NagScreen.show("Your demo has expired!", true);
                return;
            }
            ++played;
            played ^= 0xCCCCCABE;
            played = played >> 16 & 0xFFFF | played << 16;
            PREFS.putInt("played" + Game.getVersion(), played ^= 0xAF6AD755);
            gameInfo.onNewGame();
            ++playedThisSession;
        }
        SFX.newGame();
        game.onBeginNewGame();
    }

    protected void onBeginNewGame() {
        if (Game.isRestoreAvailable()) {
            Game.restoreGame();
        } else {
            Game.cleanGame();
        }
    }

    public static void gameOver() {
        SFX.gameOver();
        game.doGameOver();
    }

    protected abstract void doGameOver();

    public static void endGame() {
        Game.writeTix();
        game.doEndGame();
    }

    protected void doEndGame() {
        Game.showTitleScreen();
    }

    public static void showOptions() {
        game.doShowOptions();
    }

    public static void showCredits() {
        game.doShowCredits();
    }

    protected void doShowCredits() {
        CreditsScreen.show();
    }

    public static void showHelp() {
        shownInstructions = true;
        game.doShowHelp();
    }

    protected void doShowHelp() {
        InstructionsScreen.show();
    }

    public static void showTitleScreen() {
        game.doShowTitleScreen();
    }

    public static void showRegisterScreen() {
        game.doShowRegisterScreen();
    }

    protected void doShowRegisterScreen() {
        RegisterScreen.show();
    }

    protected void doShowTitleScreen() {
        TitleScreen.show();
    }

    protected void doShowOptions() {
    }

    public static void showHiscores() {
        game.doShowHiscores();
    }

    protected void doShowHiscores() {
        HiscoresScreen.show(null);
    }

    private void tick() {
        Binding.poll();
        int i = 0;
        while (i < 256) {
            if (Keyboard.isKeyDown((int)i)) {
                Game.KEYDOWN[i] = !KEYWASDOWN[i];
                Game.KEYWASDOWN[i] = true;
            } else {
                Game.KEYWASDOWN[i] = false;
                Game.KEYDOWN[i] = false;
            }
            ++i;
        }
        if (Keyboard.isKeyDown((int)1)) {
            ++this.panic;
            if (this.panic == 60) {
                Game.exit();
            }
        } else {
            this.panic = 0;
        }
        if (Game.wasKeyPressed(25) && pauseEnabled) {
            Game.setPaused(!paused);
        }
        if (!paused) {
            Timer.tick();
            Screen.tickAllScreens();
            this.doTick();
            if (AL.isCreated()) {
                int n = soundPlayers.size();
                int i2 = 0;
                while (i2 < n) {
                    SoundPlayer sp = soundPlayers.get(i2);
                    sp.play();
                    ++i2;
                }
            }
        }
    }

    public static void setPaused(boolean newPaused) {
        paused = newPaused;
        if (game != null) {
            if (paused) {
                Game.game.wasGrabbed = Mouse.isGrabbed();
                Mouse.setGrabbed((boolean)false);
                Display.setTitle((String)(String.valueOf(Game.getTitle()) + " [PAUSED]"));
                game.onPaused();
            } else {
                Mouse.setGrabbed((boolean)Game.game.wasGrabbed);
                Display.setTitle((String)Game.getTitle());
                game.onResumed();
            }
        }
    }

    private final void doTick() {
        this.doGameTick();
    }

    protected abstract void doGameTick();

    protected void onPaused() {
    }

    protected void onResumed() {
    }

    private void render() {
        Screen.updateAllScreens();
        GL11.glClear((int)16384);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)((double)(-this.logicalWidth) / 2.0)), (float)((float)((double)(-this.logicalHeight) / 2.0)), (float)-256.0f);
        this.preRender();
        Screen.renderAllScreens();
        this.postRender();
        GL11.glPopMatrix();
    }

    protected void preRender() {
    }

    protected void postRender() {
    }

    public static String getScoreGroup() {
        return scoreGroup;
    }

    public static void setScoreGroup(String scoreGroup) {
        Game.scoreGroup = scoreGroup;
    }

    public static boolean wasKeyPressed(int key) {
        boolean ret = KEYDOWN[key];
        Game.KEYDOWN[key] = false;
        return ret;
    }

    public static void onRemoteCallSuccess() {
        PREFS.putBoolean("online", true);
    }

    public static boolean isRemoteCallAllowed() {
        return PREFS.getBoolean("online", false);
    }

    public static void setMusicVolume(float vol) {
        musicVolume = (int)Math.max(0.0f, Math.min(100.0f, vol * 100.0f));
        if (music != null) {
            if (music.getStream() != null) {
                if (music.getStream().getSourceStream() != null) {
                    music.setGain(music.getStream().getSourceStream().getGain() * vol, Game.class);
                }
            } else if (music.getBuffer() != null) {
                music.setGain(music.getBuffer().getGain() * vol, Game.class);
            }
        }
        PREFS.putInt("musicvolume", musicVolume);
    }

    public static void setSFXVolume(float vol) {
        sfxVolume = (int)Math.max(0.0f, Math.min(100.0f, vol * 100.0f));
        PREFS.putInt("sfxvolume", sfxVolume);
    }

    public static float getMusicVolume() {
        return (float)musicVolume / 100.0f;
    }

    public static float getSFXVolume() {
        return (float)sfxVolume / 100.0f;
    }

    public static Rectangle getViewPort() {
        return viewPort;
    }

    public static void loadBindings() {
        try {
            byte[] b = PREFS.getByteArray("bindings", null);
            if (b == null) {
                Binding.resetToDefaults();
            } else {
                Binding.load(new ByteArrayInputStream(b));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void saveBindings() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            Binding.save(baos);
            PREFS.putByteArray("bindings", baos.toByteArray());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void redefineKeys() {
        game.doRedefineKeys();
    }

    public static void saveGame() {
        game.doSaveGame();
    }

    protected String getSaveGameRegistryMagicLocation() {
        return "tox";
    }

    protected void doSaveGame() {
        if (!allowSave) {
            return;
        }
        File file = game.getRestoreFile();
        try {
            FileOutputStream fos = new FileOutputStream(file);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            gameState.setMagic(new Random().nextLong());
            if (playerSlot != null) {
                playerSlot.getPreferences().putLong(this.getSaveGameRegistryMagicLocation(), gameState.getMagic());
            } else {
                PREFS.putLong(this.getSaveGameRegistryMagicLocation(), gameState.getMagic());
            }
            oos.writeObject(gameState);
            oos.flush();
            fos.close();
            allowSave = false;
            this.onGameSaved();
            Game.flushPrefs();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        TitleScreen.show();
    }

    protected void onGameSaved() {
        ((EffectFeature)Resources.get((String)SAVE_GAME_EFFECT_FEATURE)).spawn(TitleScreen.getInstance());
    }

    public static boolean isRestoreAvailable() {
        return game.getRestoreFile().exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doFlushPrefs() {
        if (GLOBALPREFS != null) {
            Preferences preferences = GLOBALPREFS;
            synchronized (preferences) {
                block21: {
                    try {
                        GLOBALPREFS.sync();
                        PREFS.sync();
                        if (playerSlot != null) {
                            playerSlot.getPreferences().sync();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                    }
                    FileOutputStream fos = null;
                    BufferedOutputStream bos = null;
                    File prefsFile = new File(Game.getUserPrefsFileName());
                    try {
                        try {
                            fos = new FileOutputStream(prefsFile);
                            bos = new BufferedOutputStream(fos);
                            PREFS.exportSubtree(bos);
                            bos.flush();
                            System.out.println("Saved preferences file " + prefsFile);
                        }
                        catch (Exception e) {
                            e.printStackTrace(System.err);
                            if (fos != null) {
                                try {
                                    fos.close();
                                }
                                catch (IOException e2) {
                                    e2.printStackTrace(System.err);
                                }
                            }
                            break block21;
                        }
                    }
                    catch (Throwable throwable) {
                        if (fos != null) {
                            try {
                                fos.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace(System.err);
                            }
                        }
                        throw throwable;
                    }
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace(System.err);
                        }
                    }
                }
            }
        }
    }

    public static String getUserPrefsFileName() {
        return game.doGetUserPrefsFileName();
    }

    protected String doGetUserPrefsFileName() {
        return String.valueOf(Game.getDirectoryPrefix()) + DEFAULT_USER_PREFS_FILENAME;
    }

    public static void cleanGame() {
        File file = game.getRestoreFile();
        if (file.exists() && !file.delete()) {
            System.err.println("Failed to delete save file " + file);
        }
        allowSave = true;
        game.onCleanGame();
    }

    protected void onCleanGame() {
        this.setGameState(this.createGameState());
        gameState.init();
    }

    protected File getRestoreFile() {
        if (playerSlot != null) {
            return new File(String.valueOf(Game.getPlayerDirectoryPrefix()) + RESTORE_FILE);
        }
        return new File(String.valueOf(Game.getDirectoryPrefix()) + RESTORE_FILE);
    }

    protected abstract GameState createGameState();

    public static void restoreGame() {
        game.onRestoreGame();
    }

    protected void onRestoreGame() {
        if (!Game.isRestoreAvailable()) {
            return;
        }
        topScreen = Screen.getTopScreen();
        if (topScreen == null) {
            return;
        }
        try {
            restoreGameDialog = (DialogScreen)Resources.get((String)RESTORE_GAME_DIALOG_FEATURE);
            restoreGameDialog.doModal("RESTORE GAME", "WOULD YOU LIKE TO RESTORE YOUR SAVED GAME?", new Runnable(){

                public void run() {
                    topScreen.setEnabled(true);
                    switch (restoreGameDialog.getOption()) {
                        case 2: {
                            Game.this.doRestoreGame();
                            break;
                        }
                        case 3: {
                            Game.cleanGame();
                            break;
                        }
                    }
                    restoreGameDialog = null;
                }
            });
            topScreen.setEnabled(false);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    protected void doRestoreGame() {
        allowSave = true;
        File file = this.getRestoreFile();
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        ObjectInputStream ois = null;
        boolean exceptionOccurred = false;
        try {
            try {
                fis = new FileInputStream(file);
                bis = new BufferedInputStream(fis);
                ois = new ObjectInputStream(bis);
                this.setGameState((GameState)ois.readObject());
                long tox = playerSlot != null ? playerSlot.getPreferences().getLong(this.getSaveGameRegistryMagicLocation(), 0L) : PREFS.getLong(this.getSaveGameRegistryMagicLocation(), 0L);
                if (tox != gameState.getMagic()) {
                    throw new Exception("Invalid game state");
                }
                Resources.dequeue();
                gameState.reinit();
            }
            catch (Exception e) {
                exceptionOccurred = true;
                e.printStackTrace(System.err);
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (playerSlot != null) {
                    playerSlot.getPreferences().putLong("tox", new Random().nextLong());
                } else {
                    PREFS.putLong("tox", new Random().nextLong());
                }
                Game.flushPrefs();
                if (exceptionOccurred) {
                    File newFile = new File(String.valueOf(file.getPath()) + ".broken");
                    if (!file.renameTo(newFile)) {
                        System.err.println("Failed to rename " + file + " to " + newFile);
                    }
                } else if (!file.delete()) {
                    System.err.println("Failed to delete save file");
                }
            }
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (Exception newFile) {}
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception newFile) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception newFile) {}
            }
            if (playerSlot != null) {
                playerSlot.getPreferences().putLong("tox", new Random().nextLong());
            } else {
                PREFS.putLong("tox", new Random().nextLong());
            }
            Game.flushPrefs();
            if (exceptionOccurred) {
                File newFile = new File(String.valueOf(file.getPath()) + ".broken");
                if (!file.renameTo(newFile)) {
                    System.err.println("Failed to rename " + file + " to " + newFile);
                }
            } else if (!file.delete()) {
                System.err.println("Failed to delete save file");
            }
        }
    }

    protected void setGameState(GameState newGameState) {
        gameState = newGameState;
    }

    protected void doRedefineKeys() {
        BindingsScreen.show();
    }

    public int getMessageSequence() {
        return this.messageSequence;
    }

    public static void alert(String message) {
        Sys.alert((String)Game.getTitle(), (String)message);
    }

    public static void setAlwaysRun(boolean alwaysRun) {
        Game.alwaysRun = alwaysRun;
    }

    public static boolean getDontUseRemoteHiscores() {
        return Game.game.dontUseRemoteHiscores;
    }

    public static boolean getDontCheckMessages() {
        return Game.game.dontCheckMessages;
    }

    public static boolean getSubmitRemoteHiscores() {
        return !Game.game.dontUseRemoteHiscores && Game.game.submitRemoteHiscores;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSubmitRemoteHiscores(boolean set) {
        Game.game.submitRemoteHiscores = set;
        Preferences preferences = PREFS;
        synchronized (preferences) {
            PREFS.putBoolean("submitremotehiscores", !Game.game.dontUseRemoteHiscores && Game.game.submitRemoteHiscores);
        }
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Preferences preferences = PREFS;
                    synchronized (preferences) {
                        PREFS.flush();
                    }
                }
                catch (BackingStoreException e) {
                    e.printStackTrace(System.err);
                }
            }
        }.start();
    }

    public static boolean isSlotManaged() {
        return Game.game.useSlotManagement;
    }

    public static PlayerSlot getPlayerSlot() {
        return playerSlot;
    }

    public static void setPlayerSlot(PlayerSlot newSlot) {
        if (newSlot == null) {
            throw new IllegalArgumentException("newSlot may not be null");
        }
        playerSlot = newSlot;
        PREFS.put("slot_" + Game.getInternalVersion(), newSlot.getName());
        try {
            PREFS.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace(System.err);
        }
        TitleScreen.updateSlotDetails();
        game.onSetPlayerSlot();
    }

    protected void onSetPlayerSlot() {
    }

    protected void doCreate() {
        super.doCreate();
        soundPlayers = Resources.list(SoundPlayer.class);
        if (soundPlayer != null) {
            soundPlayers.add(soundPlayer);
        }
    }

    public static int getMouseX() {
        return game.doGetMouseX();
    }

    public static int getMouseY() {
        return game.doGetMouseY();
    }

    protected int doGetMouseX() {
        return Mouse.getX();
    }

    protected int doGetMouseY() {
        return Mouse.getY();
    }

    public static float logicalXtoPhysicalX(float logicalX) {
        return logicalX * (float)viewPort.getWidth() / (float)Game.getWidth() + (float)viewPort.getX();
    }

    public static float logicalYtoPhysicalY(float logicalY) {
        return logicalY * (float)viewPort.getHeight() / (float)Game.getHeight() + (float)viewPort.getY();
    }

    public static float physicalXtoLogicalX(float physicalX) {
        return (float)Game.getWidth() * (physicalX - (float)viewPort.getX()) / (float)viewPort.getWidth();
    }

    public static float physicalYtoLogicalY(float physicalY) {
        return (float)Game.getHeight() * (physicalY - (float)viewPort.getY()) / (float)viewPort.getHeight();
    }

    public static void setWindowSize(float windowSize) {
        float oldSize = Game.game.windowSize;
        try {
            if (Game.game.windowSize != windowSize || Display.isFullscreen()) {
                Game.game.windowSize = windowSize;
                if (initialMode.getWidth() > initialMode.getHeight()) {
                    Game.setSize((int)((float)(initialMode.getWidth() * Game.game.scale) * windowSize / (float)initialMode.getHeight()), (int)((float)Game.game.scale * windowSize));
                } else {
                    Game.setSize((int)((float)Game.game.scale * windowSize), (int)((float)(initialMode.getHeight() * Game.game.scale) * windowSize / (float)initialMode.getWidth()));
                }
            }
        }
        catch (Exception e) {
            Game.game.windowSize = oldSize;
        }
    }

    public static float getWindowSize() {
        return Game.game.windowSize;
    }

    public static int getScale() {
        return Game.game.scale;
    }

    public static boolean getUseWindowSizing() {
        return Game.game.useWindowSizing;
    }

    public static void onRegistrationDisaster() {
        if (PREFS.getBoolean("puppygames_exists", false)) {
            return;
        }
        registered = true;
    }

    public static void onRegistrationRecovery() {
        registered = false;
        PREFS.putBoolean("puppygames_exists", true);
        try {
            PREFS.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public static boolean isCustomDisplayMode() {
        return customDisplayMode;
    }

    public static void flushPrefs() {
        if (prefsSaver != null) {
            prefsSaver.save();
        } else {
            Game.doFlushPrefs();
        }
    }

    public static class PrefsSaverThread
    extends Thread {
        boolean threadFinished;
        boolean triggered;

        public PrefsSaverThread() {
            super("Prefs Saver Thread");
            this.setPriority(4);
        }

        public synchronized void save() {
            this.triggered = true;
            this.notifyAll();
        }

        synchronized void finish() {
            this.threadFinished = true;
            this.save();
            try {
                this.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace(System.err);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.threadFinished) {
                PrefsSaverThread prefsSaverThread = this;
                synchronized (prefsSaverThread) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                    while (this.triggered) {
                        this.triggered = false;
                        try {
                            this.wait(200L);
                            if (this.triggered) continue;
                            Game.doFlushPrefs();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }
}

