/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.applet;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.XMLResourceWriter;
import com.shavenpuppy.jglib.opengl.ColorUtil;
import com.shavenpuppy.jglib.opengl.GLFont;
import com.shavenpuppy.jglib.opengl.GLRenderable;
import com.shavenpuppy.jglib.opengl.GLStyledText;
import com.shavenpuppy.jglib.resources.Background;
import com.shavenpuppy.jglib.resources.Data;
import com.shavenpuppy.jglib.resources.Feature;
import com.shavenpuppy.jglib.resources.MappedColor;
import com.shavenpuppy.jglib.resources.RectangleParser;
import com.shavenpuppy.jglib.sprites.Animated;
import com.shavenpuppy.jglib.sprites.AnimatedAppearance;
import com.shavenpuppy.jglib.sprites.AnimatedAppearanceResource;
import com.shavenpuppy.jglib.sprites.SimpleRenderer;
import com.shavenpuppy.jglib.sprites.Sprite;
import com.shavenpuppy.jglib.sprites.SpriteImage;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.XMLUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.puppygames.applet.Anchor;
import net.puppygames.applet.Binding;
import net.puppygames.applet.Bounded;
import net.puppygames.applet.Game;
import net.puppygames.applet.Res;
import net.puppygames.applet.Screen;
import net.puppygames.applet.Tickable;
import net.puppygames.applet.TickableObject;
import net.puppygames.applet.effects.Emitter;
import net.puppygames.applet.effects.EmitterFeature;
import net.puppygames.applet.effects.SFX;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Color;
import org.lwjgl.util.Dimension;
import org.lwjgl.util.Point;
import org.lwjgl.util.ReadableColor;
import org.lwjgl.util.ReadableDimension;
import org.lwjgl.util.ReadablePoint;
import org.lwjgl.util.ReadableRectangle;
import org.lwjgl.util.Rectangle;
import org.w3c.dom.Element;

public class Area
extends Feature
implements Tickable,
Bounded {
    public static final long serialVersionUID = 1L;
    private static final Color TEMPCOLOR = new Color();
    @Data
    private String id;
    @Data
    private String group;
    private String mouseOff;
    private String mouseOn;
    private String disabled;
    private boolean useBounds;
    private List<ReadableRectangle> hitBoxes;
    private Point position;
    private Dimension size;
    private Point offset;
    private boolean noClick;
    private boolean debug;
    private int layer;
    private boolean visible = true;
    private String font;
    private String fullscreenFont;
    @Data
    private String text;
    @Data
    private String halign;
    @Data
    private String valign;
    private MappedColor color;
    private MappedColor disabledColor;
    private MappedColor mouseOnColor;
    private MappedColor topColor;
    private MappedColor disabledTopColor;
    private MappedColor mouseOnTopColor;
    private MappedColor bottomColor;
    private MappedColor disabledBottomColor;
    private MappedColor mouseOnBottomColor;
    @Data
    private String leftFocus;
    @Data
    private String rightFocus;
    @Data
    private String upFocus;
    @Data
    private String downFocus;
    @Data
    private String nextFocus;
    @Data
    private String prevFocus;
    private boolean defaultFocus;
    private boolean mirrored;
    private boolean flipped;
    private String background;
    private String disabledBackground;
    private String mouseOnBackground;
    private int bglayer;
    private int textLayer;
    private int leading;
    private boolean hasSize;
    private boolean hasPosition;
    private boolean textAsSubTag;
    private Point textOffset;
    private String emitter;
    private Point emitterOffset;
    private String link;
    private float scale = 0.0f;
    private MappedColor textShadowColor;
    private Point textShadowOffset;
    private Rectangle textBounds;
    private int alpha;
    private int textAlpha;
    private String master;
    private ArrayList<Anchor> anchors;
    private boolean holdClick;
    private transient AnimatedAppearanceResource mouseOnResource;
    private transient AnimatedAppearanceResource mouseOffResource;
    private transient AnimatedAppearanceResource disabledResource;
    private transient int state;
    private static final int STATE_MOUSEOFF = 0;
    private static final int STATE_MOUSEON = 1;
    private static final int STATE_DISABLED = 2;
    private transient Sprite sprite;
    private transient Rectangle bounds;
    private transient Screen screen;
    private transient boolean ignoreMouse;
    private transient boolean enabled;
    private transient GLStyledText textArea;
    private transient String[] groups;
    private transient Background backgroundResource;
    private transient Background disabledBackgroundResource;
    private transient Background mouseOnBackgroundResource;
    private transient TickableObject backgroundObject;
    private transient TickableObject textObject;
    private transient GLFont fontResource;
    private transient GLFont fullscreenFontResource;
    private transient boolean selectDown;
    private transient boolean armed;
    private transient boolean initing;
    private transient boolean waitForMouse;
    private transient EmitterFeature emitterFeature;
    private transient AnimatedAppearance currentAppearance;
    private transient Background.Instance backgroundInstance;
    private transient Emitter emitterInstance;
    private transient List<Area> slaves;
    private transient Area masterArea;

    public Area() {
        this.setAutoCreated();
    }

    public Area(String name) {
        super(name);
        this.setAutoCreated();
    }

    public ReadableRectangle getBounds() {
        if (this.bounds == null) {
            SpriteImage image;
            if (this.sprite != null && (image = this.sprite.getImage()) != null) {
                this.bounds = new Rectangle((int)this.sprite.getX(), (int)this.sprite.getY(), image.getWidth(), image.getHeight());
            }
            if (this.bounds == null) {
                this.bounds = new Rectangle(0, 0, 0, 0);
            }
        }
        return this.bounds;
    }

    public int getLayer() {
        return this.layer;
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        List anchorElements;
        Element hitboxesElement;
        super.load(element, loader);
        if (this.size != null) {
            this.hasSize = true;
        }
        if (this.position != null) {
            this.hasPosition = true;
        }
        if (this.text == null && XMLUtil.hasChild((Element)element, (String)"text")) {
            this.text = XMLUtil.getText((Element)XMLUtil.getChild((Element)element, (String)"text"), (String)"<missing text>");
            this.textAsSubTag = true;
        }
        if (!XMLUtil.hasAttribute((Element)element, (String)"alpha")) {
            this.alpha = 255;
        }
        if (!XMLUtil.hasAttribute((Element)element, (String)"textAlpha")) {
            this.textAlpha = 255;
        }
        if ((hitboxesElement = XMLUtil.getChild((Element)element, (String)"hitboxes")) != null) {
            this.useBounds = XMLUtil.getBoolean((Element)hitboxesElement, (String)"useBounds", (boolean)false);
            List hitBoxesChildren = XMLUtil.getChildren((Element)hitboxesElement, (String)"hitbox");
            this.hitBoxes = new ArrayList<ReadableRectangle>(hitBoxesChildren.size() + 1);
            for (Element child : hitBoxesChildren) {
                Rectangle r = RectangleParser.parse((String)XMLUtil.getText((Element)child, (String)"0,0,0,0"));
                this.hitBoxes.add((ReadableRectangle)r);
            }
        }
        if ((anchorElements = XMLUtil.getChildren((Element)element, (String)"anchor")).size() > 0) {
            this.anchors = new ArrayList(anchorElements.size());
            for (Element anchorChild : anchorElements) {
                Anchor anchor = (Anchor)loader.load(anchorChild);
                this.anchors.add(anchor);
            }
        }
    }

    public void init() {
        this.onResized();
        if (this.sprite != null && this.mouseOffResource != null) {
            this.sprite.setAppearance((AnimatedAppearance)this.mouseOffResource);
            this.sprite.rewind();
            if (this.offset != null) {
                this.sprite.setOffset((float)this.offset.getX(), (float)this.offset.getY(), 0.0f);
            }
            this.updateScale();
        }
        this.maybeCreateTextObject();
        if (this.emitterFeature != null) {
            this.initEmitter();
        }
        this.doSetVisible(this.visible);
        this.initing = true;
        this.setAppearanceForState();
        this.syncSlaves();
        this.waitForMouse = true;
        this.initing = false;
    }

    public void waitForMouse() {
        this.waitForMouse = true;
    }

    public void onResized() {
        if (this.anchors != null) {
            for (Anchor anchor : this.anchors) {
                anchor.apply(this);
            }
        } else if (this.position != null) {
            boolean centreY;
            boolean centreX = this.screen.isCentred() || this.screen.isCentredX();
            boolean bl = centreY = this.screen.isCentred() || this.screen.isCentredY();
            if (centreX || centreY) {
                ReadableRectangle bounds = this.getBounds();
                int newX = centreX ? (Game.getWidth() - Game.getScale()) / 2 + this.position.getX() : this.position.getX();
                int newY = centreY ? (Game.getHeight() - Game.getScale()) / 2 + this.position.getY() : this.position.getY();
                boolean hasPositionOld = this.hasPosition;
                this.hasPosition = false;
                this.setBounds(newX, newY, bounds.getWidth(), bounds.getHeight());
                this.hasPosition = hasPositionOld;
            }
        }
        this.updateTextColors();
    }

    private void maybeCreateTextObject() {
        if (this.textArea != null && this.getScreen() != null) {
            if (this.textObject != null) {
                this.textObject.remove();
                this.textObject = null;
            }
            this.textObject = new TickableObject((this.text.length() + 32) * 4){

                protected void render() {
                    if (Area.this.textShadowColor != null && Area.this.textShadowOffset != null) {
                        this.glRender(new GLRenderable(){

                            public void render() {
                                GL11.glPushMatrix();
                                GL11.glTranslatef((float)Area.this.textShadowOffset.getX(), (float)Area.this.textShadowOffset.getY(), (float)0.0f);
                            }
                        });
                        ColorUtil.setAlpha((ReadableColor)Area.this.textShadowColor, (int)Area.this.alpha, (Color)TEMPCOLOR);
                        Area.this.textArea.setColor((ReadableColor)TEMPCOLOR);
                        try {
                            Area.this.textArea.render((SimpleRenderer)this);
                        }
                        catch (Exception e) {
                            System.out.println("Failed to render " + Area.this + " due to " + e);
                            e.printStackTrace();
                        }
                        Area.this.updateTextColors();
                        this.glRender(new GLRenderable(){

                            public void render() {
                                GL11.glPopMatrix();
                            }
                        });
                        Area.this.textArea.setColor(ReadableColor.WHITE);
                    }
                    Area.this.textArea.render((SimpleRenderer)this);
                }
            };
            this.textObject.setLayer(this.textLayer);
            this.textObject.setVisible(this.visible);
            this.textObject.spawn(this.screen);
        }
    }

    private void initEmitter() {
        int oy;
        int ox;
        this.emitterInstance = this.emitterFeature.spawn(this.getScreen());
        if (this.emitterOffset != null) {
            ox = this.emitterOffset.getX();
            oy = this.emitterOffset.getY();
        } else {
            ox = 0;
            oy = 0;
        }
        this.emitterInstance.setLocation(this.position.getX() + ox, this.position.getY() + oy);
    }

    protected void doCreate() {
        super.doCreate();
        if (this.group != null) {
            StringTokenizer st = new StringTokenizer(this.group, ",", false);
            this.groups = new String[st.countTokens()];
            int count = 0;
            while (st.hasMoreTokens()) {
                this.groups[count] = st.nextToken().trim();
                ++count;
            }
        }
        if (this.mouseOffResource != null && this.mouseOffResource instanceof SpriteImage) {
            SpriteImage img = (SpriteImage)this.mouseOffResource;
            if (this.position != null && img != null) {
                this.bounds = new Rectangle(this.position.getX() - img.getHotspotX(), this.position.getY() - img.getHotspotY(), img.getWidth(), img.getHeight());
                if (!this.hasSize) {
                    this.size = new Dimension(img.getWidth(), img.getHeight());
                }
            }
        }
        if (this.size == null) {
            // empty if block
        }
        this.bounds = this.size != null && this.position != null ? new Rectangle((ReadablePoint)this.position, (ReadableDimension)this.size) : (this.position != null ? new Rectangle((ReadablePoint)this.position, (ReadableDimension)new Dimension(0, 0)) : (this.size != null ? new Rectangle((ReadablePoint)new Point(0, 0), (ReadableDimension)this.size) : new Rectangle()));
        if (this.text != null) {
            this.createTextArea();
        }
        this.enabled = true;
    }

    protected void doDestroy() {
        super.doDestroy();
        this.cleanup();
    }

    private void maybeCreateSprite() {
        if (this.mouseOffResource != null) {
            if (this.sprite != null) {
                this.sprite.setVisible(this.visible);
                this.sprite.setAlpha(this.alpha);
                return;
            }
            this.sprite = this.screen.allocateSprite((Serializable)((Object)this));
            if (this.sprite == null) {
                System.err.println("Failed to create " + this + ": no sprite available");
                this.destroy();
            } else {
                this.sprite.setAlpha(this.alpha);
                this.sprite.setLayer(this.layer);
                this.sprite.setLocation((float)this.bounds.getX(), (float)this.bounds.getY(), 0.0f);
                this.sprite.setMirrored(this.mirrored);
                this.sprite.setFlipped(this.flipped);
                this.sprite.setVisible(this.visible);
                if (this.getOffset() != null) {
                    this.sprite.setOffset((float)this.getOffset().getX(), (float)this.getOffset().getY(), 0.0f);
                }
                this.updateScale();
            }
        } else if (this.sprite != null) {
            this.sprite.deallocate();
            this.sprite = null;
        }
    }

    private void updateScale() {
        if (this.scale != 1.0f && this.scale != 0.0f && this.sprite != null) {
            this.sprite.setScale(FPMath.fpValue((float)this.scale));
        }
    }

    public void spawn(Screen newScreen) {
        this.screen = newScreen;
        newScreen.addTickable(this);
        this.maybeCreateSprite();
        this.setBackground(this.backgroundResource);
        if (this.master != null) {
            this.masterArea = newScreen.getArea(this.master);
            if (this.masterArea == null) {
                System.out.println("Warning: Area " + this.id + " references master " + this.master + ", which does not exist on screen " + (Object)((Object)newScreen));
            } else {
                this.masterArea.addSlave(this);
            }
        }
        this.syncSlaves();
    }

    private void addSlave(Area slave) {
        if (this.slaves == null) {
            this.slaves = new ArrayList<Area>();
        }
        if (!this.slaves.contains(slave)) {
            this.slaves.add(slave);
        }
        this.syncSlaves();
    }

    private void syncSlaves() {
        this.syncVisibility();
        this.syncEnabled();
        this.syncStates();
    }

    private GLFont selectFont() {
        GLFont ret = null;
        if (Display.isFullscreen()) {
            ret = this.fullscreenFontResource;
        }
        if (ret == null) {
            ret = this.fontResource;
        }
        if (ret == null) {
            ret = Res.getTinyFont();
        }
        return ret;
    }

    public void cleanup() {
        if (this.sprite != null) {
            this.sprite.deallocate();
            this.sprite = null;
        }
        if (this.backgroundObject != null) {
            this.backgroundObject.remove();
            this.backgroundObject = null;
        }
        if (this.textObject != null) {
            this.textObject.remove();
            this.textObject = null;
        }
        if (this.emitterInstance != null) {
            this.emitterInstance.remove();
            this.emitterInstance = null;
        }
        this.currentAppearance = null;
        this.slaves = null;
    }

    public void update() {
    }

    private boolean isInHitZone(int x, int y) {
        int i;
        if (this.slaves != null) {
            i = 0;
            while (i < this.slaves.size()) {
                Area slave = this.slaves.get(i);
                if (slave.isInHitZone(x, y)) {
                    return true;
                }
                ++i;
            }
        }
        if (this.hitBoxes != null) {
            i = 0;
            while (i < this.hitBoxes.size()) {
                Rectangle rect = (Rectangle)this.hitBoxes.get(i);
                if (rect.contains(x, y)) {
                    return true;
                }
                ++i;
            }
        } else if (this.getBounds() != null) {
            return this.bounds.contains(x, y);
        }
        return false;
    }

    public void tick() {
        if (!this.screen.isOpen()) {
            return;
        }
        if (this.screen.getGrabbed() != null && this.screen.getGrabbed() != this) {
            return;
        }
        if (this.masterArea != null) {
            return;
        }
        boolean mouseDown = Mouse.isButtonDown((int)0);
        if (this.waitForMouse) {
            if (mouseDown) {
                if (!this.enabled) {
                    this.setState(2);
                } else {
                    this.setState(0);
                }
                return;
            }
            this.waitForMouse = false;
        }
        boolean clicked = false;
        this.selectDown = false;
        this.armed = false;
        if (this.isVisible()) {
            if (this.screen.isKeyboardNavigationEnabled()) {
                this.selectDown = Keyboard.isKeyDown((int)57) || Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)28) || Binding.isBindingDown("select.binding") || Binding.isBindingDown("select.binding.alt");
                boolean bl = this.armed = this.isFocused() && this.isFocusable();
                if (this.selectDown && this.armed) {
                    clicked = true;
                } else {
                    this.selectDown = mouseDown;
                    boolean mouseArmed = this.isInHitZone(this.screen.getMouseX(), this.screen.getMouseY());
                    if (this.selectDown && mouseArmed) {
                        clicked = true;
                        if (this.enabled && this.screen.isEnabled()) {
                            this.requestFocus();
                        }
                    } else {
                        this.armed |= mouseArmed;
                    }
                }
            } else {
                this.selectDown = mouseDown;
                this.armed = this.isInHitZone(this.screen.getMouseX(), this.screen.getMouseY());
                if (this.selectDown && this.armed) {
                    clicked = true;
                }
            }
            if (!this.enabled) {
                this.setState(2);
            } else if (this.screen.isEnabled()) {
                if (this.armed) {
                    this.setState(1);
                } else {
                    this.setState(0);
                }
            } else {
                this.setState(0);
            }
            if (this.selectDown && this.visible && this.armed && !this.noClick && !this.ignoreMouse && this.enabled && this.screen.isEnabled() && clicked) {
                if (!this.holdClick) {
                    SFX.buttonClick();
                    this.ignoreMouse = true;
                }
                this.doClick();
            } else if (!this.selectDown) {
                this.ignoreMouse = false;
            }
        }
    }

    public void doClick() {
        if (this.master != null) {
            this.masterArea.doClick();
        } else {
            this.screen.onClicked(this.id);
        }
    }

    private void setBackground(Background newBG) {
        if (newBG != null) {
            this.backgroundInstance = newBG.spawn();
            this.backgroundInstance.setBounds((ReadableRectangle)this.bounds);
            this.backgroundInstance.setAlpha(this.alpha);
            this.createBackgroundObject();
        } else {
            if (this.backgroundObject != null) {
                this.backgroundObject.remove();
                this.backgroundObject = null;
            }
            this.backgroundInstance = null;
        }
    }

    private void createBackgroundObject() {
        if (this.backgroundObject != null) {
            this.backgroundObject.remove();
            this.backgroundObject = null;
        }
        this.backgroundObject = new TickableObject(){

            protected void render() {
                Area.this.backgroundInstance.render((SimpleRenderer)this);
            }
        };
        this.backgroundObject.spawn(this.screen);
        this.backgroundObject.setLayer(this.bglayer);
        this.backgroundObject.setVisible(this.visible);
    }

    public void setMouseOnAppearance(AnimatedAppearanceResource newMouseOnResource) {
        this.initing = true;
        this.mouseOnResource = newMouseOnResource;
        this.currentAppearance = null;
        this.setAppearanceForState();
        this.initing = false;
    }

    public void setMouseOffAppearance(AnimatedAppearanceResource newMouseOffResource) {
        this.initing = true;
        this.mouseOffResource = newMouseOffResource;
        this.currentAppearance = null;
        this.maybeCreateSprite();
        this.setAppearanceForState();
        this.initing = false;
    }

    public AnimatedAppearanceResource getMouseOffAppearance() {
        return this.mouseOffResource;
    }

    public AnimatedAppearanceResource getMouseOnAppearance() {
        return this.mouseOnResource;
    }

    public AnimatedAppearanceResource getDisabledAppearance() {
        return this.disabledResource;
    }

    public void setDisabledAppearance(AnimatedAppearanceResource newDisabledResource) {
        this.initing = true;
        this.disabledResource = newDisabledResource;
        this.currentAppearance = null;
        this.setAppearanceForState();
        this.initing = false;
    }

    private void setAppearanceForState() {
        switch (this.state) {
            case 0: {
                if (this.mouseOffResource != null) {
                    this.setAppearance((AnimatedAppearance)this.mouseOffResource);
                }
                this.setBackground(this.backgroundResource);
                if (!this.visible || this.noClick || this.initing) break;
                this.screen.onHover(this.id, false);
                break;
            }
            case 1: {
                if (this.mouseOnResource != null) {
                    this.setAppearance((AnimatedAppearance)this.mouseOnResource);
                }
                if (this.mouseOnBackgroundResource != null) {
                    this.setBackground(this.mouseOnBackgroundResource);
                } else {
                    this.setBackground(this.backgroundResource);
                }
                if (!this.visible || this.noClick || this.initing) break;
                SFX.buttonHover();
                this.screen.onHover(this.id, true);
                break;
            }
            case 2: {
                if (this.disabledResource != null) {
                    this.setAppearance((AnimatedAppearance)this.disabledResource);
                }
                if (this.disabledBackgroundResource != null) {
                    this.setBackground(this.disabledBackgroundResource);
                    break;
                }
                this.setBackground(this.backgroundResource);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.updateTextColors();
    }

    private void setState(int newState) {
        if (this.state == newState) {
            return;
        }
        this.state = newState;
        this.setAppearanceForState();
        this.syncStates();
    }

    private void syncStates() {
        if (this.slaves == null) {
            return;
        }
        int i = 0;
        while (i < this.slaves.size()) {
            Area slave = this.slaves.get(i);
            slave.armed = this.armed;
            slave.selectDown = this.selectDown;
            slave.setState(this.state);
            ++i;
        }
    }

    private void setAppearance(AnimatedAppearance appearance) {
        if (this.sprite == null || this.currentAppearance == appearance) {
            return;
        }
        this.sprite.setAnimation(null);
        this.sprite.setAppearance(appearance);
        this.currentAppearance = appearance;
    }

    public void render() {
        if (this.position != null && this.size != null && this.debug) {
            GL11.glDisable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glTexEnvi((int)8960, (int)8704, (int)8448);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.2f);
            GL11.glBegin((int)7);
            GL11.glVertex2i((int)this.position.getX(), (int)this.position.getY());
            GL11.glVertex2i((int)(this.position.getX() + this.size.getWidth()), (int)this.position.getY());
            GL11.glVertex2i((int)(this.position.getX() + this.size.getWidth()), (int)(this.position.getY() + this.size.getHeight()));
            GL11.glVertex2i((int)this.position.getX(), (int)(this.position.getY() + this.size.getHeight()));
            GL11.glEnd();
        }
    }

    public String getID() {
        return this.id;
    }

    public String toString() {
        return "Area[" + this.id + "]";
    }

    public Sprite getSprite() {
        return this.sprite;
    }

    public Screen getScreen() {
        return this.screen;
    }

    public void setVisible(boolean visible) {
        if (this.visible == visible) {
            if (this.link != null) {
                Area linked = this.screen.getArea(this.link);
                if (linked != null) {
                    linked.setVisible(visible);
                } else {
                    System.out.println("Linked area '" + this.link + "' does not exist");
                }
            }
            return;
        }
        this.doSetVisible(visible);
    }

    protected void doSetVisible(boolean visible) {
        this.visible = visible;
        if (visible) {
            this.ignoreMouse = true;
        }
        if (this.sprite != null) {
            this.sprite.setVisible(visible);
            if (visible) {
                if (this.isEnabled() || this.disabledResource == null) {
                    this.mouseOffResource.toAnimated((Animated)this.sprite);
                    this.currentAppearance = this.mouseOffResource;
                } else {
                    this.disabledResource.toAnimated((Animated)this.sprite);
                    this.currentAppearance = this.disabledResource;
                }
            } else {
                this.currentAppearance = null;
                this.sprite.rewind();
            }
        }
        if (this.backgroundObject != null) {
            this.backgroundObject.setVisible(visible);
            if (this.sprite != null) {
                this.sprite.setActive(visible);
            }
        }
        if (this.textObject != null) {
            this.textObject.setVisible(visible);
        }
        if (this.emitterInstance != null) {
            if (!visible) {
                this.emitterInstance.remove();
                this.emitterInstance = null;
            }
        } else if (this.emitterFeature != null) {
            this.initEmitter();
        }
        if (this.link != null) {
            Area linked = this.screen.getArea(this.link);
            if (linked != null) {
                linked.doSetVisible(visible);
            } else {
                System.out.println("Linked area '" + this.link + "' does not exist");
            }
        }
        this.syncVisibility();
        if (visible && this.isFocusable()) {
            this.requestFocus();
        }
    }

    private void syncVisibility() {
        if (this.slaves == null) {
            return;
        }
        int i = 0;
        while (i < this.slaves.size()) {
            Area slave = this.slaves.get(i);
            slave.setVisible(this.visible);
            ++i;
        }
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
        if (this.sprite != null) {
            this.sprite.setAlpha(alpha);
        }
        if (this.backgroundInstance != null) {
            this.backgroundInstance.setAlpha(alpha);
        }
        this.updateTextColors();
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        this.setState(enabled ? 0 : 2);
        this.setAppearanceForState();
        if (this.link != null) {
            Area linked = this.screen.getArea(this.link);
            if (linked != null) {
                linked.setEnabled(enabled);
            } else {
                System.err.println("Linked area '" + this.link + "' does not exist");
            }
        }
        this.syncEnabled();
    }

    private void syncEnabled() {
        if (this.slaves == null) {
            return;
        }
        int i = 0;
        while (i < this.slaves.size()) {
            Area slave = this.slaves.get(i);
            slave.setEnabled(this.enabled);
            ++i;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isActive() {
        return this.isCreated();
    }

    public void remove() {
    }

    public String getNextFocus() {
        return this.nextFocus;
    }

    public String getPrevFocus() {
        return this.prevFocus;
    }

    public String getLeftFocus() {
        return this.leftFocus;
    }

    public String getRightFocus() {
        return this.rightFocus;
    }

    public String getUpFocus() {
        return this.upFocus;
    }

    public String getDownFocus() {
        return this.downFocus;
    }

    public boolean isFocused() {
        return this.screen.getFocus() == this && this.screen.isKeyboardNavigationEnabled() && this.visible && this.enabled && !this.noClick;
    }

    public boolean isDefaultFocus() {
        return this.defaultFocus;
    }

    public boolean isFocusable() {
        return this.visible && this.enabled && !this.noClick && this.masterArea == null;
    }

    public boolean isInGroup(String groupToCheck) {
        if (groupToCheck == null || this.groups == null) {
            return false;
        }
        int i = 0;
        while (i < this.groups.length) {
            if (groupToCheck.equals(this.groups[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void requestFocus() {
        this.screen.requestFocus(this);
    }

    public Background.Instance getBackground() {
        return this.backgroundInstance;
    }

    public SpriteImage getCurrentImage() {
        return this.sprite != null ? this.sprite.getImage() : null;
    }

    public ReadablePoint getPosition() {
        return this.position;
    }

    public void setBounds(int x, int y, int w, int h) {
        this.bounds.setBounds(x, y, w, h);
        if (this.sprite != null) {
            this.sprite.setLocation((float)x, (float)y, 0.0f);
        }
        if (this.hasSize) {
            this.size.setSize(w, h);
        }
        if (this.hasPosition) {
            this.position.setLocation(x, y);
        }
        if (this.textArea != null) {
            this.updateTextBounds();
        }
        if (this.backgroundInstance != null) {
            this.backgroundInstance.setBounds((ReadableRectangle)this.bounds);
        }
    }

    public void setTextOffset(int x, int y) {
        this.textOffset = x == 0 && y == 0 ? null : new Point(x, y);
        this.updateTextBounds();
    }

    public GLFont getFont() {
        return this.fontResource;
    }

    public String getText() {
        return this.text;
    }

    public ReadablePoint getTextOffset() {
        if (this.textOffset == null) {
            return new Point();
        }
        return this.textOffset;
    }

    private void updateTextBounds() {
        if (this.textArea == null) {
            return;
        }
        Rectangle b = null;
        if (this.bounds != null) {
            b = this.bounds;
        }
        if (this.textBounds != null) {
            b = this.textBounds;
            if (this.bounds != null) {
                b.translate((ReadablePoint)this.bounds);
            }
        }
        if (b == null) {
            return;
        }
        int x = b.getX();
        int y = b.getY();
        int w = b.getWidth();
        int h = b.getHeight();
        if (this.textOffset != null) {
            x += this.textOffset.getX();
            y += this.textOffset.getY();
        }
        this.textArea.setBounds(x, y, w, h);
    }

    protected boolean shouldWriteAttribute(String attribute) {
        return !("text".equals(attribute) || "textAsSubTag".equals(attribute) || "hasSize".equals(attribute) || "hasPosition".equals(attribute) || "useBounds".equals(attribute) || "size".equals(attribute) && !this.hasSize || "position".equals(attribute) && !this.hasPosition) && (!"alpha".equals(attribute) || this.alpha != 255);
    }

    protected void doWriteAttributes(XMLResourceWriter writer) throws IOException {
        if (!this.textAsSubTag) {
            writer.writeAttribute("text", (Object)this.text);
        }
    }

    protected void doWriteChildren(XMLResourceWriter writer) throws IOException {
        if (this.textAsSubTag) {
            writer.writeTag("text");
            writer.writeText(this.text);
            writer.closeTag();
        }
        if (this.hitBoxes != null) {
            writer.writeTag("hitboxes");
            if (this.useBounds) {
                writer.writeAttribute("useBounds", true);
            }
            for (ReadableRectangle r : this.hitBoxes) {
                writer.writeTag("hitbox");
                writer.writeText(String.valueOf(r.getX()));
                writer.writeText(", ");
                writer.writeText(String.valueOf(r.getY()));
                writer.writeText(", ");
                writer.writeText(String.valueOf(r.getWidth()));
                writer.writeText(", ");
                writer.writeText(String.valueOf(r.getHeight()));
                writer.closeTag();
            }
            writer.closeTag();
        }
    }

    public void setText(String text) {
        this.text = text;
        if (this.textArea == null && text != null) {
            this.createTextArea();
        } else if (this.textArea != null && text == null) {
            this.textArea = null;
            if (this.textObject != null) {
                this.textObject.remove();
                this.textObject = null;
            }
        } else if (this.textArea != null && text != null) {
            this.textArea.setText(text);
        }
    }

    private String getFormatString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append("{font:");
        sb.append(this.selectFont().getName());
        if (this.color != null) {
            sb.append(" color:");
            sb.append(this.color);
        } else {
            if (this.topColor != null) {
                sb.append(" top:");
                sb.append(this.topColor);
            }
            if (this.bottomColor != null) {
                sb.append(" bottom:");
                sb.append(this.bottomColor);
            }
        }
        sb.append("}");
        return sb.toString();
    }

    private void createTextArea() {
        this.textArea = new GLStyledText();
        this.textArea.setText(this.text);
        this.textArea.setLeading(this.leading);
        this.textArea.setAlpha(this.textAlpha);
        try {
            this.textArea.setVerticalAlignment(this.valign == null ? GLStyledText.TOP : (GLStyledText.VerticalAlignment)GLStyledText.VerticalAlignment.decode((String)this.valign));
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        try {
            this.textArea.setHorizontalAlignment(this.halign == null ? GLStyledText.CENTERED : (GLStyledText.HorizontalAlignment)GLStyledText.HorizontalAlignment.decode((String)this.halign));
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        this.updateTextColors();
        this.updateTextBounds();
        this.maybeCreateTextObject();
    }

    private void updateTextColors() {
        MappedColor currentBottomColor;
        MappedColor currentTopColor;
        MappedColor currentColor;
        if (this.textArea == null) {
            return;
        }
        switch (this.state) {
            case 2: {
                currentColor = this.disabledColor != null ? this.disabledColor : this.color;
                currentTopColor = this.disabledTopColor != null ? this.disabledTopColor : this.topColor;
                currentBottomColor = this.disabledBottomColor != null ? this.disabledBottomColor : this.bottomColor;
                break;
            }
            case 0: {
                currentColor = this.color;
                currentTopColor = this.topColor;
                currentBottomColor = this.bottomColor;
                break;
            }
            case 1: {
                currentColor = this.mouseOnColor != null ? this.mouseOnColor : this.color;
                currentTopColor = this.mouseOnTopColor != null ? this.mouseOnTopColor : this.topColor;
                currentBottomColor = this.mouseOnBottomColor != null ? this.mouseOnBottomColor : this.bottomColor;
                break;
            }
            default: {
                assert (false);
                return;
            }
        }
        if (currentTopColor != null & currentBottomColor != null) {
            this.textArea.setFactory((GLStyledText.StyledTextFactory)new GLStyledText.DefaultStyledTextFactory((ReadableColor)currentTopColor, (ReadableColor)currentBottomColor, this.selectFont()));
        } else if (currentColor != null) {
            this.textArea.setFactory((GLStyledText.StyledTextFactory)new GLStyledText.DefaultStyledTextFactory((ReadableColor)currentColor, (ReadableColor)currentColor, this.selectFont()));
        } else {
            this.textArea.setFactory((GLStyledText.StyledTextFactory)new GLStyledText.DefaultStyledTextFactory(ReadableColor.WHITE, ReadableColor.WHITE, this.selectFont()));
        }
        this.textArea.setAlpha(this.alpha * this.textAlpha / 255);
    }

    public boolean isSelectDown() {
        return this.selectDown;
    }

    public boolean isArmed() {
        return this.armed;
    }

    public void setOffset(int x, int y) {
        this.offset = x == 0 && y == 0 ? null : new Point(x, y);
        if (this.sprite != null) {
            this.sprite.setOffset((float)x, (float)y, 0.0f);
        }
    }

    public ReadablePoint getOffset() {
        return this.offset;
    }

    public Rectangle getTextBounds() {
        return this.textBounds;
    }

    public void setTextColors(ReadableColor top, ReadableColor bottom) {
        if (this.topColor == null) {
            this.topColor = new MappedColor();
        }
        if (this.bottomColor == null) {
            this.bottomColor = new MappedColor();
        }
        this.topColor.setColor(top);
        this.bottomColor.setColor(bottom);
        this.updateTextColors();
    }

    public void setDisabledTextColors(ReadableColor top, ReadableColor bottom) {
        if (this.disabledTopColor == null) {
            this.disabledTopColor = new MappedColor();
        }
        if (this.disabledBottomColor == null) {
            this.disabledBottomColor = new MappedColor();
        }
        this.disabledTopColor.setColor(top);
        this.disabledBottomColor.setColor(bottom);
        this.updateTextColors();
    }

    public void setMouseOnTextColors(ReadableColor top, ReadableColor bottom) {
        if (this.mouseOnTopColor == null) {
            this.mouseOnTopColor = new MappedColor();
        }
        if (this.mouseOnBottomColor == null) {
            this.mouseOnBottomColor = new MappedColor();
        }
        this.mouseOnTopColor.setColor(top);
        this.mouseOnBottomColor.setColor(bottom);
        this.updateTextColors();
    }

    public void setTextAlpha(int textAlpha) {
        this.textAlpha = textAlpha;
        if (this.textArea != null) {
            this.textArea.setAlpha(this.alpha * textAlpha / 255);
        }
    }

    public int getTextHeight() {
        return this.textArea != null ? this.textArea.getHeight() : 0;
    }
}

