/*
 * Decompiled with CFR 0.152.
 */
package net.puppygames.gamecommerce.shared;

import java.io.Serializable;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import net.puppygames.gamecommerce.shared.HexDecoder;
import net.puppygames.gamecommerce.shared.HexEncoder;

public final class NewsletterIncentive
implements Serializable {
    public static final long serialVersionUID = 1L;
    public static final int CODE_LENGTH = 8;
    private static final String ENCODING = "UTF-8";
    public static final String ALGORITHM = "DSA";
    private static final String SIGNATURE_ALGORITHM = "SHA1withDSA";
    public static final String PUBLIC_KEY = "308201b83082012c06072a8648ce3804013082011f02818100fd7f53811d75122952df4a9c2eece4e7f611b7523cef4400c31e3f80b6512669455d402251fb593d8d58fabfc5f5ba30f6cb9b556cd7813b801d346ff26660b76b9950a5a49f9fe8047b1022c24fbba9d7feb7c61bf83b57e7c6a8a6150f04fb83f6d3c51ec3023554135a169132f675f3ae2b61d72aeff22203199dd14801c70215009760508f15230bccb292b982a2eb840bf0581cf502818100f7e1a085d69b3ddecbbcab5c36b857b97994afbbfa3aea82f9574c0b3d0782675159578ebad4594fe67107108180b449167123e84c281613b7cf09328cc8a6e13c167a8b547c8d28e0a3ae1e2bb3a675916ea37f0bfa213562f1fb627a01243bcca4f1bea8519089a883dfe15ae59f06928b665e807b552564014c3bfecf492a0381850002818100cfff377f44e641902f83c8bd33af2f02efddbb53466d3b0a889f4f936fc88e1f8f39427944d35c04f6c7d6afa38a642d54faa18117a9aeac6f1f5e98b2d8dbdff60406aa11fd43962d052319d883cf361ed65b0b35453fcb37496be9e69448ce4445626629ada640b2f16d56c4c062252bca564087d920ec7805ac2520dd4620";
    private final String email;
    private final String game;
    private final String version;
    private final long installation;
    private final String prize;
    private byte[] code;

    public NewsletterIncentive(String email, String game, String version, long installation, String prize) {
        this.email = email;
        this.game = game;
        this.version = version;
        this.installation = installation;
        this.prize = prize;
    }

    public String getPrize() {
        return this.prize;
    }

    public String getShortCode() {
        String packedRegCode = HexEncoder.encode(this.code);
        return packedRegCode.substring(packedRegCode.length() - 8, packedRegCode.length());
    }

    public boolean validate() throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
        X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(HexDecoder.decode(PUBLIC_KEY));
        PublicKey publicKey = keyFactory.generatePublic(publicKeySpec);
        Signature dsa = Signature.getInstance(SIGNATURE_ALGORITHM);
        dsa.initVerify(publicKey);
        dsa.update(this.email.getBytes(ENCODING));
        dsa.update(this.game.getBytes(ENCODING));
        dsa.update(this.version.getBytes(ENCODING));
        dsa.update(String.valueOf(this.installation).getBytes(ENCODING));
        dsa.update(this.prize.getBytes(ENCODING));
        return dsa.verify(this.code);
    }

    public void register(PrivateKey privateKey) throws Exception {
        Signature dsa = Signature.getInstance(SIGNATURE_ALGORITHM);
        dsa.initSign(privateKey);
        dsa.update(this.email.getBytes(ENCODING));
        dsa.update(this.game.getBytes(ENCODING));
        dsa.update(this.version.getBytes(ENCODING));
        dsa.update(String.valueOf(this.installation).getBytes(ENCODING));
        dsa.update(this.prize.getBytes(ENCODING));
        this.code = dsa.sign();
    }

    public byte[] getCode() {
        return this.code;
    }

    public void setCode(byte[] code) {
        this.code = code;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("NewsletterIncentive [email=");
        builder.append(this.email);
        builder.append(", game=");
        builder.append(this.game);
        builder.append(", version=");
        builder.append(this.version);
        builder.append(", installation=");
        builder.append(this.installation);
        builder.append(", prize=");
        builder.append(this.prize);
        builder.append(", code=");
        builder.append(Arrays.toString(this.code));
        builder.append("]");
        return builder.toString();
    }
}

