/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.video;

import com.fluendo.jst.Caps;
import com.fluendo.jst.CapsListener;
import com.fluendo.jst.Element;
import com.fluendo.jst.Event;
import com.fluendo.jst.Message;
import com.fluendo.jst.Pad;
import com.fluendo.jst.PadListener;
import com.fluendo.jst.Pipeline;
import com.fluendo.jst.Query;
import com.fluendo.plugin.OggDemux;
import com.fluendo.plugin.Queue;
import com.fluendo.plugin.TheoraDec;
import com.fluendo.plugin.VorbisDec;
import com.fluendo.utils.Debug;
import com.shavenpuppy.jglib.opengl.GLTexture;
import com.shavenpuppy.jglib.sound.SoundPlayer;
import com.shavenpuppy.jglib.video.OpenALSink;
import com.shavenpuppy.jglib.video.OpenGLSink;
import com.shavenpuppy.jglib.video.VideoSrc;
import java.awt.Dimension;
import java.awt.Rectangle;

public class VideoPipeline
extends Pipeline
implements PadListener,
CapsListener {
    private final GLTexture videoTexture;
    private final SoundPlayer soundPlayer;
    private final String fileName;
    private int bufferSize = -1;
    private int bufferLow = -1;
    private int bufferHigh = -1;
    private Element src;
    private Element buffer;
    private Element demux;
    private Element videodec;
    private Element audiodec;
    private Element videosink;
    private Element audiosink;
    private Element v_queue;
    private Element v_queue2;
    private Element a_queue = null;
    private Pad asinkpad;
    private Pad apad;
    private Pad vpad;

    public VideoPipeline(GLTexture videoTexture, SoundPlayer soundPlayer, String fileName) {
        super("pipeline");
        this.videoTexture = videoTexture;
        this.soundPlayer = soundPlayer;
        this.fileName = fileName;
    }

    public void padAdded(Pad pad) {
        Caps caps = pad.getCaps();
        if (caps == null) {
            Debug.log(3, "pad added without caps: " + pad);
            return;
        }
        Debug.log(3, "pad added " + pad);
        String mime = caps.getMime();
        if (mime.equals("audio/x-vorbis")) {
            if (this.a_queue != null) {
                Debug.log(3, "More than one audio stream detected, ignoring all except first one");
                return;
            }
            this.a_queue = new Queue();
            this.a_queue.setName("a_queue");
            if (this.v_queue != null) {
                this.v_queue.setProperty("leaky", String.valueOf(2));
            }
            this.audiodec = new VorbisDec();
            this.audiodec.setName("audiodec");
            this.a_queue.setProperty("maxBuffers", "100");
            this.add(this.a_queue);
            this.add(this.audiodec);
            pad.link(this.a_queue.getPad("sink"));
            this.a_queue.getPad("src").link(this.audiodec.getPad("sink"));
            if (!this.audiodec.getPad("src").link(this.asinkpad)) {
                this.postMessage(Message.newError(this, "audiosink already linked"));
                return;
            }
            this.apad = pad;
            this.audiodec.setState(2);
            this.a_queue.setState(2);
        } else if (mime.equals("video/x-theora")) {
            this.v_queue = new Queue();
            this.v_queue.setName("v_queue");
            this.v_queue2 = new Queue();
            this.v_queue2.setName("v_queue2");
            this.videodec = new TheoraDec();
            this.videodec.setName("videodec");
            this.add(this.videodec);
            if (this.a_queue != null) {
                this.v_queue.setProperty("leaky", "2");
            }
            this.v_queue.setProperty("maxBuffers", "175");
            this.v_queue2.setProperty("maxBuffers", "1");
            this.add(this.v_queue);
            this.add(this.v_queue2);
            pad.link(this.v_queue.getPad("sink"));
            this.v_queue.getPad("src").link(this.videodec.getPad("sink"));
            this.videodec.getPad("src").link(this.v_queue2.getPad("sink"));
            this.vpad = pad;
            this.videodec.setState(2);
            this.v_queue.setState(2);
            this.v_queue2.setState(2);
        }
    }

    public void padRemoved(Pad pad) {
        pad.unlink();
        if (pad == this.vpad) {
            Debug.log(3, "video pad removed " + pad);
            this.vpad = null;
        } else if (pad == this.apad) {
            Debug.log(3, "audio pad removed " + pad);
            this.asinkpad.unlink();
            this.apad = null;
        }
    }

    public void noMorePads() {
        boolean changed = false;
        Debug.log(3, "all streams detected");
        if (this.apad == null) {
            Debug.log(3, "file has no audio, remove audiosink");
            this.audiosink.setState(1);
            this.remove(this.audiosink);
            this.audiosink = null;
            changed = true;
        }
        if (this.vpad == null) {
            Debug.log(3, "file has no video, remove videosink");
            this.videosink.setState(1);
            this.remove(this.videosink);
            this.videosink = null;
            changed = true;
        }
        if (changed) {
            this.scheduleReCalcState();
        }
    }

    public void resize(Dimension d) {
        if (this.videosink == null || d == null) {
            return;
        }
        Rectangle bounds = new Rectangle(d);
        if (bounds.height < 0) {
            bounds.height = 0;
        }
        this.videosink.setProperty("bounds", bounds);
    }

    public boolean buildOgg() {
        this.demux = new OggDemux();
        this.demux.setName("demux");
        this.buffer = new Queue();
        this.buffer.setName("buffer");
        this.buffer.setProperty("isBuffer", Boolean.TRUE);
        if (this.bufferSize != -1) {
            this.buffer.setProperty("maxSize", new Integer(this.bufferSize * 1024));
        }
        if (this.bufferLow != -1) {
            this.buffer.setProperty("lowPercent", new Integer(this.bufferLow));
        }
        if (this.bufferHigh != -1) {
            this.buffer.setProperty("highPercent", new Integer(this.bufferHigh));
        }
        this.add(this.demux);
        this.add(this.buffer);
        this.src.getPad("src").link(this.buffer.getPad("sink"));
        this.buffer.getPad("src").link(this.demux.getPad("sink"));
        this.demux.addPadListener(this);
        this.buffer.setState(2);
        this.demux.setState(2);
        return true;
    }

    public void capsChanged(Caps caps) {
        String mime = caps.getMime();
        if (mime.equals("application/ogg")) {
            this.buildOgg();
        } else {
            this.postMessage(Message.newError(this, "unknown type: " + mime));
        }
    }

    private boolean build() {
        this.src = new VideoSrc();
        this.src.setName("videosrc");
        this.add(this.src);
        this.src.getPad("src").addCapsListener(this);
        this.audiosink = new OpenALSink(this.soundPlayer);
        this.audiosink.setName("audiosink");
        this.asinkpad = this.audiosink.getPad("sink");
        this.add(this.audiosink);
        this.videosink = new OpenGLSink(this.videoTexture);
        this.videosink.setName("videosink");
        this.add(this.videosink);
        return true;
    }

    private boolean cleanup() {
        Debug.log(3, "cleanup");
        if (this.src != null) {
            this.remove(this.src);
            this.src = null;
        }
        if (this.audiosink != null) {
            this.remove(this.audiosink);
            this.audiosink = null;
            this.asinkpad = null;
        }
        if (this.videosink != null) {
            this.remove(this.videosink);
            this.videosink = null;
        }
        if (this.buffer != null) {
            this.remove(this.buffer);
            this.buffer = null;
        }
        if (this.demux != null) {
            this.demux.removePadListener(this);
            this.remove(this.demux);
            this.demux = null;
        }
        if (this.v_queue != null) {
            this.remove(this.v_queue);
            this.v_queue = null;
        }
        if (this.v_queue2 != null) {
            this.remove(this.v_queue2);
            this.v_queue2 = null;
        }
        if (this.a_queue != null) {
            this.remove(this.a_queue);
            this.a_queue = null;
        }
        if (this.videodec != null) {
            this.remove(this.videodec);
            this.videodec = null;
        }
        if (this.audiodec != null) {
            this.remove(this.audiodec);
            this.audiodec = null;
        }
        return true;
    }

    protected int changeState(int transition) {
        switch (transition) {
            case 18: {
                if (this.build()) break;
                return 0;
            }
        }
        int res = super.changeState(transition);
        switch (transition) {
            case 33: {
                this.cleanup();
                break;
            }
        }
        return res;
    }

    protected boolean doSendEvent(Event event) {
        if (event.getType() != 5) {
            return false;
        }
        if (event.parseSeekFormat() != 5) {
            return false;
        }
        if (this.src == null) {
            return false;
        }
        boolean res = this.src.getPad("src").sendEvent(event);
        this.getState(null, null, -1L);
        return res;
    }

    protected long getPosition() {
        long result = 0L;
        Query q = Query.newPosition(3);
        if (super.query(q)) {
            result = q.parsePositionValue();
        }
        return result;
    }
}

