/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.sprites;

import com.shavenpuppy.jglib.opengl.GLBaseTexture;
import com.shavenpuppy.jglib.sprites.AbstractAnimated;
import com.shavenpuppy.jglib.sprites.AnimatedAppearance;
import com.shavenpuppy.jglib.sprites.Animation;
import com.shavenpuppy.jglib.sprites.Colored;
import com.shavenpuppy.jglib.sprites.ISprite;
import com.shavenpuppy.jglib.sprites.Imaged;
import com.shavenpuppy.jglib.sprites.SerializedSprite;
import com.shavenpuppy.jglib.sprites.SpriteEngine;
import com.shavenpuppy.jglib.sprites.SpriteImage;
import com.shavenpuppy.jglib.sprites.Style;
import com.shavenpuppy.jglib.util.FPMath;
import com.shavenpuppy.jglib.util.Util;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Stack;
import org.lwjgl.util.Color;
import org.lwjgl.util.ReadableColor;
import org.lwjgl.util.vector.ReadableVector3f;
import org.lwjgl.util.vector.Vector3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sprite
extends AbstractAnimated
implements ISprite,
Imaged,
Colored {
    private static final long serialVersionUID = 1L;
    private static SpriteImage missingImage;
    int index;
    private final SpriteEngine engine;
    private Serializable owner;
    private boolean allocated;
    private SpriteImage image;
    private Style style;
    private GLBaseTexture texture;
    private int layer;
    private int subLayer;
    private float x;
    private float y;
    private float z;
    private float ox;
    private float oy;
    private float oz;
    private float ySortOffset;
    private boolean flash;
    private float tx00;
    private float ty00;
    private float tx01;
    private float ty01;
    private float tx10;
    private float ty10;
    private float tx11;
    private float ty11;
    private final ReadableColor[] color = new ReadableColor[]{Color.WHITE, Color.WHITE, Color.WHITE, Color.WHITE};
    private static final int NO_SCALE;
    private int xscale = NO_SCALE;
    private int yscale = NO_SCALE;
    private int alpha = 255;
    private int angle = 0;
    private boolean visible = true;
    private boolean active = true;
    private boolean mirrored;
    private boolean flipped;
    private boolean doChildOffset;
    private Stack<StackEntry> stack;

    static {
        NO_SCALE = FPMath.fpValue(1);
    }

    Sprite(SpriteEngine engine) {
        this.engine = engine;
    }

    public SpriteEngine getEngine() {
        return this.engine;
    }

    void copy(Sprite src) {
        this.image = src.image;
        this.style = src.style;
        this.texture = src.texture;
        this.layer = src.layer;
        this.subLayer = src.subLayer;
        this.x = src.x;
        this.y = src.y;
        this.z = src.z;
        this.ox = src.ox;
        this.oy = src.oy;
        this.oz = src.oz;
        this.ySortOffset = src.ySortOffset;
        this.flash = src.flash;
        this.tx00 = src.tx00;
        this.ty00 = src.ty00;
        this.tx01 = src.tx01;
        this.ty01 = src.ty01;
        this.tx10 = src.tx10;
        this.ty10 = src.ty10;
        this.tx11 = src.tx11;
        this.ty11 = src.ty11;
        int i = 0;
        while (i < 4) {
            this.color[i] = src.color[i];
            ++i;
        }
        this.xscale = src.xscale;
        this.yscale = src.yscale;
        this.alpha = src.alpha;
        this.angle = src.angle;
        this.visible = src.visible;
        this.active = src.active;
        this.mirrored = src.mirrored;
        this.flipped = src.flipped;
        this.doChildOffset = src.doChildOffset;
    }

    public void init(Serializable newOwner) {
        if (this.allocated) {
            throw new IllegalStateException(this + "Already allocated: " + newOwner + " can't have it!");
        }
        this.allocated = true;
        this.reset();
        this.owner = newOwner;
        this.active = true;
        this.visible = true;
        this.image = null;
        this.flash = false;
        this.ox = 0.0f;
        this.oy = 0.0f;
        this.oz = 0.0f;
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
        this.color[0] = ReadableColor.WHITE;
        this.color[1] = ReadableColor.WHITE;
        this.color[2] = ReadableColor.WHITE;
        this.color[3] = ReadableColor.WHITE;
        this.layer = 0;
        this.subLayer = 0;
        this.xscale = NO_SCALE;
        this.yscale = NO_SCALE;
        this.alpha = 255;
        this.angle = 0;
        this.mirrored = false;
        this.flipped = false;
        this.doChildOffset = false;
        this.style = null;
    }

    public Serializable getOwner() {
        return this.owner;
    }

    @Override
    public float getX() {
        return this.x;
    }

    @Override
    public void setX(float x) {
        this.x = x;
    }

    @Override
    public float getY() {
        return this.y;
    }

    @Override
    public void setY(float y) {
        this.y = y;
    }

    @Override
    public float getZ() {
        return this.z;
    }

    @Override
    public void setZ(float z) {
        this.z = z;
    }

    @Override
    public Vector3f getLocation(Vector3f ret) {
        if (ret == null) {
            ret = new Vector3f(this.x, this.y, this.z);
        } else {
            ret.set(this.x, this.y, this.z);
        }
        return ret;
    }

    @Override
    public void setLocation(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public void setLocation(ReadableVector3f newLocation) {
        this.x = newLocation.getX();
        this.y = newLocation.getY();
        this.z = newLocation.getZ();
    }

    @Override
    public Vector3f getOffset(Vector3f ret) {
        if (ret == null) {
            ret = new Vector3f(this.ox, this.oy, this.oz);
        } else {
            ret.set(this.ox, this.oy, this.oz);
        }
        return ret;
    }

    @Override
    public void setOffset(float ox, float oy, float oz) {
        this.ox = ox;
        this.oy = oy;
        this.oz = oz;
    }

    @Override
    public void setOffset(ReadableVector3f location) {
        this.ox = location.getX();
        this.oy = location.getY();
        this.oz = location.getZ();
    }

    @Override
    public void tick() {
        if (!this.active || this.getAnimation() == null) {
            return;
        }
        if (!this.isPaused()) {
            this.getAnimation().animate(this, this.engine.getTickRate());
        }
    }

    @Override
    public void setFlash(boolean flash) {
        this.flash = flash;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public int getAlpha() {
        return this.alpha;
    }

    @Override
    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    @Override
    public int getXScale() {
        return this.xscale;
    }

    @Override
    public int getYScale() {
        return this.yscale;
    }

    public void setScale(int scale) {
        this.xscale = scale;
        this.yscale = scale;
    }

    @Override
    public void setScale(int xscale, int yscale) {
        this.xscale = xscale;
        this.yscale = yscale;
    }

    @Override
    public void adjustScale(int xscale, int yscale) {
        this.xscale += xscale;
        this.yscale += yscale;
    }

    @Override
    public void adjustAlpha(int delta) {
        this.alpha = Math.max(0, Math.min(255, this.alpha + delta));
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void hide() {
        this.setVisible(false);
    }

    @Override
    public void setColor(int index, ReadableColor color) {
        this.color[index] = color;
    }

    @Override
    public void setColors(ReadableColor src) {
        this.color[0] = src;
        this.color[1] = src;
        this.color[2] = src;
        this.color[3] = src;
    }

    @Override
    public void setAngle(int angle) {
        this.angle = angle % 65535;
    }

    @Override
    public int getAngle() {
        return this.angle;
    }

    @Override
    public void adjustAngle(int delta) {
        this.angle = (this.angle + delta) % 65535;
    }

    @Override
    public ReadableColor getColor(int index) {
        return this.color[index];
    }

    @Override
    public void setImage(SpriteImage image) {
        this.image = image;
        if (image == null) {
            return;
        }
        assert (image.isCreated()) : "Image " + image + " not created!";
        assert (image.getStyle() != null) : "Image " + image + " has no style!";
    }

    @Override
    public void deactivate() {
        this.setActive(false);
    }

    @Override
    public SpriteImage getImage() {
        return this.image;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public Style getStyle() {
        return this.style != null ? this.style : (this.getImage() != null ? this.getImage().getStyle() : null);
    }

    public void moveLocation(int dx, int dy, int dz) {
        this.x += (float)dx;
        this.y += (float)dy;
        this.z += (float)dz;
    }

    public void moveOffset(int dx, int dy, int dz) {
        this.ox += (float)dx;
        this.oy += (float)dy;
        this.oz += (float)dz;
    }

    @Override
    public int getLayer() {
        return this.layer;
    }

    @Override
    public void setLayer(int layer) {
        this.layer = layer;
    }

    @Override
    public void deallocate() {
        if (!this.allocated) {
            assert (false);
            return;
        }
        this.setStyle(null);
        this.allocated = false;
        this.engine.deallocate(this);
        this.owner = null;
    }

    void forceDeallocate() {
        assert (this.allocated);
        this.allocated = false;
        this.visible = false;
    }

    @Override
    public String toString() {
        return "Sprite[idx=" + this.index + ", owner=" + this.owner + ", image=" + this.image + ", active=" + this.active + ", visible=" + this.visible + ", position=" + this.x + "," + this.y + "," + this.z + ", " + this.getAnimation() + ", " + this.getStyle() + "]";
    }

    @Override
    public boolean isFlashing() {
        return this.flash;
    }

    public void setAppearance(AnimatedAppearance appearance) {
        if (appearance == null) {
            this.image = null;
            this.setAnimation(null);
            this.rewind();
        } else {
            appearance.toAnimated(this);
        }
    }

    public boolean isAllocated() {
        return this.allocated;
    }

    @Override
    public boolean isFlipped() {
        return this.flipped;
    }

    @Override
    public void setFlipped(boolean flipped) {
        this.flipped = flipped;
    }

    @Override
    public boolean isMirrored() {
        return this.mirrored;
    }

    @Override
    public void setMirrored(boolean mirrored) {
        this.mirrored = mirrored;
    }

    public boolean isDoChildOffset() {
        return this.doChildOffset;
    }

    public void setDoChildOffset(boolean doChildOffset) {
        this.doChildOffset = doChildOffset;
    }

    public void rotateToTarget(float dirX, float dirY) {
        this.setAngle(FPMath.fpYaklyDegrees(Util.angleFromDirection(dirX, dirY)));
    }

    private Object writeReplace() throws ObjectStreamException {
        SerializedSprite ss = new SerializedSprite();
        ss.fromSprite(this);
        return ss;
    }

    public static void setMissingImage(SpriteImage missingImage) {
        Sprite.missingImage = missingImage;
    }

    public static SpriteImage getMissingImage() {
        return missingImage;
    }

    public float getTx00() {
        return this.tx00;
    }

    public float getTy00() {
        return this.ty00;
    }

    public float getTx01() {
        return this.tx01;
    }

    public float getTy01() {
        return this.ty01;
    }

    public float getTx10() {
        return this.tx10;
    }

    public float getTy10() {
        return this.ty10;
    }

    public float getTx11() {
        return this.tx11;
    }

    public float getTy11() {
        return this.ty11;
    }

    public void setTextureCoords(float tx00, float ty00, float tx10, float ty10, float tx11, float ty11, float tx01, float ty01) {
        this.tx00 = tx00;
        this.ty00 = ty00;
        this.tx10 = tx10;
        this.ty10 = ty10;
        this.tx11 = tx11;
        this.ty11 = ty11;
        this.tx01 = tx01;
        this.ty01 = ty01;
    }

    public void setTexture(GLBaseTexture texture) {
        this.texture = texture;
    }

    public GLBaseTexture getTexture() {
        return this.texture;
    }

    float getOffsetY() {
        return this.oy;
    }

    public void setYSortOffset(float sortOffset) {
        this.ySortOffset = sortOffset;
    }

    public float getYSortOffset() {
        return this.ySortOffset;
    }

    @Override
    public int getSubLayer() {
        return this.subLayer;
    }

    @Override
    public void setSubLayer(int newSubLayer) {
        this.subLayer = newSubLayer;
    }

    @Override
    public void pushSequence() {
        if (this.stack == null) {
            this.stack = new Stack();
        }
        if (this.stack.size() > 10) {
            System.err.println("Stack overflow " + this + "/" + this.getAnimation());
            return;
        }
        this.stack.push(new StackEntry(this.getAnimation(), this.getSequence() + 1));
    }

    @Override
    public void popSequence() {
        if (this.stack == null) {
            return;
        }
        if (this.stack.size() == 0) {
            System.err.println("Stack underflow " + this + "/" + this.getAnimation());
            return;
        }
        StackEntry se = this.stack.pop();
        this.setAnimationNoRewind(se.animation);
        this.setSequence(se.sequence);
    }

    Stack<StackEntry> getStack() {
        return this.stack;
    }

    void setStack(Stack<StackEntry> stack) {
        this.stack = stack;
    }

    static class StackEntry
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final Animation animation;
        final int sequence;

        StackEntry(Animation animation, int sequence) {
            this.animation = animation;
            this.sequence = sequence;
        }
    }
}

