/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.sprites;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.XMLResourceWriter;
import com.shavenpuppy.jglib.sprites.Animated;
import com.shavenpuppy.jglib.sprites.Command;
import com.shavenpuppy.jglib.util.XMLUtil;
import java.io.IOException;
import org.w3c.dom.Element;

public class GotoCommand
extends Command {
    public static final long serialVersionUID = 1L;
    private int newSequenceNumber;
    private String id;

    public boolean execute(Animated target, int tickRate) {
        if (this.id != null) {
            int seq = target.getAnimation().getLabel(this.id);
            if (seq == -1) {
                System.err.println("Warning: " + target.getAnimation() + " missing label " + this.id);
            } else {
                target.setSequence(seq);
            }
        } else {
            target.setSequence(this.newSequenceNumber);
        }
        return true;
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        if (XMLUtil.hasAttribute(element, "id")) {
            this.id = XMLUtil.getString(element, "id");
        } else {
            this.newSequenceNumber = Integer.parseInt(element.getAttribute("seq"));
        }
    }

    protected void doToXML(XMLResourceWriter writer) throws IOException {
        if (this.id != null) {
            writer.writeAttribute("id", this.id, true);
        } else {
            writer.writeAttribute("seq", this.newSequenceNumber, true);
        }
    }
}

