/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.sprites;

import com.shavenpuppy.jglib.opengl.GLRenderable;
import com.shavenpuppy.jglib.sprites.AbstractStyle;
import com.shavenpuppy.jglib.sprites.SimpleRenderer;
import com.shavenpuppy.jglib.util.FloatList;
import java.nio.BufferOverflowException;
import java.util.ArrayList;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.OpenGLException;
import org.lwjgl.util.ReadableColor;
import org.lwjgl.util.ReadablePoint;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.ReadableVector3f;

public abstract class GeometryStyle
extends AbstractStyle
implements SimpleRenderer {
    private final ArrayList<GeometryRun> geometry = new ArrayList(1);
    private transient GeometryRun current;
    private transient FloatList vertices;
    private transient float u;
    private transient float v;
    private transient int c;
    private transient boolean inBeginEnd;
    private transient boolean hasColor;
    private transient boolean hasTexture;

    public final boolean getRenderSprite() {
        return false;
    }

    public final int getStyleID() {
        return this.hashCode();
    }

    public final FloatList build() {
        if (this.vertices == null) {
            this.vertices = new FloatList(true, 128);
        }
        this.vertices.clear();
        this.render();
        return this.vertices;
    }

    public final void setupState() {
    }

    public final void resetState() {
    }

    protected abstract void render();

    public void glBegin(int type) {
        assert (!this.inBeginEnd);
        if (this.current == null) {
            this.current = new GeometryRun();
            this.current.type = type;
            this.current.startVertex = this.current.endVertex = this.vertices.size() >> 3;
        }
        this.inBeginEnd = true;
    }

    public void glRender(GLRenderable renderable) {
        if (this.inBeginEnd) {
            throw new OpenGLException("Must call glEnd first");
        }
        GeometryRun gr = new GeometryRun();
        gr.renderable = renderable;
        this.geometry.add(gr);
    }

    public void glEnd() {
        if (!this.inBeginEnd) {
            throw new OpenGLException("Must call glBegin first");
        }
        this.current.endVertex = this.vertices.size() >> 3;
        if (this.current.endVertex - this.current.startVertex > 0) {
            this.geometry.add(this.current);
        }
        this.current = null;
        this.inBeginEnd = false;
    }

    public void glVertex2f(float x, float y) {
        this.glVertex3f(x, y, 0.0f);
    }

    public void glVertex3f(float x, float y, float z) {
        if (!this.inBeginEnd) {
            throw new OpenGLException("Must call glBegin first");
        }
        try {
            this.vertices.add(x);
            this.vertices.add(y);
            this.vertices.add(z);
            this.vertices.add(this.u);
            this.vertices.add(this.v);
            this.vertices.add(0.0f);
            this.vertices.add(0.0f);
            this.vertices.add(Float.intBitsToFloat(this.c));
        }
        catch (BufferOverflowException e) {
            this.inBeginEnd = false;
            throw e;
        }
    }

    public void glVertex(ReadablePoint vertex) {
        this.glVertex2f(vertex.getX(), vertex.getY());
    }

    public void glVertex(ReadableVector2f vertex) {
        this.glVertex2f(vertex.getX(), vertex.getY());
    }

    public void glVertex(ReadableVector3f vertex) {
        this.glVertex3f(vertex.getX(), vertex.getY(), vertex.getZ());
    }

    public void glTexCoord2f(float u, float v) {
        this.u = u;
        this.v = v;
        this.hasTexture = true;
    }

    public void glColor4ub(byte r, byte g, byte b, byte a) {
        this.c = a << 24 & 0xFF000000 | b << 16 & 0xFF0000 | g << 8 & 0xFF00 | r & 0xFF;
        this.hasColor = true;
    }

    public void glColor3ub(byte r, byte g, byte b) {
        this.glColor4ub(r, g, b, (byte)-1);
    }

    public void glColor4f(float r, float g, float b, float a) {
        this.glColor4ub((byte)(r * 255.0f), (byte)(g * 255.0f), (byte)(b * 255.0f), (byte)(a * 255.0f));
    }

    public void glColor3f(float r, float g, float b) {
        this.glColor4f(r, g, b, 1.0f);
    }

    public void glColor(ReadableColor color) {
        this.glColor4ub(color.getRedByte(), color.getGreenByte(), color.getBlueByte(), color.getAlphaByte());
    }

    public final void render(int vertexOffset) {
        GL11.glEnableClientState((int)32884);
        if (this.hasColor) {
            GL11.glEnableClientState((int)32886);
        }
        if (this.hasTexture) {
            GL11.glEnableClientState((int)32888);
        }
        int n = this.geometry.size();
        int i = 0;
        while (i < n) {
            GeometryRun run = this.geometry.get(i);
            if (run.renderable != null) {
                run.renderable.render();
            } else if (run.endVertex - run.startVertex > 0) {
                GL11.glDrawArrays((int)run.type, (int)(run.startVertex + vertexOffset), (int)(run.endVertex - run.startVertex));
            }
            ++i;
        }
        this.geometry.clear();
        if (this.hasColor) {
            GL11.glDisableClientState((int)32886);
            this.hasColor = false;
        }
        if (this.hasTexture) {
            GL11.glDisableClientState((int)32888);
            this.hasTexture = false;
        }
        GL11.glDisableClientState((int)32884);
    }

    private class GeometryRun {
        GLRenderable renderable;
        int type;
        int startVertex;
        int endVertex;

        private GeometryRun() {
        }
    }
}

