/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.sprites;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.XMLResourceWriter;
import com.shavenpuppy.jglib.resources.ResourceArray;
import com.shavenpuppy.jglib.sprites.Animated;
import com.shavenpuppy.jglib.sprites.AnimatedAppearance;
import com.shavenpuppy.jglib.sprites.Command;
import java.io.IOException;
import org.w3c.dom.Element;

public class FrameCommand
extends Command {
    public static final long serialVersionUID = 1L;
    private static final boolean DEBUG = false;
    private int duration;
    private float childXOffset;
    private float childYOffset;
    private String appearanceName;
    private int idx;
    private transient AnimatedAppearance spriteAppearance;

    public void archive() {
        this.appearanceName = null;
    }

    public boolean execute(Animated target, int tickRate) {
        boolean twiddle;
        int currentSequence = target.getSequence();
        int currentTick = target.getTick();
        if (currentTick >= this.duration) {
            if (this.duration == 0) {
                if (this.appearanceName == null) {
                    target.setFrame(this.idx);
                } else if (this.spriteAppearance != null && this.spriteAppearance.toAnimated(target)) {
                    return false;
                }
            }
            target.setSequence(++currentSequence);
            target.setTick(0);
            target.setChildXOffset(this.childXOffset);
            target.setChildYOffset(this.childYOffset);
            return true;
        }
        target.setTick(currentTick + tickRate);
        if (this.appearanceName == null) {
            twiddle = target.setFrame(this.idx);
        } else {
            if (this.spriteAppearance == null) {
                return false;
            }
            twiddle = this.spriteAppearance.toAnimated(target);
        }
        if (twiddle) {
            return this.duration == 0 && target.getTick() == 0;
        }
        if (this.duration == 0 && target.getTick() == 0) {
            return true;
        }
        target.setChildXOffset(this.childXOffset);
        target.setChildYOffset(this.childYOffset);
        return false;
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        if (element.hasAttribute("idx")) {
            this.idx = Integer.parseInt(element.getAttribute("idx"));
        } else {
            this.appearanceName = element.getAttribute("i");
        }
        this.duration = Integer.parseInt(element.getAttribute("d"));
        this.childXOffset = element.hasAttribute("childXOffset") ? Float.parseFloat(element.getAttribute("childXOffset")) : 0.0f;
        this.childYOffset = element.hasAttribute("childYOffset") ? Float.parseFloat(element.getAttribute("childYOffset")) : 0.0f;
    }

    protected void doToXML(XMLResourceWriter writer) throws IOException {
        if (this.appearanceName != null) {
            writer.writeAttribute("i", this.appearanceName, true);
        } else {
            writer.writeAttribute("idx", this.idx, true);
        }
        writer.writeAttribute("d", this.duration, true);
        writer.writeAttribute("childXOffset", this.childXOffset, false);
        writer.writeAttribute("childYOffset", this.childYOffset, false);
    }

    protected void doCreate() {
        if (this.appearanceName != null) {
            this.spriteAppearance = (AnimatedAppearance)Resources.get(this.appearanceName);
        }
    }

    protected void doDestroy() {
        this.spriteAppearance = null;
    }

    private void updateSpriteAppearanceUsingIndex(Animated target) {
        ResourceArray frameList = target.getFrameList();
        if (frameList != null && this.idx >= 0 && this.idx < frameList.getNumResources()) {
            this.spriteAppearance = (AnimatedAppearance)((Object)frameList.getResource(this.idx));
        }
    }
}

