/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.sprites;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.XMLResourceWriter;
import com.shavenpuppy.jglib.sprites.AlphaCommand;
import com.shavenpuppy.jglib.sprites.AngleCommand;
import com.shavenpuppy.jglib.sprites.AnimColorCommand;
import com.shavenpuppy.jglib.sprites.Animated;
import com.shavenpuppy.jglib.sprites.AnimatedAppearanceResource;
import com.shavenpuppy.jglib.sprites.ColorCommand;
import com.shavenpuppy.jglib.sprites.Command;
import com.shavenpuppy.jglib.sprites.EventCommand;
import com.shavenpuppy.jglib.sprites.FlagCommand;
import com.shavenpuppy.jglib.sprites.FrameCommand;
import com.shavenpuppy.jglib.sprites.FrameListCommand;
import com.shavenpuppy.jglib.sprites.GotoCommand;
import com.shavenpuppy.jglib.sprites.LabelCommand;
import com.shavenpuppy.jglib.sprites.LoopCommand;
import com.shavenpuppy.jglib.sprites.MoveCommand;
import com.shavenpuppy.jglib.sprites.NextCommand;
import com.shavenpuppy.jglib.sprites.OffsetCommand;
import com.shavenpuppy.jglib.sprites.RandomDelayCommand;
import com.shavenpuppy.jglib.sprites.RandomGotoCommand;
import com.shavenpuppy.jglib.sprites.RepeatCommand;
import com.shavenpuppy.jglib.sprites.ReturnCommand;
import com.shavenpuppy.jglib.sprites.ScaleCommand;
import com.shavenpuppy.jglib.sprites.SoundCommand;
import com.shavenpuppy.jglib.sprites.SubCommand;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Animation
extends AnimatedAppearanceResource {
    public static final long serialVersionUID = 1L;
    private static final Map<String, Class<? extends Resource>> commandTagMap = new HashMap<String, Class<? extends Resource>>();
    private Command[] command;
    private Map<String, Integer> labels;

    static {
        commandTagMap.put("angle", AngleCommand.class);
        commandTagMap.put("offset", OffsetCommand.class);
        commandTagMap.put("move", MoveCommand.class);
        commandTagMap.put("scale", ScaleCommand.class);
        commandTagMap.put("frame", FrameCommand.class);
        commandTagMap.put("flag", FlagCommand.class);
        commandTagMap.put("alpha", AlphaCommand.class);
        commandTagMap.put("color", ColorCommand.class);
        commandTagMap.put("animcolor", AnimColorCommand.class);
        commandTagMap.put("goto", GotoCommand.class);
        commandTagMap.put("next", NextCommand.class);
        commandTagMap.put("delay", RandomDelayCommand.class);
        commandTagMap.put("random", RandomGotoCommand.class);
        commandTagMap.put("event", EventCommand.class);
        commandTagMap.put("loop", LoopCommand.class);
        commandTagMap.put("repeat", RepeatCommand.class);
        commandTagMap.put("sound", SoundCommand.class);
        commandTagMap.put("label", LabelCommand.class);
        commandTagMap.put("sub", SubCommand.class);
        commandTagMap.put("return", ReturnCommand.class);
        commandTagMap.put("frameset", FrameListCommand.class);
    }

    public Animation() {
    }

    public Animation(String name) {
        super(name);
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        this.labels = null;
        try {
            loader.pushMap(commandTagMap);
            NodeList childTagList = element.getChildNodes();
            ArrayList<Resource> commandList = new ArrayList<Resource>(childTagList.getLength());
            int i = 0;
            while (i < childTagList.getLength()) {
                if (childTagList.item(i) instanceof Element) {
                    Element childElement = (Element)childTagList.item(i);
                    Resource childResource = loader.load(childElement);
                    if (!(childResource instanceof Command)) {
                        throw new Exception("Only Command resources are allowed inside an Animation; got a " + childResource);
                    }
                    if (childResource instanceof LabelCommand) {
                        String id = ((LabelCommand)childResource).getID();
                        if (this.labels == null) {
                            this.labels = new HashMap<String, Integer>();
                        } else if (this.labels.containsKey(id)) {
                            throw new Exception("Animation " + this + " already contains label " + id);
                        }
                        this.labels.put(id, new Integer(commandList.size()));
                    } else {
                        commandList.add(childResource);
                    }
                }
                ++i;
            }
            this.command = new Command[commandList.size()];
            commandList.toArray(this.command);
        }
        finally {
            loader.popMap();
        }
    }

    protected void doToXML(XMLResourceWriter writer) throws IOException {
        boolean wasCompact = writer.isCompact();
        writer.setCompact(true);
        int i = 0;
        while (i < this.command.length) {
            this.command[i].toXML(writer);
            ++i;
        }
        writer.setCompact(wasCompact);
    }

    protected void doCreate() {
        int i = 0;
        while (i < this.command.length) {
            this.command[i].create();
            ++i;
        }
    }

    protected void doDestroy() {
        int i = 0;
        while (i < this.command.length) {
            this.command[i].destroy();
            ++i;
        }
    }

    public void animate(Animated animated, int tickRate) {
        int currentSequence;
        do {
            if ((currentSequence = animated.getSequence()) >= 0 && currentSequence < this.command.length) continue;
            return;
        } while (this.command[currentSequence].execute(animated, tickRate));
    }

    public int getLabel(String id) {
        if (this.labels == null) {
            return -1;
        }
        Integer ret = this.labels.get(id);
        if (ret == null) {
            return -1;
        }
        return ret;
    }

    public boolean toAnimated(Animated target) {
        target.setAnimation(this);
        return true;
    }
}

