/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.sprites;

import com.shavenpuppy.jglib.resources.ResourceArray;
import com.shavenpuppy.jglib.sprites.Animated;
import com.shavenpuppy.jglib.sprites.AnimatedAppearance;
import com.shavenpuppy.jglib.sprites.Animation;
import java.io.Serializable;

public abstract class AbstractAnimated
implements Animated,
Serializable {
    private static final long serialVersionUID = 1L;
    private Animation animation;
    private ResourceArray frameList;
    private int frame;
    private int loop;
    private int tick;
    private int sequence;
    private int event;
    private boolean paused;
    private float childXOffset;
    private float childYOffset;

    public void reset() {
        this.animation = null;
        this.frameList = null;
        this.sequence = 0;
        this.frame = 0;
        this.tick = 0;
        this.event = 0;
        this.paused = false;
        this.childXOffset = 0.0f;
        this.childYOffset = 0.0f;
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public void setAnimation(Animation animation) {
        if (animation != null) assert (animation.isCreated());
        this.animation = animation;
        this.rewind();
    }

    void setAnimationNoRewind(Animation animation) {
        this.animation = animation;
        this.tick = -1;
    }

    public void rewind() {
        this.sequence = 0;
        this.tick = -1;
        this.tick();
    }

    public int getSequence() {
        return this.sequence;
    }

    public int getTick() {
        return this.tick;
    }

    public void eventReceived(int event) {
    }

    public void setSequence(int newSeq) {
        this.sequence = newSeq;
    }

    public void setTick(int newTick) {
        this.tick = newTick;
    }

    public int getEvent() {
        return this.event;
    }

    public void setEvent(int event) {
        this.event = event;
    }

    public String toString() {
        return "AbstractAnimated[animation=" + this.animation + ", seq=" + this.sequence + ", tick=" + this.tick + ", event=" + this.event + "]";
    }

    public final boolean isPaused() {
        return this.paused;
    }

    public final void setPaused(boolean paused) {
        this.paused = paused;
    }

    public final void addLoop(int d) {
        this.loop += d;
    }

    public final int getLoop() {
        return this.loop;
    }

    public final void setLoop(int i) {
        this.loop = i;
    }

    public float getChildXOffset() {
        return this.childXOffset;
    }

    public void setChildXOffset(float childXOffset) {
        this.childXOffset = childXOffset;
    }

    public float getChildYOffset() {
        return this.childYOffset;
    }

    public void setChildYOffset(float childYOffset) {
        this.childYOffset = childYOffset;
    }

    public void setFrameList(ResourceArray frameList) {
        this.frameList = frameList;
        if (frameList != null) {
            this.updateFrame();
        }
    }

    public ResourceArray getFrameList() {
        return this.frameList;
    }

    public int getFrame() {
        return this.frame;
    }

    public boolean setFrame(int frame) {
        this.frame = frame;
        if (this.frameList != null) {
            return this.updateFrame();
        }
        return false;
    }

    private boolean updateFrame() {
        if (this.frame < 0 || this.frame >= this.frameList.getNumResources()) {
            return false;
        }
        AnimatedAppearance newAppearance = (AnimatedAppearance)((Object)this.frameList.getResource(this.frame));
        if (this.animation != null && newAppearance != this.animation || this.animation == null) {
            return newAppearance.toAnimated(this);
        }
        return false;
    }
}

