/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.openal;

import com.shavenpuppy.jglib.Resource;
import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.Wave;
import com.shavenpuppy.jglib.openal.SoundClip;
import com.shavenpuppy.jglib.resources.WaveWrapper;
import com.shavenpuppy.jglib.util.XMLUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import org.w3c.dom.Element;

public class SoundBank
extends Resource
implements WaveWrapper {
    private static final long serialVersionUID = 1L;
    private String url;
    private transient Wave wave;

    public SoundBank() {
    }

    public SoundBank(String name) {
        super(name);
    }

    public void archive() {
        this.url = null;
    }

    protected void doCreate() {
        try {
            WaveWrapper waveResource = null;
            if (this.url.startsWith("classpath:")) {
                try {
                    this.wave = Wave.read(new BufferedInputStream(this.getClass().getClassLoader().getResourceAsStream(this.url.substring(10))));
                }
                catch (IOException e) {
                    System.out.println("Failed to load system resource: " + this.url.substring(10));
                    throw e;
                }
            } else if (this.url.startsWith("resource:")) {
                waveResource = (WaveWrapper)Resources.get(this.url.substring(9));
            } else {
                this.wave = Wave.read(new BufferedInputStream(new URL(this.url).openStream()));
            }
            if (waveResource != null) {
                this.wave = waveResource.getWave();
            }
            if (this.wave == null) {
                throw new Exception("No wave specified for " + this);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void doDestroy() {
        this.wave = null;
    }

    public void load(Element element, Resource.Loader loader) throws Exception {
        this.url = XMLUtil.getString(element, "url");
        List<Element> children = XMLUtil.getChildren(element, "clip");
        for (Element clipElement : children) {
            SoundClip clip = new SoundClip(XMLUtil.getString(clipElement, "name"), this);
            clip.load(clipElement, loader);
            Resources.put(clip);
        }
    }

    public Wave getWave() throws Exception {
        assert (this.isCreated());
        if (this.wave.getData() == null) {
            this.doCreate();
        }
        return this.wave;
    }

    public int getFrequency() {
        return this.wave.getFrequency();
    }

    public int getType() {
        return this.wave.getType();
    }

    public InputStream getStream() throws Exception {
        return null;
    }
}

