/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.openal;

import com.shavenpuppy.jglib.Resources;
import com.shavenpuppy.jglib.openal.AL;
import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.openal.ALResource;
import com.shavenpuppy.jglib.openal.ALSource;
import com.shavenpuppy.jglib.openal.ALStream;
import com.shavenpuppy.jglib.resources.WaveWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL10;

public class ALStreamInstance
extends ALResource {
    private static final long serialVersionUID = 1L;
    private static final int BUFSIZE = 32768;
    private static final int BUFFERS = 3;
    private static int num;
    private transient ALStream sourceStream;
    private transient String url;
    private transient ALBuffer[] buffers;
    private transient int writeBuf;
    private transient InputStream inputStream;
    private transient byte[] buf;
    private transient ByteBuffer byteBuf;
    private transient int pos;
    private transient int type;
    private transient int frequency;
    private transient int format;
    private transient int numQueued;
    private transient boolean waitForQueue;
    private transient boolean playing;
    private transient boolean startPlaying;
    private transient boolean looped;
    private transient int samplesPlayed;
    private transient int sampleSize;
    private ALSource owner;

    ALStreamInstance(ALStream sourceStream) {
        super("StreamInstance " + num++);
        this.init(sourceStream);
    }

    void init(ALStream sourceStream) {
        this.sourceStream = sourceStream;
        this.url = sourceStream.getURL();
        this.inputStream = sourceStream.getInputStream();
        this.format = sourceStream.getFormat();
        assert (this.url == null && this.inputStream != null || this.url != null && this.inputStream == null);
        this.looped = sourceStream.isLooped();
        this.samplesPlayed = 0;
    }

    public ALStream getSourceStream() {
        return this.sourceStream;
    }

    synchronized void setOwner(ALSource newOwner) {
        if (this.owner != newOwner) {
            this.setPlaying(false);
        }
        this.owner = newOwner;
    }

    public ALSource getOwner() {
        return this.owner;
    }

    public int getType() {
        return this.type;
    }

    public int getFormat() {
        return this.format;
    }

    protected void doALCreate() {
        if (!org.lwjgl.openal.AL.isCreated()) {
            return;
        }
        try {
            this.buffers = new ALBuffer[3];
            int i = 0;
            while (i < this.buffers.length) {
                this.buffers[i] = new ALBuffer("StreamBuffer " + i + "[" + this + "]");
                this.buffers[i].create();
                ++i;
            }
            this.buf = new byte[32768];
            this.byteBuf = BufferUtils.createByteBuffer((int)32768);
            this.initStream();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void initStream() throws Exception {
        if (this.url != null && this.url.startsWith("resource:")) {
            WaveWrapper waveResource = (WaveWrapper)Resources.get(this.url.substring(9));
            if (waveResource == null) {
                throw new RuntimeException("Resource " + this.url + " not found");
            }
            this.inputStream = waveResource.getStream();
            this.type = waveResource.getType();
            this.frequency = waveResource.getFrequency();
        }
        if (this.inputStream == null) {
            throw new Exception("No input stream specified for " + this);
        }
        this.format = AL.translateFormat(this.type);
        switch (this.format) {
            case 4352: {
                this.sampleSize = 1;
                break;
            }
            case 4353: 
            case 4354: {
                this.sampleSize = 2;
                break;
            }
            case 4355: {
                this.sampleSize = 4;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    protected void doALDestroy() {
        if (this.buffers != null) {
            int i = 0;
            while (i < this.buffers.length) {
                this.buffers[i].destroy();
                ++i;
            }
            this.buffers = null;
        }
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
            this.inputStream = null;
        }
        this.buf = null;
        this.byteBuf = null;
    }

    public synchronized boolean isPlaying() {
        return this.playing;
    }

    public synchronized void setPlaying(boolean playing) {
        if (this.playing == playing) {
            return;
        }
        this.playing = playing;
        if (!playing) {
            int processed;
            int queued;
            this.numQueued = 0;
            this.waitForQueue = false;
            this.startPlaying = false;
            this.writeBuf = 0;
            this.owner.stop();
            do {
                if ((queued = AL10.alGetSourcei((int)this.owner.getSourceID(), (int)4117)) <= 0) continue;
                this.owner.dequeue(queued);
            } while (queued > 0);
            do {
                if ((processed = AL10.alGetSourcei((int)this.owner.getSourceID(), (int)4118)) <= 0) continue;
                AL.scratch.ints.clear();
                AL.scratch.ints.limit(processed);
                AL10.alSourceUnqueueBuffers((int)this.owner.getSourceID(), (IntBuffer)AL.scratch.ints);
            } while (processed > 0);
        } else {
            this.startPlaying = true;
        }
        this.notifyAll();
    }

    public int getSamplesPlayed() {
        return this.samplesPlayed;
    }

    void reset() throws Exception {
        if (this.url != null && this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.inputStream = null;
        }
        this.initStream();
    }

    public synchronized void tick() throws Exception {
        int read;
        if (!this.buffers[this.writeBuf].isCreated()) {
            return;
        }
        if (!this.isPlaying()) {
            return;
        }
        if (this.waitForQueue) {
            int processed = AL10.alGetSourcei((int)this.owner.getSourceID(), (int)4118);
            if (processed <= 0) {
                return;
            }
            this.owner.dequeue(processed);
            this.numQueued -= processed;
            this.waitForQueue = false;
        }
        if ((read = this.inputStream.read(this.buf, this.pos, this.buf.length - this.pos)) == -1) {
            if (this.looped) {
                this.initStream();
                this.tick();
            } else if (this.numQueued == 0) {
                this.setPlaying(false);
            } else {
                this.waitForQueue = true;
            }
        } else {
            this.pos += read;
            if (this.pos == this.buf.length) {
                this.pos = 0;
                this.samplesPlayed += this.buf.length / this.sampleSize;
                this.byteBuf.put(this.buf);
                this.byteBuf.flip();
                ALBuffer bufToQueue = this.buffers[this.writeBuf++];
                if (this.writeBuf == this.buffers.length) {
                    this.writeBuf = 0;
                }
                ++this.numQueued;
                if (this.numQueued == this.buffers.length) {
                    this.waitForQueue = true;
                }
                if (this.startPlaying) {
                    this.owner.unattach();
                    this.startPlaying = false;
                }
                AL10.alBufferData((int)bufToQueue.getBufferID(), (int)this.format, (ByteBuffer)this.byteBuf, (int)this.frequency);
                this.owner.queue(bufToQueue);
                if (this.owner.getInt(4112) != 4114) {
                    this.owner.play();
                }
                this.byteBuf.clear();
            }
        }
    }
}

