/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib.openal;

import com.shavenpuppy.jglib.openal.AL;
import com.shavenpuppy.jglib.openal.ALBuffer;
import com.shavenpuppy.jglib.openal.ALBufferID;
import com.shavenpuppy.jglib.openal.ALResource;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.OpenALException;
import org.lwjgl.util.vector.Vector3f;

public class ALSource
extends ALResource {
    public static final long serialVersionUID = 1L;
    private static ArrayList<ALSource> createdSources = new ArrayList(8);
    private transient int source;
    private transient ALBufferID attachedBuffer;

    static synchronized void unattach(ALBuffer buffer) {
        int i = 0;
        while (i < createdSources.size()) {
            ALSource s = createdSources.get(i);
            if (s.attachedBuffer == buffer) {
                s.stop();
                s.unattach();
            }
            ++i;
        }
    }

    public void play() {
        assert (this.isCreated()) : this + " is not created yet";
        AL10.alSourcePlay((int)this.source);
    }

    public void pause() {
        assert (this.isCreated()) : this + " is not created yet";
        AL10.alSourcePause((int)this.source);
    }

    public void stop() {
        assert (this.isCreated()) : this + " is not created yet";
        AL10.alSourceStop((int)this.source);
    }

    public void rewind() {
        assert (this.isCreated()) : this + " is not created yet";
        AL10.alSourceRewind((int)this.source);
    }

    public void set(int property, float value) {
        assert (this.isCreated()) : this + " is not created yet";
        AL10.alSourcef((int)this.source, (int)property, (float)value);
    }

    public void set(int property, float x, float y, float z) {
        assert (this.isCreated()) : this + " is not created yet";
        AL10.alSource3f((int)this.source, (int)property, (float)x, (float)y, (float)z);
    }

    public void set(int property, int value) {
        assert (this.isCreated()) : this + " is not created yet";
        AL10.alSourcei((int)this.source, (int)property, (int)value);
    }

    protected void doALCreate() {
        if (!org.lwjgl.openal.AL.isCreated()) {
            return;
        }
        this.source = AL10.alGenSources();
        createdSources.add(this);
    }

    protected void doALDestroy() {
        if (this.source != 0) {
            this.unattach();
            AL10.alDeleteSources((int)this.source);
            this.source = 0;
            createdSources.remove(this);
        }
    }

    public int getSourceID() {
        assert (this.isCreated()) : this + " is not created yet";
        return this.source;
    }

    public void attach(ALBufferID buffer) {
        assert (this.isCreated()) : this + " is not created yet";
        try {
            this.unattach();
            this.set(4105, buffer.getBufferID());
            this.attachedBuffer = buffer;
        }
        catch (OpenALException e) {
            System.err.println("Failed: " + buffer.getBufferID() + " source: " + this.source);
            throw e;
        }
        if (buffer.isLooped()) {
            this.set(4103, 1);
        } else {
            this.set(4103, 0);
        }
    }

    public void queue(ALBufferID buffer) {
        assert (this.isCreated()) : this + " is not created yet";
        if (this.attachedBuffer != null) {
            this.attachedBuffer = null;
            this.stop();
        }
        try {
            AL10.alSourceQueueBuffers((int)this.source, (int)buffer.getBufferID());
        }
        catch (OpenALException e) {
            System.out.println("Failed to queue " + buffer + " on " + this);
            throw e;
        }
        this.set(4103, 0);
    }

    public void dequeue(int num) {
        assert (this.isCreated()) : this + " is not created yet";
        if (num <= 0 || num > AL.scratch.ints.capacity()) {
            throw new OpenALException("Can't dequeue " + num + " buffers");
        }
        AL.scratch.ints.clear();
        AL.scratch.ints.limit(num);
        AL10.alSourceUnqueueBuffers((int)this.source, (IntBuffer)AL.scratch.ints);
    }

    public void unattach() {
        this.stop();
        if (this.attachedBuffer != null) {
            this.set(4105, 0);
            this.attachedBuffer = null;
        }
    }

    public void setLooped(boolean looped) {
        this.set(4103, looped ? 1 : 0);
    }

    public String toString() {
        return "ALSource[" + this.source + "]";
    }

    public int getInt(int param) {
        assert (this.isCreated()) : this + " is not created yet";
        return AL10.alGetSourcei((int)this.source, (int)param);
    }

    public float getFloat(int param) {
        assert (this.isCreated()) : this + " is not created yet";
        return AL10.alGetSourcef((int)this.source, (int)param);
    }

    public Vector3f getFloats(int param, Vector3f ret) {
        assert (this.isCreated()) : this + " is not created yet";
        AL.scratch.floats.clear();
        AL10.alGetSource((int)this.source, (int)param, (FloatBuffer)AL.scratch.floats);
        if (ret == null) {
            ret = new Vector3f();
        }
        ret.x = AL.scratch.floats.get(0);
        ret.y = AL.scratch.floats.get(1);
        ret.z = AL.scratch.floats.get(2);
        return ret;
    }
}

