/*
 * Decompiled with CFR 0.152.
 */
package com.shavenpuppy.jglib;

import com.shavenpuppy.jglib.Resource;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Resources {
    public static final boolean DEBUG = false;
    private static boolean runMode;
    private static final HashMap<String, Resource> resourceMap;
    private static final HashMap<Class<? extends Resource>, String> classToTagMap;
    private static final HashMap<String, Class<? extends Resource>> tagToClassMap;
    private static final List<Resource> all;
    private static final Set<Resource> unnamedSet;
    private static final List<Resource> queue;
    private static int numCreated;
    private static CreatingCallback creatingCallback;

    static {
        if (System.getProperty("java.protocol.handler.pkgs") == null) {
            System.getProperties().put("java.protocol.handler.pkgs", "com.shavenpuppy.jglib.resources.protocol");
        }
        resourceMap = new HashMap(256, 0.25f);
        classToTagMap = new HashMap();
        tagToClassMap = new HashMap();
        all = new LinkedList<Resource>();
        unnamedSet = new HashSet<Resource>();
        queue = new LinkedList<Resource>();
    }

    private Resources() {
    }

    public static <T extends Resource> T peek(String name) {
        return (T)resourceMap.get(name.toLowerCase());
    }

    public static <T extends Resource> T get(String name) {
        Resource ret = resourceMap.get(name.toLowerCase());
        if (ret == null) {
            System.err.println("WARNING: Resource '" + name + "' not found");
            return null;
        }
        if (!ret.isCreated()) {
            if (creatingCallback != null) {
                creatingCallback.onCreating(ret);
            }
            ret.create();
            ++numCreated;
        }
        return (T)ret;
    }

    public static boolean exists(String name) {
        return resourceMap.containsKey(name.toLowerCase());
    }

    public static void put(Resource resource) {
        if (resource.getName() == null) {
            throw new RuntimeException("Unnamed resource " + resource + " cannot be put in the named set");
        }
        Resource old = resourceMap.put(resource.getName().toLowerCase(), resource);
        if (old != null) {
            old.deregister();
        }
        resource.register();
        all.add(resource);
    }

    public static void add(Resource resource) {
        if (resource.getName() != null) {
            throw new RuntimeException("Named resource " + resource + " cannot be added to the unnamed set.");
        }
        unnamedSet.add(resource);
        resource.register();
        all.add(resource);
    }

    public static void remove(Resource resource) {
        if (unnamedSet.remove(resource)) {
            resource.deregister();
        }
        all.remove(resource);
    }

    public static Resource remove(String name) {
        Resource ret = resourceMap.remove(name.toLowerCase());
        all.remove(ret);
        if (ret != null) {
            ret.destroy();
            ret.deregister();
        }
        return ret;
    }

    static Resource forget(Resource resource) {
        all.remove(resource);
        if (resource.getName() != null) {
            return resourceMap.remove(resource.getName());
        }
        if (unnamedSet.contains(resource)) {
            unnamedSet.remove(resource);
            return resource;
        }
        return null;
    }

    public static void save(OutputStream os) throws IOException {
        BufferedOutputStream bos = null;
        ObjectOutputStream oos = null;
        try {
            bos = new BufferedOutputStream(os);
            oos = new ObjectOutputStream(bos);
            oos.writeObject(all);
            oos.flush();
            bos.flush();
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void load(InputStream is) throws IOException, ClassNotFoundException {
        BufferedInputStream bis = new BufferedInputStream(is);
        ObjectInputStream ois = new ObjectInputStream(bis);
        List newAll = (List)ois.readObject();
        for (Resource res : newAll) {
            if (res.getName() != null) {
                Resources.put(res);
                continue;
            }
            Resources.add(res);
        }
    }

    public static void clear() {
        for (Resource res : resourceMap.values()) {
            if (res == null) continue;
            if (res.isCreated()) {
                res.destroy();
            }
            res.deregister();
        }
        resourceMap.clear();
        for (Resource res : unnamedSet) {
            res.destroy();
        }
        unnamedSet.clear();
        all.clear();
        System.gc();
    }

    public static void reset() {
        for (Resource res : resourceMap.values()) {
            if (res == null || !res.isCreated()) continue;
            res.destroy();
        }
        for (Resource res : unnamedSet) {
            res.destroy();
        }
        System.gc();
    }

    public static int getNumCreated() {
        return numCreated;
    }

    public static CreatingCallback getCreatingCallback() {
        return creatingCallback;
    }

    public static void setCreatingCallback(CreatingCallback creatingCallback) {
        Resources.creatingCallback = creatingCallback;
    }

    public static <T extends Resource> ArrayList<T> list(Class<T> clazz) {
        LinkedList<Resource> ret = new LinkedList<Resource>();
        for (Map.Entry<String, Resource> entry : resourceMap.entrySet()) {
            if (!entry.getValue().named || !clazz.isAssignableFrom(entry.getValue().getClass())) continue;
            ret.add((Resource)clazz.cast(entry.getValue()));
        }
        return new ArrayList(ret);
    }

    public static List<Resource> list() {
        ArrayList<Resource> ret = new ArrayList<Resource>(resourceMap.values());
        ret.addAll(unnamedSet);
        return Collections.unmodifiableList(ret);
    }

    public static void setRunMode(boolean runMode) {
        Resources.runMode = runMode;
    }

    public static boolean isRunMode() {
        return runMode;
    }

    public static void registerTag(Class<? extends Resource> clazz, String tag) {
        classToTagMap.put(clazz, tag);
        tagToClassMap.put(tag, clazz);
    }

    public static String getTag(Class<? extends Resource> clazz) {
        return classToTagMap.get(clazz);
    }

    public static Class<? extends Resource> getMapping(String tag) {
        return tagToClassMap.get(tag);
    }

    public static void create() {
        for (Resource res : resourceMap.values()) {
            res.create();
        }
        for (Resource res : unnamedSet) {
            res.create();
        }
    }

    static void queue(Resource res) {
        queue.add(res);
    }

    public static void dequeue() {
        for (Resource r : queue) {
            r.create();
        }
        queue.clear();
    }

    public static interface CreatingCallback {
        public void onCreating(Resource var1);
    }
}

